/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.EnumSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.DefaultOperationDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.modcluster.ModClusterAddProxy;
import org.jboss.as.modcluster.ModClusterDisable;
import org.jboss.as.modcluster.ModClusterDisableContext;
import org.jboss.as.modcluster.ModClusterEnable;
import org.jboss.as.modcluster.ModClusterEnableContext;
import org.jboss.as.modcluster.ModClusterExtension;
import org.jboss.as.modcluster.ModClusterGetProxyConfiguration;
import org.jboss.as.modcluster.ModClusterGetProxyInfo;
import org.jboss.as.modcluster.ModClusterListProxies;
import org.jboss.as.modcluster.ModClusterRefresh;
import org.jboss.as.modcluster.ModClusterRemoveProxy;
import org.jboss.as.modcluster.ModClusterReset;
import org.jboss.as.modcluster.ModClusterStop;
import org.jboss.as.modcluster.ModClusterStopContext;
import org.jboss.as.modcluster.ModClusterSubsystemAdd;
import org.jboss.as.modcluster.ModClusterSubsystemRemove;
import org.jboss.dmr.ModelType;

public class ModClusterDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition PORT = SimpleAttributeDefinitionBuilder.create((String)"port", (ModelType)ModelType.INT, (boolean)false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setStorageRuntime().build();
    public static final SimpleAttributeDefinition HOST = SimpleAttributeDefinitionBuilder.create((String)"host", (ModelType)ModelType.STRING, (boolean)false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setStorageRuntime().build();
    public static final SimpleAttributeDefinition VIRTUAL_HOST = SimpleAttributeDefinitionBuilder.create((String)"virtualhost", (ModelType)ModelType.STRING, (boolean)false).addFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES).setStorageRuntime().build();
    public static final SimpleAttributeDefinition CONTEXT = SimpleAttributeDefinitionBuilder.create((String)"context", (ModelType)ModelType.STRING, (boolean)false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setStorageRuntime().build();
    public static final SimpleAttributeDefinition WAIT_TIME = SimpleAttributeDefinitionBuilder.create((String)"waittime", (ModelType)ModelType.INT, (boolean)true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setStorageRuntime().build();
    private final boolean runtimeOnly;

    protected ModClusterDefinition(boolean runtimeOnly) {
        super(ModClusterExtension.SUBSYSTEM_PATH, (ResourceDescriptionResolver)ModClusterExtension.getResourceDescriptionResolver(new String[0]), (OperationStepHandler)ModClusterSubsystemAdd.INSTANCE, (OperationStepHandler)ModClusterSubsystemRemove.INSTANCE);
        this.runtimeOnly = runtimeOnly;
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        if (this.runtimeOnly) {
            this.registerRuntimeOperations(registration);
        }
    }

    public void registerRuntimeOperations(ManagementResourceRegistration registration) {
        EnumSet<OperationEntry.Flag> runtimeOnlyFlags = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
        ResourceDescriptionResolver rootResolver = this.getResourceDescriptionResolver();
        DefaultOperationDescriptionProvider listProxiesDescription = new DefaultOperationDescriptionProvider("list-proxies", rootResolver, new AttributeDefinition[0]);
        registration.registerOperationHandler("list-proxies", (OperationStepHandler)ModClusterListProxies.INSTANCE, (DescriptionProvider)listProxiesDescription, false, runtimeOnlyFlags);
        DefaultOperationDescriptionProvider readProxiesInfoDescription = new DefaultOperationDescriptionProvider("read-proxies-info", rootResolver, new AttributeDefinition[0]);
        registration.registerOperationHandler("read-proxies-info", (OperationStepHandler)ModClusterGetProxyInfo.INSTANCE, (DescriptionProvider)readProxiesInfoDescription, false, runtimeOnlyFlags);
        DefaultOperationDescriptionProvider readProxiesInfoConfiguration = new DefaultOperationDescriptionProvider("read-proxies-configuration", rootResolver, new AttributeDefinition[0]);
        registration.registerOperationHandler("read-proxies-configuration", (OperationStepHandler)ModClusterGetProxyConfiguration.INSTANCE, (DescriptionProvider)readProxiesInfoConfiguration, false, runtimeOnlyFlags);
        DefaultOperationDescriptionProvider addProxy = new DefaultOperationDescriptionProvider("add-proxy", rootResolver, new AttributeDefinition[]{HOST, PORT});
        registration.registerOperationHandler("add-proxy", (OperationStepHandler)ModClusterAddProxy.INSTANCE, (DescriptionProvider)addProxy, false);
        DefaultOperationDescriptionProvider removeProxy = new DefaultOperationDescriptionProvider("remove-proxy", rootResolver, new AttributeDefinition[]{HOST, PORT});
        registration.registerOperationHandler("remove-proxy", (OperationStepHandler)ModClusterRemoveProxy.INSTANCE, (DescriptionProvider)removeProxy, false);
        DefaultOperationDescriptionProvider refresh = new DefaultOperationDescriptionProvider("refresh", rootResolver, new AttributeDefinition[0]);
        registration.registerOperationHandler("refresh", (OperationStepHandler)ModClusterRefresh.INSTANCE, (DescriptionProvider)refresh, false, runtimeOnlyFlags);
        DefaultOperationDescriptionProvider reset = new DefaultOperationDescriptionProvider("reset", rootResolver, new AttributeDefinition[0]);
        registration.registerOperationHandler("reset", (OperationStepHandler)ModClusterReset.INSTANCE, (DescriptionProvider)reset, false, runtimeOnlyFlags);
        DefaultOperationDescriptionProvider enable = new DefaultOperationDescriptionProvider("enable", rootResolver, new AttributeDefinition[0]);
        registration.registerOperationHandler("enable", (OperationStepHandler)ModClusterEnable.INSTANCE, (DescriptionProvider)enable, false);
        DefaultOperationDescriptionProvider disable = new DefaultOperationDescriptionProvider("disable", rootResolver, new AttributeDefinition[0]);
        registration.registerOperationHandler("disable", (OperationStepHandler)ModClusterDisable.INSTANCE, (DescriptionProvider)disable, false);
        DefaultOperationDescriptionProvider stop = new DefaultOperationDescriptionProvider("stop", rootResolver, new AttributeDefinition[0]);
        registration.registerOperationHandler("stop", (OperationStepHandler)ModClusterStop.INSTANCE, (DescriptionProvider)stop, false);
        DefaultOperationDescriptionProvider enableContext = new DefaultOperationDescriptionProvider("enable-context", rootResolver, new AttributeDefinition[]{VIRTUAL_HOST, CONTEXT});
        registration.registerOperationHandler("enable-context", (OperationStepHandler)ModClusterEnableContext.INSTANCE, (DescriptionProvider)enableContext, false);
        DefaultOperationDescriptionProvider disableContext = new DefaultOperationDescriptionProvider("disable-context", rootResolver, new AttributeDefinition[]{VIRTUAL_HOST, CONTEXT});
        registration.registerOperationHandler("disable-context", (OperationStepHandler)ModClusterDisableContext.INSTANCE, (DescriptionProvider)disableContext, false);
        DefaultOperationDescriptionProvider stopContext = new DefaultOperationDescriptionProvider("stop-context", rootResolver, new AttributeDefinition[]{VIRTUAL_HOST, CONTEXT, WAIT_TIME});
        registration.registerOperationHandler("stop-context", (OperationStepHandler)ModClusterStopContext.INSTANCE, (DescriptionProvider)stopContext, false);
    }
}

