/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TreeSet;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.BootstrapListener;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.FutureServiceContainer;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.ServerPathManagerService;
import org.jboss.as.server.ServerService;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.mgmt.domain.RemoteFileRepositoryService;
import org.jboss.as.server.moduleservice.ExternalModuleService;
import org.jboss.as.server.moduleservice.ModuleIndexService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.AsyncFuture;

final class ApplicationServerService
implements Service<AsyncFuture<ServiceContainer>> {
    private final List<ServiceActivator> extraServices;
    private final Bootstrap.Configuration configuration;
    private final RunningModeControl runningModeControl;
    private final ControlledProcessState processState;
    private final boolean standalone;
    private volatile FutureServiceContainer futureContainer;
    private volatile long startTime;

    ApplicationServerService(List<ServiceActivator> extraServices, Bootstrap.Configuration configuration, ControlledProcessState processState) {
        this.extraServices = extraServices;
        this.configuration = configuration;
        this.runningModeControl = configuration.getRunningModeControl();
        this.startTime = configuration.getStartTime();
        this.standalone = configuration.getServerEnvironment().isStandalone();
        this.processState = processState;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.processState.setStarting();
        Bootstrap.Configuration configuration = this.configuration;
        ServerEnvironment serverEnvironment = configuration.getServerEnvironment();
        String prettyVersion = serverEnvironment.getProductConfig().getPrettyVersionString();
        ServerLogger.AS_ROOT_LOGGER.serverStarting(prettyVersion);
        if (ServerLogger.CONFIG_LOGGER.isDebugEnabled()) {
            Properties properties = System.getProperties();
            StringBuilder b = new StringBuilder(8192);
            b.append(ServerMessages.MESSAGES.configuredSystemPropertiesLabel());
            for (String property : new TreeSet<String>(properties.stringPropertyNames())) {
                b.append("\n\t").append(property).append(" = ").append(properties.getProperty(property, "<undefined>"));
            }
            ServerLogger.CONFIG_LOGGER.debug(b);
            ServerLogger.CONFIG_LOGGER.debugf(ServerMessages.MESSAGES.vmArgumentsLabel(this.getVMArguments()), new Object[0]);
            if (ServerLogger.CONFIG_LOGGER.isTraceEnabled()) {
                b.setLength(0);
                Map<String, String> env = System.getenv();
                b.append(ServerMessages.MESSAGES.configuredSystemEnvironmentLabel());
                for (String key : new TreeSet<String>(env.keySet())) {
                    b.append("\n\t").append(key).append(" = ").append(env.get(key));
                }
                ServerLogger.CONFIG_LOGGER.trace(b);
            }
        }
        final ServiceTarget serviceTarget = context.getChildTarget();
        ServiceController myController = context.getController();
        final ServiceContainer container = myController.getServiceContainer();
        this.futureContainer = new FutureServiceContainer();
        long startTime = this.startTime;
        if (startTime == -1L) {
            startTime = System.currentTimeMillis();
        } else {
            this.startTime = -1L;
        }
        CurrentServiceContainer.setServiceContainer(context.getController().getServiceContainer());
        BootstrapListener bootstrapListener = new BootstrapListener(container, startTime, serviceTarget, this.futureContainer, prettyVersion);
        serviceTarget.addListener((ServiceListener)bootstrapListener);
        myController.addListener((ServiceListener)bootstrapListener);
        if (this.standalone) {
            ContentRepository.Factory.addService((ServiceTarget)serviceTarget, (File)serverEnvironment.getServerContentDir());
        } else {
            RemoteFileRepositoryService.addService(serviceTarget, serverEnvironment.getServerContentDir());
        }
        DeploymentMountProvider.Factory.addService(serviceTarget);
        ServiceModuleLoader.addService(serviceTarget, configuration);
        ExternalModuleService.addService(serviceTarget);
        ModuleIndexService.addService(serviceTarget);
        AbstractVaultReader vaultReader = ApplicationServerService.service(AbstractVaultReader.class);
        ServerLogger.AS_ROOT_LOGGER.debugf("Using VaultReader %s", vaultReader);
        ServerService.addService(serviceTarget, configuration, this.processState, bootstrapListener, this.runningModeControl, vaultReader);
        ServiceActivatorContext serviceActivatorContext = new ServiceActivatorContext(){

            public ServiceTarget getServiceTarget() {
                return serviceTarget;
            }

            public ServiceRegistry getServiceRegistry() {
                return container;
            }
        };
        for (ServiceActivator activator : this.extraServices) {
            activator.activate(serviceActivatorContext);
        }
        ServerEnvironmentService.addService(serverEnvironment, serviceTarget);
        ServerPathManagerService serverPathManagerService = new ServerPathManagerService();
        ServerPathManagerService.addService(serviceTarget, serverPathManagerService, serverEnvironment);
        if (ServerLogger.AS_ROOT_LOGGER.isDebugEnabled()) {
            long nanos = context.getElapsedTime();
            ServerLogger.AS_ROOT_LOGGER.debugf(prettyVersion + " root service started in %d.%06d ms", nanos / 1000000L, nanos % 1000000L);
        }
    }

    public synchronized void stop(StopContext context) {
        this.processState.setStopping();
        CurrentServiceContainer.setServiceContainer(null);
        String prettyVersion = this.configuration.getServerEnvironment().getProductConfig().getPrettyVersionString();
        ServerLogger.AS_ROOT_LOGGER.serverStopped(prettyVersion, (int)(context.getElapsedTime() / 1000000L));
    }

    public AsyncFuture<ServiceContainer> getValue() throws IllegalStateException, IllegalArgumentException {
        return this.futureContainer;
    }

    private String getVMArguments() {
        StringBuilder result = new StringBuilder(1024);
        RuntimeMXBean rmBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = rmBean.getInputArguments();
        for (String arg : inputArguments) {
            result.append(arg).append(" ");
        }
        return result.toString();
    }

    private static <S> S service(Class<S> service) {
        ServiceLoader<S> serviceLoader = ServiceLoader.load(service);
        Iterator<S> it = serviceLoader.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }
}

