/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module.descriptor;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.annotation.ResourceRootIndexer;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.descriptor.JBossDeploymentStructureParser10;
import org.jboss.as.server.deployment.module.descriptor.JBossDeploymentStructureParser11;
import org.jboss.as.server.deployment.module.descriptor.JBossDeploymentStructureParser12;
import org.jboss.as.server.deployment.module.descriptor.ModuleStructureSpec;
import org.jboss.as.server.deployment.module.descriptor.ParseResult;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VirtualFile;

public class DeploymentStructureDescriptorParser
implements DeploymentUnitProcessor {
    public static final String[] DEPLOYMENT_STRUCTURE_DESCRIPTOR_LOCATIONS = new String[]{"META-INF/jboss-deployment-structure.xml", "WEB-INF/jboss-deployment-structure.xml"};
    private static final AttachmentKey<ParseResult> RESULT_ATTACHMENT_KEY = AttachmentKey.create(ParseResult.class);
    private static final QName ROOT_1_0 = new QName("urn:jboss:deployment-structure:1.0", "jboss-deployment-structure");
    private static final QName ROOT_1_1 = new QName("urn:jboss:deployment-structure:1.1", "jboss-deployment-structure");
    private static final QName ROOT_1_2 = new QName("urn:jboss:deployment-structure:1.2", "jboss-deployment-structure");
    private static final QName ROOT_NO_NAMESPACE = new QName("jboss-deployment-structure");
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    private final AttachmentKey<ModuleStructureSpec> SUB_DEPLOYMENT_STRUCTURE = AttachmentKey.create(ModuleStructureSpec.class);
    private final XMLMapper mapper = XMLMapper.Factory.create();

    public static void registerJBossXMLParsers() {
        DeployerChainAddHandler.addDeploymentProcessor("server", Phase.STRUCTURE, 2576, new JBossAllXmlParserRegisteringProcessor<ParseResult>(ROOT_1_0, RESULT_ATTACHMENT_KEY, JBossDeploymentStructureParser10.JBOSS_ALL_XML_PARSER));
        DeployerChainAddHandler.addDeploymentProcessor("server", Phase.STRUCTURE, 2576, new JBossAllXmlParserRegisteringProcessor<ParseResult>(ROOT_1_1, RESULT_ATTACHMENT_KEY, JBossDeploymentStructureParser11.JBOSS_ALL_XML_PARSER));
        DeployerChainAddHandler.addDeploymentProcessor("server", Phase.STRUCTURE, 2576, new JBossAllXmlParserRegisteringProcessor<ParseResult>(ROOT_1_2, RESULT_ATTACHMENT_KEY, JBossDeploymentStructureParser12.JBOSS_ALL_XML_PARSER));
    }

    public DeploymentStructureDescriptorParser() {
        this.mapper.registerRootElement(ROOT_1_0, (XMLElementReader)JBossDeploymentStructureParser10.INSTANCE);
        this.mapper.registerRootElement(ROOT_1_1, (XMLElementReader)JBossDeploymentStructureParser11.INSTANCE);
        this.mapper.registerRootElement(ROOT_1_2, (XMLElementReader)JBossDeploymentStructureParser12.INSTANCE);
        this.mapper.registerRootElement(ROOT_NO_NAMESPACE, (XMLElementReader)JBossDeploymentStructureParser12.INSTANCE);
    }

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        ServiceModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        if (deploymentUnit.getParent() != null && deploymentRoot.hasAttachment(this.SUB_DEPLOYMENT_STRUCTURE)) {
            ModuleSpecification subModuleSpec = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            this.handleDeployment(deploymentUnit, subModuleSpec, deploymentRoot.getAttachment(this.SUB_DEPLOYMENT_STRUCTURE));
        }
        VirtualFile deploymentFile = null;
        for (String loc : DEPLOYMENT_STRUCTURE_DESCRIPTOR_LOCATIONS) {
            VirtualFile file = deploymentRoot.getRoot().getChild(loc);
            if (!file.exists()) continue;
            deploymentFile = file;
            break;
        }
        ParseResult result = deploymentUnit.getAttachment(RESULT_ATTACHMENT_KEY);
        if (deploymentFile == null && result == null) {
            return;
        }
        if (deploymentUnit.getParent() != null) {
            if (deploymentFile != null) {
                ServerLogger.DEPLOYMENT_LOGGER.jbossDeploymentStructureIgnored(deploymentFile.getPathName());
            }
            if (result != null) {
                ServerLogger.DEPLOYMENT_LOGGER.jbossDeploymentStructureNamespaceIgnored(deploymentUnit.getName());
            }
            return;
        }
        try {
            ModuleStructureSpec rootDeploymentSpecification;
            if (deploymentFile != null) {
                result = this.parse(deploymentFile.getPhysicalFile(), deploymentUnit, moduleLoader);
            }
            ModuleSpecification moduleSpec = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            if (result.getEarSubDeploymentsIsolated() != null) {
                moduleSpec.setSubDeploymentModulesIsolated(result.getEarSubDeploymentsIsolated());
            }
            if ((rootDeploymentSpecification = result.getRootDeploymentSpecification()) != null) {
                this.handleDeployment(deploymentUnit, moduleSpec, rootDeploymentSpecification);
            }
            HashMap<String, ResourceRoot> subDeploymentMap = new HashMap<String, ResourceRoot>();
            List<ResourceRoot> resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
            for (ResourceRoot resourceRoot : resourceRoots) {
                if (!SubDeploymentMarker.isSubDeployment(resourceRoot)) continue;
                subDeploymentMap.put(resourceRoot.getRoot().getPathNameRelativeTo(deploymentRoot.getRoot()), resourceRoot);
            }
            for (Map.Entry entry : result.getSubDeploymentSpecifications().entrySet()) {
                String path = (String)entry.getKey();
                ModuleStructureSpec spec = (ModuleStructureSpec)entry.getValue();
                if (!subDeploymentMap.containsKey(path)) {
                    throw this.subDeploymentNotFound(path, subDeploymentMap.keySet());
                }
                ResourceRoot subDeployment = (ResourceRoot)subDeploymentMap.get(path);
                subDeployment.putAttachment(this.SUB_DEPLOYMENT_STRUCTURE, spec);
            }
            for (ModuleStructureSpec moduleStructureSpec : result.getAdditionalModules()) {
                for (ModuleIdentifier identifier : moduleStructureSpec.getAnnotationModules()) {
                    ServerLogger.DEPLOYMENT_LOGGER.annotationImportIgnored(identifier, moduleStructureSpec.getModuleIdentifier());
                }
                ArrayList<ResourceRoot> additionalModuleResourceRoots = new ArrayList<ResourceRoot>(moduleStructureSpec.getResourceRoots());
                ListIterator itr = additionalModuleResourceRoots.listIterator();
                while (itr.hasNext()) {
                    ResourceRoot resourceRoot = (ResourceRoot)itr.next();
                    if (resourceRoot.getRoot().exists()) continue;
                    ServerLogger.DEPLOYMENT_LOGGER.additionalResourceRootDoesNotExist(resourceRoot.getRoot().getPathName());
                    itr.remove();
                }
                AdditionalModuleSpecification additional = new AdditionalModuleSpecification(moduleStructureSpec.getModuleIdentifier(), additionalModuleResourceRoots);
                additional.addAliases(moduleStructureSpec.getAliases());
                additional.addSystemDependencies(moduleStructureSpec.getModuleDependencies());
                deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_MODULES, additional);
                for (ResourceRoot root : additionalModuleResourceRoots) {
                    ResourceRootIndexer.indexResourceRoot(root);
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException(e);
        }
    }

    private void handleDeployment(DeploymentUnit deploymentUnit, ModuleSpecification moduleSpec, ModuleStructureSpec rootDeploymentSpecification) throws DeploymentUnitProcessingException {
        Map<VirtualFile, ResourceRoot> resourceRoots = this.resourceRoots(deploymentUnit);
        moduleSpec.addUserDependencies(rootDeploymentSpecification.getModuleDependencies());
        moduleSpec.addExclusions(rootDeploymentSpecification.getExclusions());
        moduleSpec.addAliases(rootDeploymentSpecification.getAliases());
        moduleSpec.addModuleSystemDependencies(rootDeploymentSpecification.getSystemDependencies());
        for (ResourceRoot additionalResourceRoot : rootDeploymentSpecification.getResourceRoots()) {
            ResourceRoot existingRoot = resourceRoots.get(additionalResourceRoot.getRoot());
            if (existingRoot != null) {
                existingRoot.merge(additionalResourceRoot);
                continue;
            }
            if (!additionalResourceRoot.getRoot().exists()) {
                ServerLogger.DEPLOYMENT_LOGGER.additionalResourceRootDoesNotExist(additionalResourceRoot.getRoot().getPathName());
                continue;
            }
            deploymentUnit.addToAttachmentList(Attachments.RESOURCE_ROOTS, additionalResourceRoot);
            ResourceRootIndexer.indexResourceRoot(additionalResourceRoot);
            ModuleRootMarker.mark(additionalResourceRoot);
        }
        for (String classFileTransformer : rootDeploymentSpecification.getClassFileTransformers()) {
            moduleSpec.addClassFileTransformer(classFileTransformer);
        }
        for (ModuleIdentifier dependency : rootDeploymentSpecification.getAnnotationModules()) {
            deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_ANNOTATION_INDEXES, dependency);
        }
        moduleSpec.setLocalLast(rootDeploymentSpecification.isLocalLast());
        if (rootDeploymentSpecification.getExcludedSubsystems() != null) {
            deploymentUnit.putAttachment(Attachments.EXCLUDED_SUBSYSTEMS, rootDeploymentSpecification.getExcludedSubsystems());
        }
    }

    private Map<VirtualFile, ResourceRoot> resourceRoots(DeploymentUnit deploymentUnit) {
        HashMap<VirtualFile, ResourceRoot> resourceRoots = new HashMap<VirtualFile, ResourceRoot>();
        for (ResourceRoot root : DeploymentUtils.allResourceRoots(deploymentUnit)) {
            resourceRoots.put(root.getRoot(), root);
        }
        return resourceRoots;
    }

    private DeploymentUnitProcessingException subDeploymentNotFound(String path, Collection<String> subDeployments) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String dep : subDeployments) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(dep);
        }
        return ServerMessages.MESSAGES.subdeploymentNotFound(path, builder);
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        context.removeAttachment(Attachments.EXCLUDED_SUBSYSTEMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult parse(File file, DeploymentUnit deploymentUnit, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw ServerMessages.MESSAGES.deploymentStructureFileNotFound(file);
        }
        try {
            ParseResult parseResult = this.parse(fis, file, deploymentUnit, moduleLoader);
            return parseResult;
        }
        finally {
            DeploymentStructureDescriptorParser.safeClose(fis);
        }
    }

    private void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult parse(InputStream source, File file, DeploymentUnit deploymentUnit, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        ParseResult parseResult;
        XMLInputFactory inputFactory = INPUT_FACTORY;
        this.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
        this.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(source);
        try {
            ParseResult result = new ParseResult(moduleLoader, deploymentUnit);
            this.mapper.parseDocument((Object)result, streamReader);
            parseResult = result;
        }
        catch (Throwable throwable) {
            try {
                DeploymentStructureDescriptorParser.safeClose(streamReader);
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw ServerMessages.MESSAGES.errorLoadingDeploymentStructureFile(file.getPath(), e);
            }
        }
        DeploymentStructureDescriptorParser.safeClose(streamReader);
        return parseResult;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safeClose(XMLStreamReader streamReader) {
        if (streamReader != null) {
            try {
                streamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }
}

