/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import org.apache.log4j.Appender;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConfigurationProperty;
import org.jboss.as.logging.CustomHandlerResourceDefinition;
import org.jboss.as.logging.Filters;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.logmanager.Log4jAppenderHandler;
import org.jboss.as.logging.resolvers.ModelNodeResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.PojoConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

final class HandlerOperations {
    private static final Logger.AttachmentKey<Map<String, String>> DISABLED_HANDLERS_KEY = new Logger.AttachmentKey();
    private static final Object HANDLER_LOCK = new Object();
    static final OperationStepHandler CHANGE_LEVEL = new HandlerUpdateOperationStepHandler(new AttributeDefinition[]{CommonAttributes.LEVEL});
    static final OperationStepHandler REMOVE_HANDLER = new LoggingOperations.LoggingRemoveOperationStepHandler(){

        @Override
        public void performRemove(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            logContextConfiguration.removeHandlerConfiguration(name);
            if (logContextConfiguration.getFormatterNames().contains(name)) {
                logContextConfiguration.removeFormatterConfiguration(name);
            }
            if (logContextConfiguration.getPojoNames().contains(name)) {
                logContextConfiguration.removePojoConfiguration(name);
            }
        }
    };
    static final OperationStepHandler ADD_SUBHANDLER = new HandlerUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            CommonAttributes.HANDLER_NAME.validateAndSet(operation, model);
            model.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()).add(operation.get(CommonAttributes.HANDLER_NAME.getName()));
        }

        @Override
        public void performRuntime(OperationContext context, HandlerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            String handlerName = CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, model).asString();
            if (name.equals(handlerName)) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.cannotAddHandlerToSelf(configuration.getName()));
            }
            if (configuration.getHandlerNames().contains(handlerName)) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.handlerAlreadyDefined(handlerName));
            }
            configuration.addHandlerName(handlerName);
        }
    };
    static final OperationStepHandler REMOVE_SUBHANDLER = new HandlerUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            CommonAttributes.HANDLER_NAME.validateAndSet(operation, model);
            String handlerName = model.get(CommonAttributes.HANDLER_NAME.getName()).asString();
            boolean found = false;
            List handlers = model.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()).asList();
            ArrayList<ModelNode> newHandlers = new ArrayList<ModelNode>(handlers.size());
            for (ModelNode handler : handlers) {
                if (handlerName.equals(handler.asString())) {
                    found = true;
                    continue;
                }
                newHandlers.add(handler);
            }
            if (found) {
                model.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()).set(newHandlers);
            }
        }

        @Override
        public void performRuntime(OperationContext context, HandlerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            configuration.removeHandlerName(CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, model).asString());
        }
    };
    static final OperationStepHandler CHANGE_FILE = new HandlerUpdateOperationStepHandler(new AttributeDefinition[]{CommonAttributes.FILE});
    static final LoggingOperations.LoggingUpdateOperationStepHandler ENABLE_HANDLER = new LoggingOperations.LoggingUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            model.get(CommonAttributes.ENABLED.getName()).set(true);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            HandlerOperations.enableHandler(configuration, name);
        }
    };
    static final LoggingOperations.LoggingUpdateOperationStepHandler DISABLE_HANDLER = new LoggingOperations.LoggingUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            model.get(CommonAttributes.ENABLED.getName()).set(false);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            HandlerOperations.disableHandler(configuration, name);
        }
    };

    HandlerOperations() {
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LogContextConfiguration logContextConfiguration, HandlerConfiguration configuration) throws OperationFailedException {
        HandlerOperations.handleProperty(attribute, context, model, logContextConfiguration, configuration, true);
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LogContextConfiguration logContextConfiguration, HandlerConfiguration configuration, boolean resolveValue) throws OperationFailedException {
        if (attribute.getName().equals(CommonAttributes.ENABLED.getName())) {
            boolean value;
            boolean bl = value = resolveValue ? CommonAttributes.ENABLED.resolveModelAttribute(context, model).asBoolean() : model.asBoolean();
            if (value) {
                HandlerOperations.enableHandler(logContextConfiguration, configuration.getName());
            } else {
                HandlerOperations.disableHandler(logContextConfiguration, configuration.getName());
            }
        } else if (attribute.getName().equals(CommonAttributes.ENCODING.getName())) {
            String resolvedValue = resolveValue ? CommonAttributes.ENCODING.resolvePropertyValue(context, model) : (model.isDefined() ? model.asString() : null);
            configuration.setEncoding(resolvedValue);
        } else if (attribute.getName().equals(CommonAttributes.FORMATTER.getName())) {
            String formatterName = configuration.getName();
            FormatterConfiguration fmtConfig = logContextConfiguration.getFormatterNames().contains(formatterName) ? logContextConfiguration.getFormatterConfiguration(formatterName) : logContextConfiguration.addFormatterConfiguration(null, PatternFormatter.class.getName(), formatterName, new String[]{"pattern"});
            String resolvedValue = resolveValue ? CommonAttributes.FORMATTER.resolvePropertyValue(context, model) : model.asString();
            fmtConfig.setPropertyValueString("pattern", resolvedValue);
            configuration.setFormatterName(formatterName);
        } else if (attribute.getName().equals(CommonAttributes.FILTER_SPEC.getName())) {
            ModelNode valueNode = resolveValue ? CommonAttributes.FILTER_SPEC.resolveModelAttribute(context, model) : model;
            String resolvedValue = valueNode.isDefined() ? valueNode.asString() : null;
            configuration.setFilter(resolvedValue);
        } else if (attribute.getName().equals(CommonAttributes.LEVEL.getName())) {
            String resolvedValue = resolveValue ? CommonAttributes.LEVEL.resolvePropertyValue(context, model) : CommonAttributes.LEVEL.resolver().resolveValue(context, model);
            configuration.setLevel(resolvedValue);
        } else if (attribute.getName().equals(AsyncHandlerResourceDefinition.SUBHANDLERS.getName())) {
            Set<String> resolvedValue;
            Set<String> set = resolvedValue = resolveValue ? AsyncHandlerResourceDefinition.SUBHANDLERS.resolvePropertyValue(context, model) : AsyncHandlerResourceDefinition.SUBHANDLERS.resolver().resolveValue(context, model);
            if (resolvedValue.contains(configuration.getName())) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.cannotAddHandlerToSelf(configuration.getName()));
            }
            configuration.setHandlerNames(resolvedValue);
        } else if (!attribute.getName().equals(CommonAttributes.HANDLER_NAME.getName())) {
            if (attribute.getName().equals(CustomHandlerResourceDefinition.PROPERTIES.getName())) {
                PojoConfiguration pojoConfiguration = logContextConfiguration.getPojoConfiguration(configuration.getName());
                Object propertyConfigurable = pojoConfiguration == null ? configuration : pojoConfiguration;
                if (model.hasDefined(CustomHandlerResourceDefinition.PROPERTIES.getName())) {
                    ModelNode resolvedValue = resolveValue ? CustomHandlerResourceDefinition.PROPERTIES.resolveModelAttribute(context, model) : model;
                    for (Property property : resolvedValue.asPropertyList()) {
                        propertyConfigurable.setPropertyValueString(property.getName(), property.getValue().asString());
                    }
                }
            } else if (attribute instanceof ConfigurationProperty) {
                ConfigurationProperty configurationProperty = (ConfigurationProperty)attribute;
                if (resolveValue) {
                    configurationProperty.setPropertyValue(context, model, (PropertyConfigurable)configuration);
                } else {
                    ModelNodeResolver resolver = configurationProperty.resolver();
                    String resolvedValue = resolver == null ? model.asString() : (String)resolver.resolveValue(context, model);
                    configuration.setPropertyValueString(configurationProperty.getPropertyName(), resolvedValue == null ? null : resolvedValue);
                }
            } else {
                LoggingLogger.ROOT_LOGGER.invalidPropertyAttribute(attribute.getName());
            }
        }
    }

    private static boolean equalValue(AttributeDefinition attribute, OperationContext context, ModelNode model, LogContextConfiguration logContextConfiguration, HandlerConfiguration configuration) throws OperationFailedException {
        boolean result;
        if (attribute.getName().equals(CommonAttributes.ENABLED.getName())) {
            boolean resolvedValue = CommonAttributes.ENABLED.resolveModelAttribute(context, model).asBoolean();
            boolean currentValue = configuration.hasProperty(CommonAttributes.ENABLED.getPropertyName()) ? Boolean.parseBoolean(configuration.getPropertyValueString(CommonAttributes.ENABLED.getPropertyName())) : HandlerOperations.isDisabledHandler(logContextConfiguration.getLogContext(), configuration.getName());
            result = resolvedValue == currentValue;
        } else if (attribute.getName().equals(CommonAttributes.ENCODING.getName())) {
            String resolvedValue = CommonAttributes.ENCODING.resolvePropertyValue(context, model);
            String currentValue = configuration.getEncoding();
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
        } else if (attribute.getName().equals(CommonAttributes.FORMATTER.getName())) {
            String formatterName = configuration.getName();
            if (logContextConfiguration.getFormatterNames().contains(formatterName)) {
                FormatterConfiguration fmtConfig = logContextConfiguration.getFormatterConfiguration(formatterName);
                String resolvedValue = CommonAttributes.FORMATTER.resolvePropertyValue(context, model);
                String currentValue = fmtConfig.getPropertyValueString("pattern");
                result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
            } else {
                result = false;
            }
        } else if (attribute.getName().equals(CommonAttributes.FILTER_SPEC.getName())) {
            ModelNode valueNode = CommonAttributes.FILTER_SPEC.resolveModelAttribute(context, model);
            String resolvedValue = valueNode.isDefined() ? valueNode.asString() : null;
            String currentValue = configuration.getFilter();
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
        } else if (attribute.getName().equals(CommonAttributes.LEVEL.getName())) {
            String resolvedValue = CommonAttributes.LEVEL.resolvePropertyValue(context, model);
            String currentValue = configuration.getLevel();
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(configuration.getLevel());
        } else if (attribute.getName().equals(AsyncHandlerResourceDefinition.SUBHANDLERS.getName())) {
            Object resolvedValue = AsyncHandlerResourceDefinition.SUBHANDLERS.resolvePropertyValue(context, model);
            List currentValue = configuration.getHandlerNames();
            result = resolvedValue == null ? currentValue == null : resolvedValue.containsAll(currentValue);
        } else if (attribute.getName().equals(CustomHandlerResourceDefinition.PROPERTIES.getName())) {
            result = true;
            PojoConfiguration pojoConfiguration = logContextConfiguration.getPojoConfiguration(configuration.getName());
            Object propertyConfigurable = pojoConfiguration == null ? configuration : pojoConfiguration;
            if (model.hasDefined(CustomHandlerResourceDefinition.PROPERTIES.getName())) {
                for (Property property : CustomHandlerResourceDefinition.PROPERTIES.resolveModelAttribute(context, model).asPropertyList()) {
                    String resolvedValue = property.getValue().asString();
                    String currentValue = propertyConfigurable.getPropertyValueString(property.getName());
                    if (resolvedValue != null ? resolvedValue.equals(currentValue) : currentValue == null) continue;
                    return false;
                }
            } else if (model.has(CustomHandlerResourceDefinition.PROPERTIES.getName())) {
                List propertyNames = propertyConfigurable.getPropertyNames();
                for (String propertyName : propertyNames) {
                    String propertyValue = propertyConfigurable.getPropertyValueString(propertyName);
                    if (propertyValue == null) continue;
                    return false;
                }
            }
        } else if (attribute instanceof PropertyAttributeDefinition) {
            PropertyAttributeDefinition propAttribute = (PropertyAttributeDefinition)attribute;
            String resolvedValue = propAttribute.resolvePropertyValue(context, model);
            String currentValue = configuration.getPropertyValueString(propAttribute.getPropertyName());
            result = resolvedValue == null ? currentValue == null : resolvedValue.equals(currentValue);
        } else {
            result = false;
        }
        return result;
    }

    static boolean isDisabledHandler(LogContext logContext, String handlerName) {
        Map disableHandlers = (Map)logContext.getAttachment("", DISABLED_HANDLERS_KEY);
        return disableHandlers != null && disableHandlers.containsKey(handlerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void enableHandler(LogContextConfiguration configuration, String handlerName) {
        HandlerConfiguration handlerConfiguration = configuration.getHandlerConfiguration(handlerName);
        try {
            handlerConfiguration.setPropertyValueString("enabled", "true");
            return;
        }
        catch (IllegalArgumentException e) {
            Map disableHandlers = (Map)configuration.getLogContext().getAttachment("", DISABLED_HANDLERS_KEY);
            if (disableHandlers != null && disableHandlers.containsKey(handlerName)) {
                Object object = HANDLER_LOCK;
                synchronized (object) {
                    String filter = (String)disableHandlers.get(handlerName);
                    handlerConfiguration.setFilter(filter);
                    disableHandlers.remove(handlerName);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableHandler(LogContextConfiguration configuration, String handlerName) {
        HandlerConfiguration handlerConfiguration = configuration.getHandlerConfiguration(handlerName);
        try {
            handlerConfiguration.setPropertyValueString("enabled", "false");
            return;
        }
        catch (IllegalArgumentException e) {
            Logger root = configuration.getLogContext().getLogger("");
            Map<String, String> disableHandlers = (HashMap<String, String>)root.getAttachment(DISABLED_HANDLERS_KEY);
            Object object = HANDLER_LOCK;
            synchronized (object) {
                Map current;
                if (disableHandlers == null && (current = (Map)root.attachIfAbsent(DISABLED_HANDLERS_KEY, disableHandlers = new HashMap<String, String>())) != null) {
                    disableHandlers = current;
                }
                if (!disableHandlers.containsKey(handlerName)) {
                    disableHandlers.put(handlerName, handlerConfiguration.getFilter());
                    handlerConfiguration.setFilter(CommonAttributes.DENY.getName());
                }
            }
            return;
        }
    }

    static class LogHandlerWriteAttributeHandler
    extends LoggingOperations.LoggingWriteAttributeHandler {
        protected LogHandlerWriteAttributeHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            boolean restartRequired;
            block21: {
                restartRequired = false;
                if (!logContextConfiguration.getHandlerNames().contains(addressName)) break block21;
                HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(addressName);
                if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, value, logContextConfiguration, configuration, false);
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.FILTER_SPEC, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.FILTER_SPEC.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.FILTER_SPEC, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.FORMATTER.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.FORMATTER, context, value, logContextConfiguration, configuration, false);
                } else if (CommonAttributes.ENCODING.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)CommonAttributes.ENCODING, context, value, logContextConfiguration, configuration, false);
                } else if (AsyncHandlerResourceDefinition.SUBHANDLERS.getName().equals(attributeName)) {
                    HandlerOperations.handleProperty((AttributeDefinition)AsyncHandlerResourceDefinition.SUBHANDLERS, context, value, logContextConfiguration, configuration, false);
                } else if (CustomHandlerResourceDefinition.PROPERTIES.getName().equals(attributeName)) {
                    PojoConfiguration pojoConfiguration = logContextConfiguration.getPojoConfiguration(configuration.getName());
                    Object propertyConfigurable = pojoConfiguration == null ? configuration : pojoConfiguration;
                    if (value.isDefined()) {
                        for (Property property : value.asPropertyList()) {
                            propertyConfigurable.setPropertyValueString(property.getName(), property.getValue().asString());
                        }
                    } else {
                        List propertyNames = propertyConfigurable.getPropertyNames();
                        for (String propertyName : propertyNames) {
                            if (propertyName.equals("enabled")) continue;
                            propertyConfigurable.removeProperty(propertyName);
                            restartRequired = true;
                        }
                    }
                } else if (AsyncHandlerResourceDefinition.QUEUE_LENGTH.getName().equals(attributeName)) {
                    restartRequired = true;
                } else {
                    for (AttributeDefinition attribute : this.getAttributes()) {
                        if (!attribute.getName().equals(attributeName)) continue;
                        HandlerOperations.handleProperty(attribute, context, value, logContextConfiguration, configuration, false);
                        restartRequired = Logging.requiresRestart(attribute.getFlags());
                        break;
                    }
                }
            }
            return restartRequired;
        }

        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
            if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                String filterSpec = Filters.filterToFilterSpec(newValue);
                ModelNode filterSpecValue = filterSpec == null ? new ModelNode() : new ModelNode(filterSpec);
                model.getModel().get(CommonAttributes.FILTER_SPEC.getName()).set(filterSpecValue);
            }
        }
    }

    static class HandlerAddOperationStepHandler
    extends LoggingOperations.LoggingAddOperationStepHandler {
        private final String[] constructionProperties;
        private final AttributeDefinition[] attributes;
        private final Class<? extends Handler> type;

        protected HandlerAddOperationStepHandler(Class<? extends Handler> type, AttributeDefinition[] attributes) {
            this.type = type;
            this.constructionProperties = null;
            this.attributes = attributes;
        }

        protected HandlerAddOperationStepHandler(Class<? extends Handler> type, AttributeDefinition[] attributes, ConfigurationProperty<?> ... constructionProperties) {
            this.type = type;
            this.attributes = attributes;
            ArrayList<String> names = new ArrayList<String>();
            for (ConfigurationProperty<?> prop : constructionProperties) {
                names.add(prop.getPropertyName());
            }
            this.constructionProperties = names.toArray(new String[names.size()]);
        }

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                if (CommonAttributes.FILTER.equals(attribute)) {
                    ModelNode filter = CommonAttributes.FILTER.validateOperation(operation);
                    if (!filter.isDefined()) continue;
                    String value = Filters.filterToFilterSpec(filter);
                    model.get(CommonAttributes.FILTER_SPEC.getName()).set(value);
                    continue;
                }
                attribute.validateAndSet(operation, model);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            boolean exists;
            String moduleName;
            String className;
            if (this.type == null) {
                className = CustomHandlerResourceDefinition.CLASS.resolveModelAttribute(context, model).asString();
                moduleName = CustomHandlerResourceDefinition.MODULE.resolveModelAttribute(context, model).asString();
            } else {
                className = this.type.getName();
                moduleName = null;
            }
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
            boolean bl = exists = configuration != null;
            if (!exists) {
                LoggingLogger.ROOT_LOGGER.tracef("Adding handler '%s' at '%s'", name, LoggingOperations.getAddress(operation));
                configuration = this.createHandlerConfiguration(className, moduleName, name, logContextConfiguration);
            } else if (!className.equals(configuration.getClassName()) || (moduleName == null ? configuration.getModuleName() != null : !moduleName.equals(configuration.getModuleName()))) {
                LoggingLogger.ROOT_LOGGER.replacingNamedHandler(name);
                LoggingLogger.ROOT_LOGGER.debugf("Removing handler %s of type '%s' in module '%s' and replacing with type '%s' in module '%s'", new Object[]{name, configuration.getClassName(), configuration.getModuleName(), className, moduleName});
                logContextConfiguration.removeHandlerConfiguration(name);
                if (logContextConfiguration.getPojoNames().contains(name)) {
                    logContextConfiguration.removePojoConfiguration(name);
                }
                configuration = this.createHandlerConfiguration(className, moduleName, name, logContextConfiguration);
            }
            for (AttributeDefinition attribute : this.attributes) {
                boolean skip;
                if (attribute.equals(CustomHandlerResourceDefinition.CLASS) || attribute.equals(CustomHandlerResourceDefinition.MODULE) || attribute.equals(CommonAttributes.FILTER)) {
                    skip = true;
                } else {
                    boolean bl2 = skip = exists && HandlerOperations.equalValue(attribute, context, model, logContextConfiguration, configuration);
                }
                if (skip) continue;
                HandlerOperations.handleProperty(attribute, context, model, logContextConfiguration, configuration);
            }
        }

        protected HandlerConfiguration createHandlerConfiguration(String className, String moduleName, String name, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            HandlerConfiguration configuration;
            if (moduleName != null) {
                ModuleLoader moduleLoader = ModuleLoader.forClass(HandlerOperations.class);
                ModuleIdentifier id = ModuleIdentifier.create((String)moduleName);
                try {
                    Class<?> actualClass = Class.forName(className, false, (ClassLoader)moduleLoader.loadModule(id).getClassLoader());
                    if (Appender.class.isAssignableFrom(actualClass)) {
                        if (this.constructionProperties == null) {
                            logContextConfiguration.addPojoConfiguration(moduleName, className, name, new String[0]);
                        } else {
                            logContextConfiguration.addPojoConfiguration(moduleName, className, name, this.constructionProperties);
                        }
                        configuration = logContextConfiguration.addHandlerConfiguration("org.jboss.as.logging", Log4jAppenderHandler.class.getName(), name, new String[0]);
                        configuration.addPostConfigurationMethod("activate");
                        configuration.setPropertyValueString("appender", name);
                    }
                    if (this.constructionProperties == null) {
                        configuration = logContextConfiguration.addHandlerConfiguration(moduleName, className, name, new String[0]);
                    }
                    configuration = logContextConfiguration.addHandlerConfiguration(moduleName, className, name, this.constructionProperties);
                }
                catch (ClassNotFoundException e) {
                    throw Logging.createOperationFailure(LoggingMessages.MESSAGES.classNotFound(e, className));
                }
                catch (ModuleLoadException e) {
                    throw LoggingMessages.MESSAGES.cannotLoadModule(e, moduleName, "handler", name);
                }
            } else {
                configuration = this.constructionProperties == null ? logContextConfiguration.addHandlerConfiguration(moduleName, className, name, new String[0]) : logContextConfiguration.addHandlerConfiguration(moduleName, className, name, this.constructionProperties);
            }
            return configuration;
        }
    }

    static class HandlerUpdateOperationStepHandler
    extends LoggingOperations.LoggingUpdateOperationStepHandler {
        private final AttributeDefinition[] attributes;

        protected HandlerUpdateOperationStepHandler() {
            this.attributes = null;
        }

        protected HandlerUpdateOperationStepHandler(AttributeDefinition ... attributes) {
            this.attributes = attributes;
        }

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                if (CommonAttributes.FILTER.equals(attribute)) {
                    ModelNode filter = CommonAttributes.FILTER.validateOperation(operation);
                    if (!filter.isDefined()) continue;
                    String value = Filters.filterToFilterSpec(filter);
                    model.get(CommonAttributes.FILTER_SPEC.getName()).set(value);
                    continue;
                }
                if (!operation.has(attribute.getName())) continue;
                attribute.validateAndSet(operation, model);
            }
        }

        @Override
        public final void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            HandlerConfiguration configuration = logContextConfiguration.getHandlerConfiguration(name);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.handlerConfigurationNotFound(name));
            }
            if (this.attributes != null) {
                boolean restartRequired = false;
                boolean reloadRequired = false;
                for (AttributeDefinition attribute : this.attributes) {
                    if (!operation.has(attribute.getName())) continue;
                    HandlerOperations.handleProperty(attribute, context, model, logContextConfiguration, configuration);
                    restartRequired = restartRequired || Logging.requiresRestart(attribute.getFlags());
                    reloadRequired = reloadRequired || Logging.requiresReload(attribute.getFlags());
                }
                if (restartRequired) {
                    context.restartRequired();
                } else if (reloadRequired) {
                    context.reloadRequired();
                }
            }
            this.performRuntime(context, configuration, name, model);
        }

        public void performRuntime(OperationContext context, HandlerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
        }
    }
}

