/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jgroups.Channel;
import org.jgroups.stack.Protocol;

public class ChannelInstanceResource
implements Resource {
    public static final ServiceName CHANNEL_PARENT = ServiceName.of((String[])new String[]{"jboss", "jgroups", "channel"});
    public static final int CHANNEL_PREFIX_LENGTH = CHANNEL_PARENT.toString().length();
    public static final String JGROUPS_PROTOCOL_PKG = "org.jgroups.protocols";
    public static final String JGROUPS_PROTOCOL_PACKAGE = "package org.jgroups.protocols";
    private static final String SHARED_TRANSPORT_PROTOCOL = "TP.ProtocolAdapter";
    private final ServiceController controller;

    public ChannelInstanceResource(ServiceController controller) {
        this.controller = controller;
    }

    public ServiceController getController() {
        return this.controller;
    }

    public Channel getChannel() {
        if (this.getController() == null) {
            return null;
        }
        return (Channel)this.controller.getValue();
    }

    public ModelNode getModel() {
        return new ModelNode();
    }

    public void writeModel(ModelNode newModel) {
        throw ControllerMessages.MESSAGES.immutableResource();
    }

    public boolean isModelDefined() {
        return false;
    }

    public boolean hasChild(PathElement element) {
        if ("protocol".equals(element.getKey())) {
            return this.hasProtocol(element);
        }
        return false;
    }

    public Resource requireChild(PathElement element) {
        if ("protocol".equals(element.getKey()) && this.hasProtocol(element)) {
            return PlaceholderResource.INSTANCE;
        }
        throw new Resource.NoSuchResourceException(element);
    }

    public Resource getChild(PathElement element) {
        return this.hasProtocol(element) ? PlaceholderResource.INSTANCE : null;
    }

    public Resource removeChild(PathElement address) {
        throw ControllerMessages.MESSAGES.immutableResource();
    }

    public void registerChild(PathElement address, Resource resource) {
        throw ControllerMessages.MESSAGES.immutableResource();
    }

    public boolean hasChildren(String childType) {
        if ("protocol".equals(childType)) {
            return this.getChildrenNames("protocol").size() > 0;
        }
        return false;
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("protocol".equals(childType)) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
            for (String name : this.getProtocolNames()) {
                result.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry("protocol", name));
            }
            return result;
        }
        return Collections.emptySet();
    }

    public Set<String> getChildrenNames(String childType) {
        if ("protocol".equals(childType)) {
            return this.getProtocolNames();
        }
        return Collections.emptySet();
    }

    public Set<String> getChildTypes() {
        HashSet<String> result = new HashSet<String>();
        result.add("protocol");
        return result;
    }

    public Resource navigate(PathAddress address) {
        return Resource.Tools.navigate((Resource)this, (PathAddress)address);
    }

    public Resource clone() {
        ChannelInstanceResource clone = new ChannelInstanceResource(this.getController());
        return clone;
    }

    public boolean isRuntime() {
        return true;
    }

    public boolean isProxy() {
        return false;
    }

    private boolean hasProtocol(PathElement element) {
        String protocolName = element.getValue();
        return this.getProtocolNames().contains(protocolName);
    }

    private Set<String> getProtocolNames() {
        Channel channel = this.getChannel();
        if (channel == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        List protocols = channel.getProtocolStack().getProtocols();
        for (Protocol protocol : protocols) {
            String fullyQualifiedProtocolName = protocol.getClass().getPackage() + "." + protocol.getName();
            String protocolName = fullyQualifiedProtocolName.substring(JGROUPS_PROTOCOL_PACKAGE.length() + 1);
            if (protocolName.equals(SHARED_TRANSPORT_PROTOCOL)) continue;
            names.add(protocolName);
        }
        return names;
    }

    public static class ChannelInstanceResourceEntry
    extends ChannelInstanceResource
    implements Resource.ResourceEntry {
        final PathElement path;

        public ChannelInstanceResourceEntry(ServiceController controller, PathElement path) {
            super(controller);
            this.path = path;
        }

        public ChannelInstanceResourceEntry(ServiceController controller, String type, String name) {
            super(controller);
            this.path = PathElement.pathElement((String)type, (String)name);
        }

        public String getName() {
            return this.path.getValue();
        }

        public PathElement getPathElement() {
            return this.path;
        }

        @Override
        public ChannelInstanceResourceEntry clone() {
            return new ChannelInstanceResourceEntry(this.getController(), this.getPathElement());
        }
    }
}

