/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.List;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsService;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolStackRemove;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceName;

public class JGroupsSubsystemRemove
extends AbstractRemoveStepHandler {
    public static final JGroupsSubsystemRemove INSTANCE = new JGroupsSubsystemRemove();

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode removeSubsystem = Util.createOperation((String)"remove", (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsExtension.SUBSYSTEM_PATH}));
        context.addStep(removeSubsystem, (OperationStepHandler)new OriginalSubsystemRemoveHandler(), OperationContext.Stage.MODEL, true);
        if (model.hasDefined("stack")) {
            List stacks = model.get("stack").asPropertyList();
            for (Property stack : stacks) {
                PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsExtension.SUBSYSTEM_PATH}).append("stack", stack.getName());
                ModelNode removeStack = Util.createOperation((String)"remove", (PathAddress)address);
                context.addStep(removeStack, (OperationStepHandler)ProtocolStackRemove.INSTANCE, OperationContext.Stage.MODEL, true);
            }
        }
        context.stepCompleted();
    }

    static class OriginalSubsystemRemoveHandler
    extends AbstractRemoveStepHandler {
        OriginalSubsystemRemoveHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.removeRuntimeServices(context, operation, model);
        }

        protected void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceName protocolDefaultsService = ProtocolDefaultsService.SERVICE_NAME;
            context.removeService(protocolDefaultsService);
            ServiceName defaultChannelFactoryService = ChannelFactoryService.getServiceName(null);
            context.removeService(defaultChannelFactoryService);
        }
    }
}

