/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.domain.controller.SlaveRegistrationException;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.ReconnectPolicy;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.ProtocolConnectionManager;
import org.jboss.as.protocol.ProtocolConnectionUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.FutureManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementPingRequest;
import org.jboss.as.protocol.mgmt.ManagementPongRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.threads.AsyncFuture;
import org.wildfly.security.manager.WildFlySecurityManager;

class RemoteDomainConnection
extends FutureManagementChannel {
    private static final String CHANNEL_SERVICE_TYPE = "domain";
    private static final long INTERVAL;
    private static final long TIMEOUT;
    private final String localHostName;
    private final String username;
    private final SecurityRealm realm;
    private final ModelNode localHostInfo;
    private final HostRegistrationCallback callback;
    private final ProtocolConnectionManager connectionManager;
    private final ProtocolChannelClient.Configuration configuration;
    private final ManagementChannelHandler channelHandler;
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ManagementPongRequestHandler pongHandler = new ManagementPongRequestHandler();
    private final List<DiscoveryOption> discoveryOptions;
    private URI uri;

    RemoteDomainConnection(String localHostName, ModelNode localHostInfo, ProtocolChannelClient.Configuration configuration, SecurityRealm realm, String username, List<DiscoveryOption> discoveryOptions, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, HostRegistrationCallback callback) {
        this.callback = callback;
        this.localHostName = localHostName;
        this.localHostInfo = localHostInfo;
        this.configuration = configuration;
        this.username = username;
        this.realm = realm;
        this.discoveryOptions = discoveryOptions;
        this.executorService = executorService;
        this.channelHandler = new ManagementChannelHandler((ManagementClientChannelStrategy)this, executorService);
        this.scheduledExecutorService = scheduledExecutorService;
        this.connectionManager = ProtocolConnectionManager.create((ProtocolConnectionManager.ConnectTask)new InitialConnectTask());
    }

    protected void connect() throws IOException {
        this.connectionManager.connect();
    }

    protected ManagementChannelHandler getChannelHandler() {
        return this.channelHandler;
    }

    public Channel getChannel() throws IOException {
        return this.awaitChannel();
    }

    protected void setUri(URI uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RemoteDomainConnection remoteDomainConnection = this;
        synchronized (remoteDomainConnection) {
            try {
                if (this.isConnected()) {
                    try {
                        this.channelHandler.executeRequest((ManagementRequest)new UnregisterModelControllerRequest(), null).getResult().await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            finally {
                try {
                    this.connectionManager.shutdown();
                }
                finally {
                    super.close();
                }
            }
        }
    }

    protected boolean isConnected() {
        return super.isConnected();
    }

    protected Connection openConnection() throws IOException {
        CallbackHandler callbackHandler = null;
        SSLContext sslContext = null;
        if (this.realm != null) {
            sslContext = this.realm.getSSLContext();
            CallbackHandlerFactory handlerFactory = this.realm.getSecretCallbackHandlerFactory();
            if (handlerFactory != null) {
                String username = this.username != null ? this.username : this.localHostName;
                callbackHandler = handlerFactory.getCallbackHandler(username);
            }
        }
        ProtocolConnectionConfiguration config = ProtocolConnectionConfiguration.copy((ProtocolConnectionConfiguration)this.configuration);
        config.setCallbackHandler(callbackHandler);
        config.setSslContext(sslContext);
        config.setUri(this.uri);
        return ProtocolConnectionUtils.connectSync((ProtocolConnectionConfiguration)config);
    }

    public void connectionOpened(Connection connection) throws IOException {
        Channel channel = this.openChannel(connection, CHANNEL_SERVICE_TYPE, this.configuration.getOptionMap());
        if (this.setChannel(channel)) {
            channel.receiveMessage(this.channelHandler.getReceiver());
            channel.addCloseHandler((CloseHandler)this.channelHandler);
            try {
                this.channelHandler.executeRequest((ManagementRequest)new RegisterHostControllerRequest(), null).getResult().get();
            }
            catch (Exception e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
            this.registered();
        } else {
            channel.closeAsync();
        }
    }

    protected Future<Connection> reconnect() {
        return this.executorService.submit(new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                ReconnectPolicy reconnectPolicy = ReconnectPolicy.RECONNECT;
                int reconnectionCount = 0;
                while (true) {
                    String host = null;
                    int port = -1;
                    reconnectPolicy.wait(reconnectionCount);
                    for (DiscoveryOption discoveryOption : RemoteDomainConnection.this.discoveryOptions) {
                        try {
                            discoveryOption.discover();
                            host = discoveryOption.getRemoteDomainControllerHost();
                            port = discoveryOption.getRemoteDomainControllerPort();
                            RemoteDomainConnection.this.setUri(new URI("remote://" + NetworkUtils.formatPossibleIpv6Address((String)host) + ":" + port));
                            HostControllerLogger.ROOT_LOGGER.debugf("trying to reconnect to remote host-controller", new Object[0]);
                            return RemoteDomainConnection.this.connectionManager.connect();
                        }
                        catch (IOException e) {
                            HostControllerLogger.ROOT_LOGGER.debugf(e, "failed to reconnect to the remote host-controller", new Object[0]);
                        }
                        catch (IllegalStateException e) {
                            HostControllerLogger.ROOT_LOGGER.debugf(e, "failed to reconnect to the remote host-controller", new Object[0]);
                        }
                    }
                    ++reconnectionCount;
                }
            }
        });
    }

    ModelNode resolveSubsystemVersions(ModelNode extensions) {
        return this.callback.resolveSubsystemVersions(extensions);
    }

    boolean applyDomainModel(ModelNode result) {
        if (!result.hasDefined("result")) {
            return false;
        }
        List bootOperations = result.get("result").asList();
        return this.callback.applyDomainModel(bootOperations);
    }

    void registered() {
        this.callback.registrationComplete(this.channelHandler);
    }

    private void schedule(PingTask task) {
        this.scheduledExecutorService.schedule(task, INTERVAL, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        long interval = -1L;
        try {
            interval = Long.parseLong(WildFlySecurityManager.getPropertyPrivileged((String)"jboss.as.domain.ping.interval", (String)"15000"));
            INTERVAL = interval > 0L ? interval : 15000L;
        }
        catch (Exception e) {
            INTERVAL = interval > 0L ? interval : 15000L;
            catch (Throwable throwable) {
                INTERVAL = interval > 0L ? interval : 15000L;
                throw throwable;
            }
        }
        long timeout = -1L;
        try {
            timeout = Long.parseLong(WildFlySecurityManager.getPropertyPrivileged((String)"jboss.as.domain.ping.timeout", (String)"30000"));
            TIMEOUT = timeout > 0L ? timeout : 30000L;
        }
        catch (Exception e) {
            TIMEOUT = timeout > 0L ? timeout : 30000L;
            catch (Throwable throwable) {
                TIMEOUT = timeout > 0L ? timeout : 30000L;
                throw throwable;
            }
        }
    }

    class ReconnectTaskWrapper
    implements ProtocolConnectionManager.ConnectTask {
        private final Future<Connection> connectionFuture;

        ReconnectTaskWrapper(Future<Connection> connectionFuture) {
            this.connectionFuture = connectionFuture;
        }

        public Connection connect() throws IOException {
            Connection connection = RemoteDomainConnection.this.openConnection();
            HostControllerLogger.ROOT_LOGGER.reconnectedToMaster();
            return connection;
        }

        public ProtocolConnectionManager.ConnectionOpenHandler getConnectionOpenedHandler() {
            return RemoteDomainConnection.this;
        }

        public ProtocolConnectionManager.ConnectTask connectionClosed() {
            HostControllerLogger.ROOT_LOGGER.lostRemoteDomainConnection();
            return new ReconnectTaskWrapper(RemoteDomainConnection.this.reconnect());
        }

        public void shutdown() {
            this.connectionFuture.cancel(true);
        }
    }

    class InitialConnectTask
    implements ProtocolConnectionManager.ConnectTask {
        InitialConnectTask() {
        }

        public Connection connect() throws IOException {
            return RemoteDomainConnection.this.openConnection();
        }

        public ProtocolConnectionManager.ConnectionOpenHandler getConnectionOpenedHandler() {
            return RemoteDomainConnection.this;
        }

        public ProtocolConnectionManager.ConnectTask connectionClosed() {
            HostControllerLogger.ROOT_LOGGER.lostRemoteDomainConnection();
            return new ReconnectTaskWrapper(RemoteDomainConnection.this.reconnect());
        }

        public void shutdown() {
        }
    }

    private class PingTask
    implements Runnable {
        private Long remoteInstanceID;

        private PingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (RemoteDomainConnection.this.isConnected()) {
                boolean fail = false;
                AsyncFuture future = null;
                try {
                    if (System.currentTimeMillis() - RemoteDomainConnection.this.channelHandler.getLastMessageReceivedTime() > INTERVAL) {
                        future = RemoteDomainConnection.this.channelHandler.executeRequest((ManagementRequest)ManagementPingRequest.INSTANCE, null).getResult();
                        Long id = (Long)future.get(TIMEOUT, TimeUnit.MILLISECONDS);
                        if (this.remoteInstanceID != null && !this.remoteInstanceID.equals(id)) {
                            HostControllerLogger.DOMAIN_LOGGER.masterHostControllerChanged();
                            fail = true;
                        } else {
                            this.remoteInstanceID = id;
                        }
                    }
                }
                catch (IOException e) {
                    HostControllerLogger.DOMAIN_LOGGER.debug("Caught exception sending ping request", e);
                }
                catch (InterruptedException e) {
                    this.safeCancel((Future<?>)future);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    HostControllerLogger.DOMAIN_LOGGER.debug("Caught exception sending ping request", e);
                }
                catch (TimeoutException e) {
                    fail = true;
                    this.safeCancel((Future<?>)future);
                    HostControllerLogger.DOMAIN_LOGGER.masterHostControllerUnreachable(TIMEOUT);
                }
                finally {
                    if (fail) {
                        Channel channel = null;
                        try {
                            channel = RemoteDomainConnection.this.channelHandler.getChannel();
                        }
                        catch (IOException e) {}
                        StreamUtils.safeClose(channel);
                    } else {
                        RemoteDomainConnection.this.schedule(this);
                    }
                }
            }
        }

        void safeCancel(Future<?> future) {
            if (future != null) {
                future.cancel(true);
            }
        }
    }

    private class UnregisterModelControllerRequest
    extends AbstractManagementRequest<Void, Void> {
        private UnregisterModelControllerRequest() {
        }

        public byte getOperationType() {
            return 83;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnection.this.localHostName);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
            HostControllerLogger.ROOT_LOGGER.unregisteredAtRemoteHostController();
            resultHandler.done(null);
        }
    }

    private class CompleteRegistrationRequest
    extends AbstractManagementRequest<Void, Void> {
        private final byte outcome;
        private final String message = "yay!";

        private CompleteRegistrationRequest(byte outcome) {
            this.outcome = outcome;
        }

        public byte getOperationType() {
            return 88;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.writeByte((int)this.outcome);
            output.writeUTF("yay!");
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
            byte param = input.readByte();
            if (param != 33) {
                byte errorCode = input.readByte();
                String message = input.readUTF();
                resultHandler.failed((Exception)new SlaveRegistrationException(SlaveRegistrationException.ErrorCode.parseCode(errorCode), message));
                return;
            }
            resultHandler.done(null);
        }
    }

    private class RegisterSubsystemsRequest
    extends AbstractManagementRequest<Void, Void> {
        private final ModelNode subsystems;

        private RegisterSubsystemsRequest(ModelNode subsystems) {
            this.subsystems = subsystems;
        }

        public byte getOperationType() {
            return 89;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> registrationResultResultHandler, ManagementRequestContext<Void> voidManagementRequestContext, FlushableDataOutput output) throws IOException {
            output.writeByte(33);
            this.subsystems.writeExternal((DataOutput)output);
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<Void> resultHandler, final ManagementRequestContext<Void> context) throws IOException {
            byte param = input.readByte();
            if (param != 33) {
                byte errorCode = input.readByte();
                String message = input.readUTF();
                resultHandler.failed((Exception)new SlaveRegistrationException(SlaveRegistrationException.ErrorCode.parseCode(errorCode), message));
                return;
            }
            final ModelNode domainModel = new ModelNode();
            domainModel.readExternal(input);
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                public void execute(ManagementRequestContext<Void> voidManagementRequestContext) throws Exception {
                    boolean success = RemoteDomainConnection.this.applyDomainModel(domainModel);
                    if (success) {
                        RemoteDomainConnection.this.channelHandler.executeRequest(context.getOperationId(), (ManagementRequest)new CompleteRegistrationRequest(33));
                    } else {
                        RemoteDomainConnection.this.channelHandler.executeRequest(context.getOperationId(), (ManagementRequest)new CompleteRegistrationRequest(34));
                        resultHandler.failed((Exception)new SlaveRegistrationException(SlaveRegistrationException.ErrorCode.UNKNOWN, ""));
                    }
                }
            });
        }
    }

    private class RegisterHostControllerRequest
    extends AbstractManagementRequest<Void, Void> {
        private RegisterHostControllerRequest() {
        }

        public byte getOperationType() {
            return 81;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.write(32);
            output.writeUTF(RemoteDomainConnection.this.localHostName);
            ModelNode hostInfo = RemoteDomainConnection.this.localHostInfo.clone();
            hostInfo.get("domain-connection-id").set(RemoteDomainConnection.this.pongHandler.getConnectionId());
            hostInfo.writeExternal((DataOutput)output);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, final ManagementRequestContext<Void> context) throws IOException {
            byte param = input.readByte();
            if (param != 33) {
                byte errorCode = input.readByte();
                String message = input.readUTF();
                resultHandler.failed((Exception)new SlaveRegistrationException(SlaveRegistrationException.ErrorCode.parseCode(errorCode), message));
                return;
            }
            final ModelNode extensions = new ModelNode();
            extensions.readExternal(input);
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                public void execute(ManagementRequestContext<Void> voidManagementRequestContext) throws Exception {
                    ModelNode subsystems = RemoteDomainConnection.this.resolveSubsystemVersions(extensions);
                    RemoteDomainConnection.this.channelHandler.executeRequest(context.getOperationId(), (ManagementRequest)new RegisterSubsystemsRequest(subsystems));
                }
            });
        }
    }

    static interface HostRegistrationCallback {
        public ModelNode resolveSubsystemVersions(ModelNode var1);

        public boolean applyDomainModel(List<ModelNode> var1);

        public void registrationComplete(ManagementChannelHandler var1);
    }
}

