/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.discovery;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.discovery.DomainControllerData;
import org.jboss.as.host.controller.discovery.S3Util;
import org.jboss.as.host.controller.operations.RemoteDomainControllerAddHandler;
import org.jboss.dmr.ModelNode;

public class S3Discovery
implements DiscoveryOption {
    private static final String DC_FILE_NAME = "jboss-domain-master-data";
    private String access_key = null;
    private String secret_access_key = null;
    private String location = null;
    private String prefix = null;
    private String pre_signed_put_url = null;
    private String pre_signed_delete_url = null;
    private S3Util.AWSAuthConnection conn = null;
    private String remoteDcHost;
    private int remoteDcPort;

    public S3Discovery(Map<String, ModelNode> properties) {
        ModelNode accessKeyNode = properties.get("access-key");
        this.access_key = accessKeyNode == null || !accessKeyNode.isDefined() ? null : accessKeyNode.asString();
        ModelNode secretAccessKeyNode = properties.get("secret-access-key");
        this.secret_access_key = secretAccessKeyNode == null || !secretAccessKeyNode.isDefined() ? null : secretAccessKeyNode.asString();
        ModelNode locationNode = properties.get("location");
        this.location = locationNode == null || !locationNode.isDefined() ? null : locationNode.asString();
        ModelNode prefixNode = properties.get("prefix");
        this.prefix = prefixNode == null || !prefixNode.isDefined() ? null : prefixNode.asString();
        ModelNode preSignedPutUrlNode = properties.get("pre-signed-put-url");
        this.pre_signed_put_url = preSignedPutUrlNode == null || !preSignedPutUrlNode.isDefined() ? null : preSignedPutUrlNode.asString();
        ModelNode preSignedDeleteUrlNode = properties.get("pre-signed-delete-url");
        this.pre_signed_delete_url = preSignedDeleteUrlNode == null || !preSignedDeleteUrlNode.isDefined() ? null : preSignedDeleteUrlNode.asString();
    }

    @Override
    public void allowDiscovery(String host, int port) {
        try {
            this.writeToFile(new DomainControllerData(host, port), "master");
        }
        catch (Exception e) {
            HostControllerLogger.ROOT_LOGGER.cannotWriteDomainControllerData(e);
        }
    }

    @Override
    public void discover() {
        int port;
        String host;
        DomainControllerData data = this.readFromFile("master");
        if (data != null) {
            host = data.getHost();
            port = data.getPort();
            try {
                RemoteDomainControllerAddHandler.HOST.getValidator().validateParameter(RemoteDomainControllerAddHandler.HOST.getName(), new ModelNode(host));
                RemoteDomainControllerAddHandler.PORT.getValidator().validateParameter(RemoteDomainControllerAddHandler.PORT.getName(), new ModelNode(port));
            }
            catch (OperationFailedException e) {
                throw new IllegalStateException(e.getFailureDescription().asString());
            }
        } else {
            throw HostControllerMessages.MESSAGES.failedMarshallingDomainControllerData();
        }
        this.setRemoteDomainControllerHost(host);
        this.setRemoteDomainControllerPort(port);
    }

    @Override
    public void cleanUp() {
        this.remove("master");
    }

    @Override
    public String getRemoteDomainControllerHost() {
        return this.remoteDcHost;
    }

    @Override
    public int getRemoteDomainControllerPort() {
        return this.remoteDcPort;
    }

    private boolean usingPreSignedUrls() {
        return this.pre_signed_put_url != null;
    }

    private void validatePreSignedUrls() {
        if (this.pre_signed_put_url != null && this.pre_signed_delete_url != null) {
            S3Util.PreSignedUrlParser parsedPut = new S3Util.PreSignedUrlParser(this.pre_signed_put_url);
            S3Util.PreSignedUrlParser parsedDelete = new S3Util.PreSignedUrlParser(this.pre_signed_delete_url);
            if (!parsedPut.getBucket().equals(parsedDelete.getBucket()) || !parsedPut.getPrefix().equals(parsedDelete.getPrefix())) {
                throw HostControllerMessages.MESSAGES.preSignedUrlsMustHaveSamePath();
            }
        } else if (this.pre_signed_put_url != null || this.pre_signed_delete_url != null) {
            throw HostControllerMessages.MESSAGES.preSignedUrlsMustBeSetOrUnset();
        }
    }

    private void init() {
        this.validatePreSignedUrls();
        try {
            this.conn = new S3Util.AWSAuthConnection(this.access_key, this.secret_access_key);
            if (this.prefix != null && this.prefix.length() > 0) {
                S3Util.ListAllMyBucketsResponse bucket_list = this.conn.listAllMyBuckets(null);
                List buckets = bucket_list.entries;
                if (buckets != null) {
                    boolean found = false;
                    for (Object tmp : buckets) {
                        if (!(tmp instanceof S3Util.Bucket)) continue;
                        S3Util.Bucket bucket = (S3Util.Bucket)tmp;
                        if (!bucket.name.startsWith(this.prefix)) continue;
                        this.location = bucket.name;
                        found = true;
                    }
                    if (!found) {
                        this.location = this.prefix + "-" + UUID.randomUUID().toString();
                    }
                }
            }
            if (this.usingPreSignedUrls()) {
                S3Util.PreSignedUrlParser parsedPut = new S3Util.PreSignedUrlParser(this.pre_signed_put_url);
                this.location = parsedPut.getBucket();
            }
            if (!this.conn.checkBucketExists(this.location)) {
                this.conn.createBucket((String)this.location, (String)S3Util.AWSAuthConnection.LOCATION_DEFAULT, null).connection.getResponseMessage();
            }
        }
        catch (Exception e) {
            throw HostControllerMessages.MESSAGES.cannotAccessS3Bucket(this.location, e.getLocalizedMessage());
        }
    }

    private DomainControllerData readFromFile(String directoryName) {
        if (directoryName == null) {
            return null;
        }
        if (this.conn == null) {
            this.init();
        }
        DomainControllerData data = null;
        try {
            byte[] buf;
            if (this.usingPreSignedUrls()) {
                S3Util.PreSignedUrlParser parsedPut = new S3Util.PreSignedUrlParser(this.pre_signed_put_url);
                directoryName = parsedPut.getPrefix();
            }
            String key = S3Util.sanitize(directoryName) + "/" + S3Util.sanitize(DC_FILE_NAME);
            S3Util.GetResponse val = this.conn.get(this.location, key, null);
            if (val.object != null && (buf = val.object.data) != null && buf.length > 0) {
                try {
                    data = S3Util.domainControllerDataFromByteBuffer(buf);
                }
                catch (Exception e) {
                    throw HostControllerMessages.MESSAGES.failedMarshallingDomainControllerData();
                }
            }
            return data;
        }
        catch (IOException e) {
            throw HostControllerMessages.MESSAGES.cannotAccessS3File(e.getLocalizedMessage());
        }
    }

    private void writeToFile(DomainControllerData data, String domainName) throws IOException {
        if (domainName == null || data == null) {
            return;
        }
        if (this.conn == null) {
            this.init();
        }
        try {
            String key = S3Util.sanitize(domainName) + "/" + S3Util.sanitize(DC_FILE_NAME);
            byte[] buf = S3Util.domainControllerDataToByteBuffer(data);
            S3Util.S3Object val = new S3Util.S3Object(buf, null);
            if (this.usingPreSignedUrls()) {
                TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
                headers.put("x-amz-acl", Arrays.asList("public-read"));
                this.conn.put((String)this.pre_signed_put_url, (S3Util.S3Object)val, headers).connection.getResponseMessage();
            } else {
                TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
                headers.put("Content-Type", Arrays.asList("text/plain"));
                this.conn.put((String)this.location, (String)key, (S3Util.S3Object)val, headers).connection.getResponseMessage();
            }
        }
        catch (Exception e) {
            throw HostControllerMessages.MESSAGES.cannotWriteToS3File(e.getLocalizedMessage());
        }
    }

    private void remove(String directoryName) {
        if (directoryName == null || this.conn == null) {
            return;
        }
        String key = S3Util.sanitize(directoryName) + "/" + S3Util.sanitize(DC_FILE_NAME);
        try {
            TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
            headers.put("Content-Type", Arrays.asList("text/plain"));
            if (this.usingPreSignedUrls()) {
                this.conn.delete((String)this.pre_signed_delete_url).connection.getResponseMessage();
            } else {
                this.conn.delete((String)this.location, (String)key, headers).connection.getResponseMessage();
            }
        }
        catch (Exception e) {
            HostControllerLogger.ROOT_LOGGER.cannotRemoveS3File(e);
        }
    }

    private void setRemoteDomainControllerHost(String host) {
        this.remoteDcHost = host;
    }

    private void setRemoteDomainControllerPort(int port) {
        this.remoteDcPort = port;
    }
}

