/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.MessageBytes;
import org.jboss.servlet.http.HttpEvent;

final class StandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private StandardContext context = null;

    StandardContextValve() {
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        this.context = (StandardContext)container;
    }

    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        Wrapper wrapper;
        MessageBytes requestPathMB = request.getRequestPathMB();
        if (requestPathMB.startsWithIgnoreCase("/META-INF/", 0) || requestPathMB.equalsIgnoreCase("/META-INF") || requestPathMB.startsWithIgnoreCase("/WEB-INF/", 0) || requestPathMB.equalsIgnoreCase("/WEB-INF")) {
            this.notFound(response);
            return;
        }
        boolean reloaded = false;
        while (this.context.getPaused()) {
            reloaded = true;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        if (reloaded && this.context.getLoader() != null && this.context.getLoader().getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
        }
        if ((wrapper = request.getWrapper()) == null) {
            this.notFound(response);
            return;
        }
        if (!wrapper.isStarted() && (wrapper = (Wrapper)this.container.findChild(wrapper.getName())) == null) {
            this.notFound(response);
            return;
        }
        wrapper.getPipeline().getFirst().invoke(request, response);
    }

    @Override
    public final void event(Request request, Response response, HttpEvent httpEvent) throws IOException, ServletException {
        Wrapper wrapper = request.getWrapper();
        wrapper.getPipeline().getFirst().event(request, response, httpEvent);
    }

    protected void notFound(HttpServletResponse response) {
        try {
            response.sendError(404);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

