/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader.cache;

import com.google.common.base.Function;
import com.google.common.collect.ComputationException;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.interceptor.reader.ClassMetadataInterceptorFactory;
import org.jboss.weld.interceptor.reader.InterceptorMetadataUtils;
import org.jboss.weld.interceptor.reader.ReflectiveClassMetadata;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.reader.cache.MetadataCachingReader;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorFactory;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.manager.BeanManagerImpl;

public class DefaultMetadataCachingReader
implements MetadataCachingReader {
    private final ConcurrentMap<InterceptorFactory<?>, InterceptorMetadata<?>> interceptorMetadataCache;
    private final ConcurrentMap<ClassMetadata<?>, InterceptorMetadata<?>> classMetadataInterceptorMetadataCache;
    private final ConcurrentMap<Class<?>, ClassMetadata<?>> reflectiveClassMetadataCache;
    private boolean unwrapRuntimeExceptions;
    private final BeanManagerImpl manager;

    public DefaultMetadataCachingReader(BeanManagerImpl manager) {
        this.manager = manager;
        this.interceptorMetadataCache = new MapMaker().makeComputingMap(new Function<InterceptorFactory<?>, InterceptorMetadata<?>>(){

            public InterceptorMetadata<?> apply(InterceptorFactory<?> from) {
                return InterceptorMetadataUtils.readMetadataForInterceptorClass(from);
            }
        });
        this.classMetadataInterceptorMetadataCache = new MapMaker().makeComputingMap(new Function<ClassMetadata<?>, InterceptorMetadata<?>>(){

            public InterceptorMetadata<?> apply(ClassMetadata<?> from) {
                return InterceptorMetadataUtils.readMetadataForTargetClass(from);
            }
        });
        this.reflectiveClassMetadataCache = new MapMaker().makeComputingMap(new Function<Class<?>, ClassMetadata<?>>(){

            public ClassMetadata<?> apply(Class<?> from) {
                return ReflectiveClassMetadata.of(from);
            }
        });
        this.unwrapRuntimeExceptions = true;
    }

    public void setUnwrapRuntimeExceptions(boolean unwrapRuntimeExceptions) {
        this.unwrapRuntimeExceptions = unwrapRuntimeExceptions;
    }

    @Override
    public <T> InterceptorMetadata<T> getInterceptorMetadata(InterceptorFactory<T> interceptorReference) {
        try {
            return (InterceptorMetadata)this.interceptorMetadataCache.get(interceptorReference);
        }
        catch (ComputationException e) {
            if (this.unwrapRuntimeExceptions && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public <T> TargetClassInterceptorMetadata<T> getTargetClassInterceptorMetadata(ClassMetadata<T> classMetadata) {
        try {
            return (TargetClassInterceptorMetadata)this.classMetadataInterceptorMetadataCache.get(classMetadata);
        }
        catch (ComputationException e) {
            if (this.unwrapRuntimeExceptions && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public <T> InterceptorMetadata<T> getInterceptorMetadata(Class<T> clazz) {
        try {
            return (InterceptorMetadata)this.interceptorMetadataCache.get(ClassMetadataInterceptorFactory.of((ClassMetadata)this.reflectiveClassMetadataCache.get(clazz), this.manager));
        }
        catch (ComputationException e) {
            if (this.unwrapRuntimeExceptions && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public <T> ClassMetadata<T> getClassMetadata(Class<T> clazz) {
        try {
            return (ClassMetadata)this.reflectiveClassMetadataCache.get(clazz);
        }
        catch (ComputationException e) {
            if (this.unwrapRuntimeExceptions && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void cleanAfterBoot() {
        this.classMetadataInterceptorMetadataCache.clear();
    }
}

