/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.annotated.AnnotatedTypeValidator;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.BeanInjectionTarget;
import org.jboss.weld.injection.producer.DecoratorInjectionTarget;
import org.jboss.weld.injection.producer.InjectionTargetInitializationContext;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.injection.producer.LifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.NoopLifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.ejb.SessionBeanInjectionTarget;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTargetFactory;
import org.jboss.weld.resources.ClassTransformer;

public class InjectionTargetFactoryImpl<T>
implements WeldInjectionTargetFactory<T> {
    private final BeanManagerImpl manager;
    private final EnhancedAnnotatedType<T> type;
    private final InjectionTargetService injectionTargetService;
    private final InjectionServices injectionServices;

    protected InjectionTargetFactoryImpl(AnnotatedType<T> type, BeanManagerImpl manager) {
        this.manager = manager;
        AnnotatedTypeValidator.validateAnnotatedType(type);
        this.type = ((ClassTransformer)manager.getServices().get(ClassTransformer.class)).getEnhancedAnnotatedType(type, manager.getId());
        this.injectionTargetService = (InjectionTargetService)manager.getServices().get(InjectionTargetService.class);
        this.injectionServices = (InjectionServices)manager.getServices().get(InjectionServices.class);
    }

    public InjectionTarget<T> createInjectionTarget(Bean<T> bean) {
        return this.createInjectionTarget(bean, false);
    }

    public InjectionTarget<T> createInterceptorInjectionTarget() {
        return this.createInjectionTarget(null, true);
    }

    private InjectionTarget<T> createInjectionTarget(Bean<T> bean, boolean interceptor) {
        try {
            BasicInjectionTarget<T> injectionTarget = this.createInjectionTarget(this.type, bean, interceptor);
            this.injectionTargetService.validateProducer(injectionTarget);
            return injectionTarget;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public BasicInjectionTarget<T> createInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, boolean interceptor) {
        BasicInjectionTarget injectionTarget = null;
        injectionTarget = bean instanceof Decorator || type.isAnnotationPresent(javax.decorator.Decorator.class) ? new DecoratorInjectionTarget<T>(type, bean, this.manager) : (bean instanceof SessionBean ? new SessionBeanInjectionTarget<T>(type, (SessionBean)bean, this.manager) : (interceptor ? new InterceptorInjectionTarget<T>(type, this.manager) : new BeanInjectionTarget<T>(type, bean, this.manager)));
        this.injectionTargetService.addInjectionTargetToBeInitialized(new InjectionTargetInitializationContext<T>(type, injectionTarget));
        this.postProcessInjectionTarget(type, injectionTarget);
        return injectionTarget;
    }

    protected InjectionTarget<T> createMessageDrivenInjectionTarget() {
        try {
            BasicInjectionTarget<T> injectionTarget = new BasicInjectionTarget<T>(this.type, null, this.manager);
            this.postProcessInjectionTarget(this.type, injectionTarget);
            this.injectionTargetService.validateProducer(injectionTarget);
            return injectionTarget;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    private <X> void postProcessInjectionTarget(AnnotatedType<X> type, InjectionTarget<X> injectionTarget) {
        if (this.injectionServices != null) {
            this.injectionServices.registerInjectionTarget(injectionTarget, type);
        }
    }

    private static class InterceptorInjectionTarget<T>
    extends BasicInjectionTarget<T> {
        public InterceptorInjectionTarget(EnhancedAnnotatedType<T> type, BeanManagerImpl beanManager) {
            super(type, null, beanManager);
        }

        @Override
        protected LifecycleCallbackInvoker<T> initInvoker(EnhancedAnnotatedType<T> type) {
            return NoopLifecycleCallbackInvoker.getInstance();
        }
    }
}

