/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.util.Map;
import java.util.Set;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.DispatchImpl;
import org.jboss.ws.common.configuration.ConfigHelper;
import org.jboss.wsf.spi.metadata.config.ClientConfig;

public class CXFClientConfigurer
extends ConfigHelper {
    private static final String JBOSSWS_CXF_CLIENT_CONF_PROPS = "jbossws.cxf.client.conf.props";

    public void setConfigProperties(Object client, String configFile, String configName) {
        ClientConfig config = this.readConfig(configFile, configName);
        Client cxfClient = client instanceof DispatchImpl ? ((DispatchImpl)client).getClient() : ClientProxy.getClient((Object)client);
        this.cleanupPreviousProps(cxfClient);
        Map props = config.getProperties();
        if (props != null && !props.isEmpty()) {
            this.savePropList(cxfClient, props);
        }
        this.setConfigProperties(cxfClient, props);
    }

    public void setConfigProperties(Client client, Map<String, String> properties) {
        client.getEndpoint().putAll(properties);
    }

    private void savePropList(Client client, Map<String, String> props) {
        Set<String> keys = props.keySet();
        client.getEndpoint().put((Object)JBOSSWS_CXF_CLIENT_CONF_PROPS, (Object)keys.toArray(new String[keys.size()]));
    }

    private void cleanupPreviousProps(Client client) {
        Endpoint ep = client.getEndpoint();
        String[] previousProps = (String[])ep.get((Object)JBOSSWS_CXF_CLIENT_CONF_PROPS);
        if (previousProps != null) {
            for (String p : previousProps) {
                ep.remove((Object)p);
            }
            ep.remove((Object)JBOSSWS_CXF_CLIENT_CONF_PROPS);
        }
    }
}

