/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.spi.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.PassivationManager;
import org.jboss.as.ejb3.cache.spi.PersistentObjectStore;
import org.jboss.logging.Logger;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleDataInput;
import org.jboss.marshalling.SimpleDataOutput;
import org.jboss.marshalling.Unmarshaller;

public class FilePersistentObjectStore<K extends Serializable, V extends Cacheable<K>>
implements PersistentObjectStore<K, V> {
    private static final Logger log = Logger.getLogger(FilePersistentObjectStore.class);
    private final MarshallerFactory marshallerFactory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)MarshallerFactory.class.getClassLoader());
    private final PassivationManager<K, V> passivationManager;
    private final int subdirectoryCount;
    private final File baseDirectory;
    private File[] storageDirectories;

    public FilePersistentObjectStore(PassivationManager<K, V> passivationManager, String directoryName, int subDirectoryCount) {
        this.passivationManager = passivationManager;
        this.baseDirectory = new File(directoryName);
        this.subdirectoryCount = subDirectoryCount;
    }

    protected File getFile(K key) {
        File base = null;
        if (this.storageDirectories != null) {
            int hash = (key.hashCode() & Integer.MAX_VALUE) % this.storageDirectories.length;
            base = this.storageDirectories[hash];
        } else {
            base = this.baseDirectory;
        }
        return new File(base, String.valueOf(key) + ".ser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public V load(K key) {
        File file = this.getFile(key);
        if (!file.exists()) {
            return null;
        }
        log.tracef("Loading state from %s", (Object)file);
        try {
            FileInputStream inputStream = null;
            try {
                Cacheable cacheable;
                inputStream = FISAction.open(file);
                SimpleDataInput input = new SimpleDataInput(Marshalling.createByteInput((InputStream)inputStream));
                int version = input.readInt();
                MarshallingConfiguration config = this.passivationManager.getMarshallingConfiguration(version);
                Unmarshaller unmarshaller = this.marshallerFactory.createUnmarshaller(config);
                unmarshaller.start((ByteInput)input);
                try {
                    Cacheable value = (Cacheable)unmarshaller.readObject();
                    unmarshaller.finish();
                    cacheable = value;
                }
                catch (Throwable throwable) {
                    unmarshaller.close();
                    throw throwable;
                }
                unmarshaller.close();
                return (V)cacheable;
            }
            finally {
                FilePersistentObjectStore.safeClose(inputStream);
                DeleteFileAction.delete(file);
            }
        }
        catch (Exception e) {
            throw EjbMessages.MESSAGES.activationFailed(e, key);
        }
    }

    @Override
    public void start() {
        this.establishDirectory(this.baseDirectory);
        if (this.subdirectoryCount > 1) {
            this.storageDirectories = new File[this.subdirectoryCount];
            for (int i = 0; i < this.storageDirectories.length; ++i) {
                File f = new File(this.baseDirectory, String.valueOf(i) + File.separatorChar);
                this.establishDirectory(f);
                this.storageDirectories[i] = f;
            }
        }
    }

    private void establishDirectory(File dir) {
        if (!(dir.exists() || MkdirsFileAction.mkdirs(dir) || dir.exists())) {
            throw EjbMessages.MESSAGES.passivationDirectoryCreationFailed(dir.getPath());
        }
        if (!dir.isDirectory()) {
            throw EjbMessages.MESSAGES.passivationPathNotADirectory(dir.getPath());
        }
    }

    @Override
    public void stop() {
        this.deleteDirectory(this.baseDirectory);
    }

    private void deleteDirectory(File dir) {
        if (dir != null && dir.exists()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.deleteDirectory(file);
                        continue;
                    }
                    DeleteFileAction.delete(file);
                }
            }
            DeleteFileAction.delete(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(V obj) {
        File file = this.getFile((Serializable)obj.getId());
        log.tracef("Storing state to %s", (Object)file);
        try {
            FileOutputStream outputStream = null;
            try {
                outputStream = FOSAction.open(file);
                SimpleDataOutput output = new SimpleDataOutput(Marshalling.createByteOutput((OutputStream)outputStream));
                int version = this.passivationManager.getCurrentMarshallingVersion();
                output.writeInt(version);
                MarshallingConfiguration config = this.passivationManager.getMarshallingConfiguration(version);
                marshaller.start((ByteOutput)output);
                try (Marshaller marshaller = this.marshallerFactory.createMarshaller(config);){
                    marshaller.writeObject(obj);
                    marshaller.finish();
                }
            }
            finally {
                FilePersistentObjectStore.safeClose(outputStream);
            }
        }
        catch (IOException e) {
            throw EjbMessages.MESSAGES.passivationFailed(e, obj.getId());
        }
    }

    protected static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class MkdirsFileAction
    implements PrivilegedAction<Boolean> {
        File file;

        MkdirsFileAction(File file) {
            this.file = file;
        }

        @Override
        public Boolean run() {
            return this.file.mkdirs();
        }

        static boolean mkdirs(File file) {
            MkdirsFileAction action = new MkdirsFileAction(file);
            return AccessController.doPrivileged(action);
        }
    }

    private static class FOSAction
    implements PrivilegedExceptionAction<FileOutputStream> {
        File file;

        FOSAction(File file) {
            this.file = file;
        }

        @Override
        public FileOutputStream run() throws FileNotFoundException {
            FileOutputStream fis = new FileOutputStream(this.file);
            return fis;
        }

        static FileOutputStream open(File file) throws FileNotFoundException {
            FOSAction action = new FOSAction(file);
            FileOutputStream fos = null;
            try {
                fos = AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (FileNotFoundException)e.getException();
            }
            return fos;
        }
    }

    private static class FISAction
    implements PrivilegedExceptionAction<FileInputStream> {
        File file;

        FISAction(File file) {
            this.file = file;
        }

        @Override
        public FileInputStream run() throws FileNotFoundException {
            FileInputStream fis = new FileInputStream(this.file);
            return fis;
        }

        static FileInputStream open(File file) throws FileNotFoundException {
            FISAction action = new FISAction(file);
            FileInputStream fis = null;
            try {
                fis = AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (FileNotFoundException)e.getException();
            }
            return fis;
        }
    }

    private static class DeleteFileAction
    implements PrivilegedAction<Boolean> {
        File file;

        DeleteFileAction(File file) {
            this.file = file;
        }

        @Override
        public Boolean run() {
            boolean deleted = this.file.delete();
            if (!deleted) {
                EjbLogger.EJB3_LOGGER.cannotDeleteCacheFile(this.file.isDirectory() ? "directory" : " file", this.file.getName());
                this.file.deleteOnExit();
            }
            return deleted;
        }

        static boolean delete(File file) {
            DeleteFileAction action = new DeleteFileAction(file);
            return AccessController.doPrivileged(action);
        }
    }
}

