/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.remoting.AbstractStreamServerService;
import org.jboss.as.remoting.InjectedSocketBindingStreamServerService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class EJBRemotingConnectorClientMappingsEntryProviderService
implements Service<Registry.RegistryEntryProvider<String, List<ClientMapping>>> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb"}).append(new String[]{"remoting"}).append(new String[]{"connector"}).append(new String[]{"client-mapping-entry-provider-service"});
    private final ServiceName remotingConnectorServiceName;
    private volatile InjectedSocketBindingStreamServerService remotingServer;
    private final Registry.RegistryEntryProvider<String, List<ClientMapping>> registryEntryProvider = new ClientMappingEntryProvider();
    private final InjectedValue<ServerEnvironment> serverEnvironment = new InjectedValue();

    public EJBRemotingConnectorClientMappingsEntryProviderService(ServiceName remotingConnectorServiceName) {
        this.remotingConnectorServiceName = remotingConnectorServiceName;
    }

    public void start(StartContext context) throws StartException {
        ServiceContainer serviceContainer = context.getController().getServiceContainer();
        ServiceController streamServerServiceController = serviceContainer.getRequiredService(this.remotingConnectorServiceName);
        AbstractStreamServerService streamServerService = (AbstractStreamServerService)streamServerServiceController.getService();
        if (streamServerService instanceof InjectedSocketBindingStreamServerService) {
            this.remotingServer = (InjectedSocketBindingStreamServerService)streamServerService;
        }
    }

    public void stop(StopContext context) {
        this.remotingServer = null;
    }

    public Registry.RegistryEntryProvider<String, List<ClientMapping>> getValue() {
        return this.registryEntryProvider;
    }

    public Injector<ServerEnvironment> getServerEnvironmentInjector() {
        return this.serverEnvironment;
    }

    List<ClientMapping> getClientMappings() {
        InetAddress clientNetworkAddress;
        if (this.remotingServer == null) {
            return Collections.emptyList();
        }
        SocketBinding socketBinding = this.remotingServer.getSocketBinding();
        List clientMappings = socketBinding.getClientMappings();
        if (clientMappings != null && !clientMappings.isEmpty()) {
            return clientMappings;
        }
        String destinationAddress = socketBinding.getAddress().getHostAddress();
        try {
            clientNetworkAddress = InetAddress.getByName("::");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        ClientMapping defaultClientMapping = new ClientMapping(clientNetworkAddress, 0, destinationAddress, socketBinding.getAbsolutePort());
        return Collections.singletonList(defaultClientMapping);
    }

    String getNodeName() {
        return ((ServerEnvironment)this.serverEnvironment.getValue()).getNodeName();
    }

    private class ClientMappingEntryProvider
    implements Registry.RegistryEntryProvider<String, List<ClientMapping>> {
        private ClientMappingEntryProvider() {
        }

        public String getKey() {
            return EJBRemotingConnectorClientMappingsEntryProviderService.this.getNodeName();
        }

        public List<ClientMapping> getValue() {
            return EJBRemotingConnectorClientMappingsEntryProviderService.this.getClientMappings();
        }
    }
}

