/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.transform.CombinedTransformer;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.subsystem.DatabaseDataStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.FileDataStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.TimerServiceAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TimerServiceResourceDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition THREAD_POOL_NAME = new SimpleAttributeDefinitionBuilder("thread-pool-name", ModelType.STRING, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition DEFAULT_DATA_STORE = new SimpleAttributeDefinitionBuilder("default-data-store", ModelType.STRING).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowNull(false).build();
    public static final Map<String, AttributeDefinition> ATTRIBUTES;
    private final PathManager pathManager;

    public TimerServiceResourceDefinition(PathManager pathManager) {
        super(EJB3SubsystemModel.TIMER_SERVICE_PATH, EJB3Extension.getResourceDescriptionResolver("timer-service"), (OperationStepHandler)TimerServiceAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_ALL_SERVICES);
        this.pathManager = pathManager;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : ATTRIBUTES.values()) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{attr}));
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new FileDataStoreResourceDefinition(this.pathManager));
        resourceRegistration.registerSubModel((ResourceDefinition)DatabaseDataStoreResourceDefinition.INSTANCE);
    }

    static void registerTransformers_1_1_0(ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder timerService = parent.addChildResource(EJB3SubsystemModel.TIMER_SERVICE_PATH);
        TimerServiceResourceDefinition.registerDataStoreTransformers(timerService, true);
    }

    static void registerTransformers_1_2_0(ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder timerService = parent.addChildResource(EJB3SubsystemModel.TIMER_SERVICE_PATH);
        TimerServiceResourceDefinition.registerDataStoreTransformers(timerService, false);
    }

    private static void registerDataStoreTransformers(ResourceTransformationDescriptionBuilder timerService, boolean rejectPathExpressions) {
        DataStoreTransformer dataStoreTransformer = new DataStoreTransformer(rejectPathExpressions);
        ((AttributeTransformationDescriptionBuilder)timerService.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new String[]{"default-data-store"})).end();
        timerService.discardOperations(new String[]{"add"});
        timerService.setCustomResourceTransformer((ResourceTransformer)dataStoreTransformer);
        timerService.rejectChildResource(EJB3SubsystemModel.DATABASE_DATA_STORE_PATH);
        ResourceTransformationDescriptionBuilder fileDataStore = timerService.addChildRedirection(EJB3SubsystemModel.FILE_DATA_STORE_PATH, new PathAddressTransformer(){

            public PathAddress transform(PathElement current, PathAddressTransformer.Builder builder) {
                return builder.getCurrent();
            }
        });
        if (rejectPathExpressions) {
            fileDataStore = ((AttributeTransformationDescriptionBuilder)fileDataStore.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{FileDataStoreResourceDefinition.PATH})).end();
        }
        fileDataStore.addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer((OperationTransformer)dataStoreTransformer).end();
    }

    static {
        LinkedHashMap<String, SimpleAttributeDefinition> map = new LinkedHashMap<String, SimpleAttributeDefinition>();
        map.put(THREAD_POOL_NAME.getName(), THREAD_POOL_NAME);
        map.put(DEFAULT_DATA_STORE.getName(), DEFAULT_DATA_STORE);
        ATTRIBUTES = Collections.unmodifiableMap(map);
    }

    private static class DataStoreTransformer
    implements CombinedTransformer {
        private final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");
        private final boolean rejectPathExpression;

        private DataStoreTransformer(boolean rejectPathExpression) {
            this.rejectPathExpression = rejectPathExpression;
        }

        public OperationTransformer.TransformedOperation transformOperation(final TransformationContext context, final PathAddress address, final ModelNode operation) throws OperationFailedException {
            Resource original = context.readResource(address);
            if (original.getChildren("file-data-store").size() > 1) {
                return new OperationTransformer.TransformedOperation(operation, new OperationRejectionPolicy(){

                    public boolean rejectOperation(ModelNode preparedResult) {
                        return true;
                    }

                    public String getFailureDescription() {
                        return context.getLogger().getRejectedResourceWarning(address, operation);
                    }
                }, OperationResultTransformer.ORIGINAL_RESULT);
            }
            operation.get(THREAD_POOL_NAME.getName()).set(original.getModel().get(THREAD_POOL_NAME.getName()));
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }

        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
            Resource untransformedResource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode untransformedModel = Resource.Tools.readModel((Resource)untransformedResource);
            String defaultDataStore = untransformedModel.get(DEFAULT_DATA_STORE.getName()).asString();
            ModelNode transformed = resource.getModel();
            transformed.remove(DEFAULT_DATA_STORE.getName());
            ModelNode fileStore = untransformedModel.get(new String[]{"file-data-store", defaultDataStore});
            if (!fileStore.isDefined()) {
                this.rejectIncompatibleDataStores(context, address);
                fileStore = new ModelNode();
            } else if (untransformedModel.hasDefined("database-data-store") && untransformedModel.get("database-data-store").asInt() > 0 || untransformedModel.get("file-data-store").asInt() > 1) {
                this.rejectIncompatibleDataStores(context, address);
            }
            ModelNode path = fileStore.get("path");
            if (this.rejectPathExpression) {
                this.rejectPathExpression(context, address, defaultDataStore, path);
            }
            transformed.get("path").set(path);
            transformed.get("relative-to").set(fileStore.get("relative-to"));
            context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
        }

        private void rejectIncompatibleDataStores(ResourceTransformationContext context, PathAddress address) throws OperationFailedException {
            TransformationTarget tgt = context.getTarget();
            if (tgt.isIgnoredResourceListAvailableAtRegistration()) {
                throw new OperationFailedException(EjbMessages.MESSAGES.untransformableTimerService(address));
            }
            context.getLogger().logWarning(EjbMessages.MESSAGES.untransformableTimerService(address));
        }

        private void rejectPathExpression(ResourceTransformationContext context, PathAddress address, String dataStoreName, ModelNode pathAttribute) throws OperationFailedException {
            if (pathAttribute.getType() == ModelType.EXPRESSION || pathAttribute.getType() == ModelType.STRING && this.EXPRESSION_PATTERN.matcher(pathAttribute.asString()).matches()) {
                PathAddress fileStoreAddress = PathAddress.pathAddress((PathAddress)address, (PathElement[])new PathElement[]{PathElement.pathElement((String)"file-data-store", (String)dataStoreName)});
                TransformationTarget tgt = context.getTarget();
                if (tgt.isIgnoredResourceListAvailableAtRegistration()) {
                    List<String> msg = Collections.singletonList(context.getLogger().getAttributeWarning(fileStoreAddress, null, new String[]{ControllerMessages.MESSAGES.attributesDontSupportExpressions(), FileDataStoreResourceDefinition.PATH.getName()}));
                    throw ControllerMessages.MESSAGES.rejectAttributesCoreModelResourceTransformer(fileStoreAddress, tgt.getHostName(), tgt.getVersion(), msg);
                }
                context.getLogger().logAttributeWarning(fileStoreAddress, ControllerMessages.MESSAGES.attributesDontSupportExpressions(), FileDataStoreResourceDefinition.PATH.getName());
            }
        }
    }
}

