/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.JdrReportCollector;
import org.jboss.as.jdr.JdrRunner;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.GetAccessControlContextAction;

public class JdrReportService
implements JdrReportCollector,
Service<JdrReportCollector> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jdr", "collector"});
    private final InjectedValue<ServerEnvironment> serverEnvironmentValue = new InjectedValue();
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private ExecutorService executorService;
    private ServerEnvironment serverEnvironment;
    private ModelControllerClient controllerClient;

    public static ServiceController<JdrReportCollector> addService(ServiceTarget target, ServiceVerificationHandler verificationHandler) {
        JdrReportService service = new JdrReportService();
        return target.addService(SERVICE_NAME, (Service)service).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.serverEnvironmentValue).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.modelControllerValue).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public JdrReport standaloneCollect(String protocol, String host, String port) throws OperationFailedException {
        String username = null;
        String password = null;
        if (host == null) {
            host = "localhost";
        }
        if (port == null) {
            port = "9999";
        }
        if (protocol == null) {
            protocol = "http-remoting";
        }
        return new JdrRunner(protocol, username, password, host, port).collect();
    }

    @Override
    public JdrReport collect() throws OperationFailedException {
        JdrRunner runner = new JdrRunner();
        this.serverEnvironment = (ServerEnvironment)this.serverEnvironmentValue.getValue();
        runner.setJbossHomeDir(this.serverEnvironment.getHomeDir().getAbsolutePath());
        runner.setReportLocationDir(this.serverEnvironment.getServerTempDir().getAbsolutePath());
        runner.setControllerClient(this.controllerClient);
        runner.setHostControllerName(this.serverEnvironment.getHostControllerName());
        runner.setServerName(this.serverEnvironment.getServerName());
        return runner.collect();
    }

    public synchronized void start(StartContext context) throws StartException {
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("JdrReportCollector-threads"), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
        this.serverEnvironment = (ServerEnvironment)this.serverEnvironmentValue.getValue();
        this.controllerClient = ((ModelController)this.modelControllerValue.getValue()).createClient((Executor)this.executorService);
    }

    public synchronized void stop(StopContext context) {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public JdrReportService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

