/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.PendingHttpRequest;
import io.undertow.client.ResponseParseState;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public abstract class HttpResponseParser {
    public static final HttpResponseParser INSTANCE;
    private static final int NORMAL = 0;
    private static final int WHITESPACE = 1;
    private static final int BEGIN_LINE_END = 2;
    private static final int LINE_END = 3;
    private static final int AWAIT_DATA_END = 4;

    abstract void handleHttpVersion(ByteBuffer var1, ResponseParseState var2, PendingHttpRequest var3);

    abstract void handleHeader(ByteBuffer var1, ResponseParseState var2, PendingHttpRequest var3);

    public void handle(ByteBuffer buffer, ResponseParseState currentState, PendingHttpRequest builder) {
        if (currentState.state == 0) {
            this.handleHttpVersion(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        if (currentState.state == 1) {
            this.handleStatusCode(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        if (currentState.state == 2) {
            this.handleReasonPhrase(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        if (currentState.state == 3) {
            this.handleAfterReasonPhrase(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        while (currentState.state != 6) {
            if (currentState.state == 4) {
                this.handleHeader(buffer, currentState, builder);
                if (!buffer.hasRemaining()) {
                    return;
                }
            }
            if (currentState.state != 5) continue;
            this.handleHeaderValue(buffer, currentState, builder);
            if (buffer.hasRemaining()) continue;
            return;
        }
    }

    final void handleStatusCode(ByteBuffer buffer, ResponseParseState state, PendingHttpRequest builder) {
        StringBuilder stringBuilder = state.stringBuilder;
        while (buffer.hasRemaining()) {
            char next = (char)buffer.get();
            if (next == ' ' || next == '\t') {
                builder.setStatusCode(Integer.parseInt(stringBuilder.toString()));
                state.state = 2;
                state.stringBuilder.setLength(0);
                state.parseState = 0;
                state.pos = 0;
                state.nextHeader = null;
                return;
            }
            stringBuilder.append(next);
        }
    }

    final void handleReasonPhrase(ByteBuffer buffer, ResponseParseState state, PendingHttpRequest builder) {
        StringBuilder stringBuilder = state.stringBuilder;
        while (buffer.hasRemaining()) {
            char next = (char)buffer.get();
            if (next == '\n' || next == '\r') {
                builder.setReasonPhrase(stringBuilder.toString());
                state.state = 3;
                state.stringBuilder.setLength(0);
                state.parseState = 0;
                state.leftOver = (byte)next;
                state.pos = 0;
                state.nextHeader = null;
                return;
            }
            stringBuilder.append(next);
        }
    }

    final void handleHeaderValue(ByteBuffer buffer, ResponseParseState state, PendingHttpRequest builder) {
        StringBuilder stringBuilder = state.stringBuilder;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            state.parseState = 0;
        }
        int parseState = state.parseState;
        while (buffer.hasRemaining()) {
            byte next = buffer.get();
            switch (parseState) {
                case 0: {
                    if (next == 13) {
                        parseState = 2;
                        break;
                    }
                    if (next == 10) {
                        parseState = 3;
                        break;
                    }
                    if (next == 32 || next == 9) {
                        parseState = 1;
                        break;
                    }
                    stringBuilder.append((char)next);
                    break;
                }
                case 1: {
                    if (next == 13) {
                        parseState = 2;
                        break;
                    }
                    if (next == 10) {
                        parseState = 3;
                        break;
                    }
                    if (next == 32 || next == 9) break;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append((char)next);
                    parseState = 0;
                    break;
                }
                case 2: 
                case 3: {
                    if (next == 10 && parseState == 2) {
                        parseState = 3;
                        break;
                    }
                    if (next == 9 || next == 32) {
                        parseState = 1;
                        break;
                    }
                    HttpString nextStandardHeader = state.nextHeader;
                    String headerValue = stringBuilder.toString();
                    builder.getResponseHeaders().add(nextStandardHeader, headerValue);
                    state.nextHeader = null;
                    state.leftOver = next;
                    state.stringBuilder.setLength(0);
                    if (next == 13) {
                        parseState = 4;
                        break;
                    }
                    state.state = 4;
                    state.parseState = 0;
                    return;
                }
                case 4: {
                    state.state = 6;
                    return;
                }
            }
        }
        state.parseState = parseState;
    }

    protected void handleAfterReasonPhrase(ByteBuffer buffer, ResponseParseState state, PendingHttpRequest builder) {
        boolean newLine;
        boolean bl = newLine = state.leftOver == 10;
        while (buffer.hasRemaining()) {
            byte next = buffer.get();
            if (newLine) {
                if (next == 10) {
                    state.state = 6;
                    return;
                }
                state.state = 4;
                state.leftOver = next;
                return;
            }
            if (next == 10) {
                newLine = true;
                continue;
            }
            if (next == 13 || next == 32 || next == 9) continue;
            state.state = 4;
            state.leftOver = next;
            return;
        }
        if (newLine) {
            state.leftOver = (byte)10;
        }
    }

    protected static Map<String, HttpString> httpStrings() {
        Class[] classs;
        HashMap<String, HttpString> results = new HashMap<String, HttpString>();
        for (Class c : classs = new Class[]{Headers.class, Methods.class, Protocols.class}) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.getType().equals(HttpString.class)) continue;
                field.setAccessible(true);
                HttpString result = null;
                try {
                    result = (HttpString)field.get(null);
                    results.put(result.toString(), result);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return results;
    }

    static {
        try {
            Class<?> cls = HttpResponseParser.class.getClassLoader().loadClass(HttpResponseParser.class.getName() + "$$generated");
            INSTANCE = (HttpResponseParser)cls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

