/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import java.util.Collection;

public class NotificationReceiverHandler
implements HttpHandler {
    private final HttpHandler next;
    private final Collection<NotificationReceiver> receivers;

    public NotificationReceiverHandler(HttpHandler next, Collection<NotificationReceiver> receivers) {
        this.next = next;
        this.receivers = receivers;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext sc = exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        for (NotificationReceiver receiver : this.receivers) {
            sc.registerNotificationReceiver(receiver);
        }
        HttpHandlers.executeHandler(this.next, exchange);
    }
}

