/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.ListAttachmentKey;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractAttachable
implements Attachable {
    private final Map<AttachmentKey<?>, Object> attachments = new IdentityHashMap(5);

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        if (key == null) {
            return null;
        }
        return key.cast(this.attachments.get(key));
    }

    @Override
    public <T> List<T> getAttachmentList(AttachmentKey<? extends List<T>> key) {
        if (key == null) {
            return null;
        }
        List<T> list = key.cast(this.attachments.get(key));
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        return key.cast(this.attachments.put(key, key.cast(value)));
    }

    @Override
    public <T> T removeAttachment(AttachmentKey<T> key) {
        if (key == null) {
            return null;
        }
        return key.cast(this.attachments.remove(key));
    }

    @Override
    public <T> void addToAttachmentList(AttachmentKey<AttachmentList<T>> key, T value) {
        if (key != null) {
            Map<AttachmentKey<?>, Object> attachments = this.attachments;
            AttachmentList<T> list = key.cast(attachments.get(key));
            if (list == null) {
                AttachmentList<T> newList = new AttachmentList<T>(((ListAttachmentKey)key).getValueClass());
                attachments.put(key, newList);
                newList.add(value);
            } else {
                list.add(value);
            }
        }
    }
}

