/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.api.SendCallback;
import io.undertow.websockets.impl.AsyncSendTimeoutStreamSinkChannel;
import io.undertow.websockets.impl.FlushingBlockingWritableByteChannel;
import io.undertow.websockets.impl.WebSocketChannelSession;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;

final class StreamSinkChannelUtils {
    public static void shutdownAndFlush(StreamSinkChannel sink, final SendCallback callback) {
        try {
            sink.shutdownWrites();
            if (!sink.flush()) {
                sink.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                    public void handleEvent(StreamSinkChannel sink) {
                        try {
                            sink.close();
                            StreamSinkChannelUtils.safeNotify(callback, null);
                        }
                        catch (IOException e) {
                            StreamSinkChannelUtils.safeNotify(callback, e);
                        }
                    }
                }, (ChannelExceptionHandler)new ChannelExceptionHandler<Channel>(){

                    public void handleException(Channel channel, IOException e) {
                        StreamSinkChannelUtils.safeNotify(callback, e);
                        IoUtils.safeClose((Closeable)channel);
                    }
                }));
                sink.resumeWrites();
            } else {
                sink.close();
                StreamSinkChannelUtils.safeNotify(callback, null);
            }
        }
        catch (IOException e) {
            StreamSinkChannelUtils.safeNotify(callback, e);
        }
    }

    public static long payloadLength(ByteBuffer ... bufs) {
        if (bufs == null) {
            return 0L;
        }
        long length = 0L;
        for (ByteBuffer buf : bufs) {
            length += (long)buf.remaining();
        }
        return length;
    }

    public static void safeNotify(SendCallback callback, Throwable cause) {
        if (callback == null) {
            return;
        }
        if (cause == null) {
            callback.onCompletion();
        } else {
            callback.onError(cause);
        }
    }

    public static void send(StreamSinkChannel sink, final ByteBuffer payload, final SendCallback callback) {
        try {
            while (payload.hasRemaining()) {
                if (sink.write(payload) != 0) continue;
                sink.getWriteSetter().set((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                    public void handleEvent(StreamSinkChannel sink) {
                        try {
                            while (payload.hasRemaining()) {
                                if (sink.write(payload) != 0) continue;
                                sink.resumeWrites();
                                return;
                            }
                            StreamSinkChannelUtils.shutdownAndFlush(sink, callback);
                        }
                        catch (IOException e) {
                            StreamSinkChannelUtils.safeNotify(callback, e);
                        }
                    }
                });
                sink.resumeWrites();
                return;
            }
            StreamSinkChannelUtils.shutdownAndFlush(sink, callback);
        }
        catch (IOException e) {
            StreamSinkChannelUtils.safeNotify(callback, e);
        }
    }

    public static void send(StreamSinkChannel sink, final ByteBuffer[] payload, final SendCallback callback) {
        try {
            final long length = StreamSinkChannelUtils.payloadLength(payload);
            long written = 0L;
            while (written < length) {
                long w = sink.write(payload);
                if (w == 0L) {
                    final long writtenBytes = written;
                    sink.getWriteSetter().set((ChannelListener)new ChannelListener<StreamSinkChannel>(){
                        long written;
                        {
                            this.written = writtenBytes;
                        }

                        public void handleEvent(StreamSinkChannel sink) {
                            try {
                                while (this.written < length) {
                                    long w = sink.write(payload);
                                    if (w == 0L) {
                                        sink.resumeWrites();
                                        return;
                                    }
                                    if (w <= 0L) continue;
                                    this.written += w;
                                }
                                StreamSinkChannelUtils.shutdownAndFlush(sink, callback);
                            }
                            catch (IOException e) {
                                StreamSinkChannelUtils.safeNotify(callback, e);
                            }
                        }
                    });
                    sink.resumeWrites();
                    return;
                }
                if (w <= 0L) continue;
                written += w;
            }
            StreamSinkChannelUtils.shutdownAndFlush(sink, callback);
        }
        catch (IOException e) {
            StreamSinkChannelUtils.safeNotify(callback, e);
        }
    }

    public static void send(StreamSinkChannel sink, ByteBuffer payload) throws IOException {
        FlushingBlockingWritableByteChannel channel = new FlushingBlockingWritableByteChannel(sink);
        while (payload.hasRemaining()) {
            channel.write(payload);
        }
        channel.close();
    }

    public static void send(StreamSinkChannel sink, ByteBuffer[] payload) throws IOException {
        long length = StreamSinkChannelUtils.payloadLength(payload);
        FlushingBlockingWritableByteChannel channel = new FlushingBlockingWritableByteChannel(sink);
        long written = 0L;
        while (written < length) {
            long w = channel.write(payload);
            if (w <= 0L) continue;
            written += w;
        }
        channel.close();
    }

    public static StreamSinkChannel applyAsyncSendTimeout(WebSocketChannelSession session, StreamSinkChannel sink) {
        int asyncSendtime = session.getAsyncSendTimeout();
        if (asyncSendtime > 0) {
            return new AsyncSendTimeoutStreamSinkChannel(session.getChannel(), sink, asyncSendtime);
        }
        return sink;
    }

    private StreamSinkChannelUtils() {
    }
}

