/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jacorb.poa.AOMListener;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.POA;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.poa.util.StringPair;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.slf4j.Logger;

public class AOM {
    private AOMListener aomListener;
    private final boolean unique;
    private final Logger logger;
    private final Hashtable objectMap = new Hashtable();
    private Hashtable servantMap;
    private final Vector etherealisationList = new Vector();
    private final Vector incarnationList = new Vector();
    private final Vector deactivationList = new Vector();
    private final byte[] deactivationListLock = new byte[0];
    private BlockingQueue removalQueue = new LinkedBlockingQueue();

    protected AOM(boolean _unique, Logger _logger) {
        this.unique = _unique;
        this.logger = _logger;
        if (this.unique) {
            this.servantMap = new Hashtable();
        }
        Thread thread = new Thread("AOMRemoval"){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            RemovalStruct rs = (RemovalStruct)AOM.this.removalQueue.take();
                            AOM.this._remove(rs.oidbak, rs.requestController, rs.servantActivator, rs.poa, rs.cleanupInProgress);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    protected synchronized void add(byte[] oid, Servant servant) throws ObjectAlreadyActive, ServantAlreadyActive {
        ByteArrayKey oidbak = new ByteArrayKey(oid);
        while (this.incarnationList.contains(oidbak) || this.etherealisationList.contains(oidbak) || this.deactivationList.contains(oidbak) || this.servantMap != null && this.servantMap.get(servant) != null && this.deactivationList.contains(this.servantMap.get(servant))) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        if (this.objectMap.containsKey(oidbak)) {
            throw new ObjectAlreadyActive();
        }
        if (this.unique && this.servantMap.containsKey(servant)) {
            throw new ServantAlreadyActive();
        }
        this.objectMap.put(oidbak, servant);
        if (this.unique) {
            this.servantMap.put(servant, oidbak);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("oid: " + POAUtil.convert(oid) + "object is activated");
        }
        if (this.aomListener != null) {
            this.aomListener.objectActivated(oid, servant, this.objectMap.size());
        }
    }

    protected synchronized void addAOMListener(AOMListener listener) {
        this.aomListener = EventMulticaster.add(this.aomListener, listener);
    }

    boolean isDeactivating(ByteArrayKey oid) {
        return this.deactivationList.contains(oid);
    }

    protected boolean contains(Servant servant) {
        if (this.unique) {
            return this.servantMap.containsKey(servant);
        }
        return this.objectMap.contains(servant);
    }

    protected synchronized StringPair[] deliverContent() {
        StringPair[] result = new StringPair[this.objectMap.size()];
        Enumeration en = this.objectMap.keys();
        for (int i = 0; i < result.length; ++i) {
            ByteArrayKey oidbak = (ByteArrayKey)en.nextElement();
            result[i] = new StringPair(oidbak.toString(), this.objectMap.get(oidbak).getClass().getName());
        }
        return result;
    }

    protected byte[] getObjectId(Servant servant) {
        if (!this.unique) {
            throw new POAInternalError("error: not UNIQUE_ID policy (getObjectId)");
        }
        ByteArrayKey oidbak = (ByteArrayKey)this.servantMap.get(servant);
        if (oidbak != null) {
            return oidbak.getBytes();
        }
        return null;
    }

    protected Servant getServant(byte[] oid) {
        return (Servant)this.objectMap.get(new ByteArrayKey(oid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Servant incarnate(byte[] oid, ServantActivator servant_activator, org.omg.PortableServer.POA poa) throws ForwardRequest {
        ByteArrayKey oidbak = new ByteArrayKey(oid);
        Servant servant = null;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("oid: " + POAUtil.convert(oid) + "incarnate");
        }
        while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        if (this.objectMap.containsKey(oidbak)) {
            return (Servant)this.objectMap.get(oidbak);
        }
        if (servant_activator == null) {
            throw new OBJ_ADAPTER("Servant Activator for " + POAUtil.convert(oid) + " was null.");
        }
        this.incarnationList.addElement(oidbak);
        try {
            servant = servant_activator.incarnate(oid, poa);
        }
        finally {
            this.incarnationList.removeElement(oidbak);
            this.notifyAll();
        }
        if (servant == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(oid) + "servant is not incarnated (incarnate returns null)");
            }
        } else if (this.unique && this.servantMap.containsKey(servant)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(oid) + "servant is not incarnated (unique_id policy is violated)");
            }
            servant = null;
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("oid: " + POAUtil.convert(oid) + "servant is incarnated");
            }
            if (this.aomListener != null) {
                this.aomListener.servantIncarnated(oid, servant);
            }
            try {
                this.add(oid, servant);
            }
            catch (ObjectAlreadyActive e) {
                throw new POAInternalError("error: object already active (AOM.incarnate)");
            }
            catch (ServantAlreadyActive e) {
                throw new POAInternalError("error: servant already active (AOM.incarnate)");
            }
        }
        ((POA)poa).getORB().set_delegate(servant);
        return servant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(byte[] oid, RequestController requestController, ServantActivator servantActivator, POA poa, boolean cleanupInProgress) throws ObjectNotActive {
        ByteArrayKey oidbak = new ByteArrayKey(oid);
        byte[] byArray = this.deactivationListLock;
        synchronized (this.deactivationListLock) {
            if (!this.objectMap.containsKey(oidbak) || this.deactivationList.contains(oidbak)) {
                throw new ObjectNotActive();
            }
            this.deactivationList.addElement(oidbak);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            byte[] oid_ = oid;
            RequestController requestController_ = requestController;
            ServantActivator servantActivator_ = servantActivator;
            POA poa_ = poa;
            boolean cleanupInProgress_ = cleanupInProgress;
            RemovalStruct rs = new RemovalStruct(oidbak, requestController, servantActivator, poa, cleanupInProgress);
            try {
                this.removalQueue.put(rs);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _remove(ByteArrayKey oidbak, RequestController requestController, ServantActivator servantActivator, POA poa, boolean cleanupInProgress) {
        byte[] oid = oidbak.getBytes();
        if (!this.objectMap.containsKey(oidbak)) {
            this.deactivationList.removeElement(oidbak);
            return;
        }
        if (requestController != null) {
            requestController.waitForObjectCompletion(oidbak);
        }
        try {
            this.actualRemove(oidbak, servantActivator, poa, cleanupInProgress, oid);
        }
        finally {
            if (requestController != null) {
                requestController.freeObject(oid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void actualRemove(ByteArrayKey oidbak, ServantActivator servantActivator, POA poa, boolean cleanupInProgress, byte[] oid) {
        Servant servant = (Servant)this.objectMap.get(oidbak);
        if (servant == null) {
            return;
        }
        this.objectMap.remove(oidbak);
        if (this.unique) {
            this.servantMap.remove(servant);
        }
        this.deactivationList.removeElement(oidbak);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("oid: " + POAUtil.convert(oid) + "object is deactivated");
        }
        if (this.aomListener != null) {
            this.aomListener.objectDeactivated(oid, servant, this.objectMap.size());
        }
        if (servantActivator == null) {
            this.notifyAll();
            return;
        }
        while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        this.etherealisationList.addElement(oidbak);
        try {
            servantActivator.etherealize(oid, poa, servant, cleanupInProgress, this.contains(servant));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(oid) + "servant is etherealized");
            }
            if (this.aomListener != null) {
                this.aomListener.servantEtherialized(oid, servant);
            }
        }
        catch (SystemException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(oid) + "exception occurred during servant etherialisation: " + e.getMessage());
            }
        }
        finally {
            this.etherealisationList.removeElement(oidbak);
            this.notifyAll();
        }
    }

    protected void removeAll(ServantActivator servant_activator, POA poa, boolean cleanup_in_progress) {
        for (ByteArrayKey oid : new HashSet(this.objectMap.keySet())) {
            this._remove(oid, null, servant_activator, poa, cleanup_in_progress);
        }
    }

    protected synchronized void removeAOMListener(AOMListener listener) {
        this.aomListener = EventMulticaster.remove(this.aomListener, listener);
    }

    protected int size() {
        return this.objectMap.size();
    }

    class RemovalStruct {
        ByteArrayKey oidbak;
        RequestController requestController;
        ServantActivator servantActivator;
        POA poa;
        boolean cleanupInProgress;

        public RemovalStruct(ByteArrayKey oidbak, RequestController requestController, ServantActivator servantActivator, POA poa, boolean cleanupInProgress) {
            this.oidbak = oidbak;
            this.requestController = requestController;
            this.servantActivator = servantActivator;
            this.poa = poa;
            this.cleanupInProgress = cleanupInProgress;
        }
    }
}

