/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.ajp.AjpOpenListener;
import io.undertow.server.OpenListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.as.network.SocketBinding;
import org.wildfly.extension.undertow.AbstractListenerService;
import org.wildfly.extension.undertow.UndertowLogger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public class AJPListenerService
extends AbstractListenerService<AJPListenerService> {
    private volatile AcceptingChannel<StreamConnection> server;

    public AJPListenerService(String name) {
        super(name);
    }

    @Override
    protected OpenListener createOpenListener() {
        return new AjpOpenListener((Pool)this.getBufferPool().getValue(), this.getBufferSize());
    }

    @Override
    void startListening(XnioWorker worker, InetSocketAddress socketAddress, ChannelListener<AcceptingChannel<StreamConnection>> acceptListener) throws IOException {
        this.server = worker.createStreamConnectionServer((SocketAddress)socketAddress, acceptListener, SERVER_OPTIONS);
        this.server.resumeAccepts();
        UndertowLogger.ROOT_LOGGER.listenerStarted("AJP", this.getName(), ((SocketBinding)this.binding.getValue()).getSocketAddress());
    }

    @Override
    void stopListening() {
        this.server.suspendAccepts();
        UndertowLogger.ROOT_LOGGER.listenerSuspend("AJP", this.getName());
        IoUtils.safeClose(this.server);
        UndertowLogger.ROOT_LOGGER.listenerStopped("AJP", this.getName(), ((SocketBinding)this.getBinding().getValue()).getSocketAddress());
    }

    public AJPListenerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public boolean isSecure() {
        return false;
    }
}

