/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.form.MultiPartHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.web.host.ServletBuilder;
import org.jboss.as.web.host.WebDeploymentBuilder;
import org.jboss.as.web.host.WebDeploymentController;
import org.jboss.as.web.host.WebHost;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.EventType;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.UndertowService;

public class Host
implements Service<Host>,
WebHost {
    private final PathHandler pathHandler = new PathHandler();
    private final Set<String> allAliases;
    private final String name;
    private final InjectedValue<Server> server = new InjectedValue();
    private final InjectedValue<UndertowService> undertowService = new InjectedValue();
    private volatile MultiPartHandler rootHandler;

    protected Host(String name, List<String> aliases) {
        this.name = name;
        HashSet<String> hosts = new HashSet<String>(aliases.size() + 1);
        hosts.add(name);
        hosts.addAll(aliases);
        this.allAliases = Collections.unmodifiableSet(hosts);
        this.rootHandler = new MultiPartHandler();
    }

    public void start(StartContext context) throws StartException {
        this.rootHandler.setNext((HttpHandler)this.pathHandler);
        ((Server)this.server.getValue()).registerHost(this);
        UndertowLogger.ROOT_LOGGER.infof("Starting host %s", this.name);
    }

    public void stop(StopContext context) {
        ((Server)this.server.getValue()).unregisterHost(this);
        this.pathHandler.clearPaths();
        UndertowLogger.ROOT_LOGGER.infof("Stopping host %s", this.name);
    }

    public Host getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    protected InjectedValue<Server> getServer() {
        return this.server;
    }

    protected InjectedValue<UndertowService> getUndertowService() {
        return this.undertowService;
    }

    public Set<String> getAllAliases() {
        return this.allAliases;
    }

    public String getName() {
        return this.name;
    }

    protected HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    public void registerDeployment(DeploymentInfo deploymentInfo, HttpHandler handler) {
        String path = ServletContainerService.getDeployedContextPath(deploymentInfo);
        this.registerHandler(path, handler);
        UndertowLogger.ROOT_LOGGER.registerWebapp(path);
        ((UndertowService)this.undertowService.getValue()).fireEvent(EventType.DEPLOYMENT_START, deploymentInfo);
    }

    public void unregisterDeployment(DeploymentInfo deploymentInfo) {
        String path = ServletContainerService.getDeployedContextPath(deploymentInfo);
        this.unregisterHandler(path);
        UndertowLogger.ROOT_LOGGER.unregisterWebapp(path);
        ((UndertowService)this.undertowService.getValue()).fireEvent(EventType.DEPLOYMENT_STOP, deploymentInfo);
    }

    public void registerHandler(String path, HttpHandler handler) {
        this.pathHandler.addPath(path, handler);
    }

    public void unregisterHandler(String path) {
        this.pathHandler.removePath(path);
    }

    public Set<String> getContexts() {
        return this.pathHandler.getPaths().keySet();
    }

    public WebDeploymentController addWebDeployment(WebDeploymentBuilder webDeploymentBuilder) throws Exception {
        DeploymentInfo d = new DeploymentInfo();
        d.setDeploymentName(webDeploymentBuilder.getContextRoot());
        d.setContextPath(webDeploymentBuilder.getContextRoot());
        d.setClassLoader(webDeploymentBuilder.getClassLoader());
        d.setResourceManager((ResourceManager)new FileResourceManager(Paths.get(webDeploymentBuilder.getDocumentRoot().getAbsolutePath(), new String[0])));
        for (ServletBuilder servlet : webDeploymentBuilder.getServlets()) {
            ServletInfo s = servlet.getServlet() == null ? new ServletInfo(servlet.getServletName(), servlet.getServletClass()) : new ServletInfo(servlet.getServletName(), servlet.getServletClass(), (InstanceFactory)new ImmediateInstanceFactory((Object)servlet.getServlet()));
            if (servlet.isForceInit()) {
                s.setLoadOnStartup(Integer.valueOf(1));
            }
            s.addMappings((Collection)servlet.getUrlMappings());
            for (Map.Entry param : servlet.getInitParams().entrySet()) {
                s.addInitParam((String)param.getKey(), (String)param.getValue());
            }
            d.addServlet(s);
        }
        return new WebDeploymentControllerImpl(d);
    }

    private class WebDeploymentControllerImpl
    implements WebDeploymentController {
        private final DeploymentInfo deploymentInfo;
        private volatile DeploymentManager manager;

        private WebDeploymentControllerImpl(DeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
        }

        public void create() throws Exception {
            ServletContainer container = ((ServletContainerService)((Server)Host.this.getServer().getValue()).getServletContainer().getValue()).getServletContainer();
            this.manager = container.addDeployment(this.deploymentInfo);
            this.manager.deploy();
        }

        public void start() throws Exception {
            HttpHandler handler = this.manager.start();
            Host.this.registerDeployment(this.deploymentInfo, handler);
        }

        public void stop() throws Exception {
            this.manager.stop();
            Host.this.unregisterDeployment(this.deploymentInfo);
        }

        public void destroy() throws Exception {
            this.manager.undeploy();
            ServletContainer container = ((ServletContainerService)((Server)Host.this.getServer().getValue()).getServletContainer().getValue()).getServletContainer();
            container.removeDeployment(this.deploymentInfo.getDeploymentName());
        }
    }
}

