/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.filters.FilterService;

public class LocationService
implements Service<LocationService> {
    private final String locationPath;
    private final InjectedValue<HttpHandler> httpHandler = new InjectedValue();
    private final InjectedValue<Host> host = new InjectedValue();
    private final CopyOnWriteArrayList<InjectedValue<FilterService>> injectedFilters = new CopyOnWriteArrayList();

    public LocationService(String locationPath) {
        this.locationPath = locationPath;
    }

    public void start(StartContext context) throws StartException {
        UndertowLogger.ROOT_LOGGER.infof("registering handler %s under path '%s'", this.httpHandler, this.locationPath);
        ((Host)this.host.getValue()).registerHandler(this.locationPath, this.configureHandler());
    }

    public void stop(StopContext context) {
        ((Host)this.host.getValue()).unregisterHandler(this.locationPath);
    }

    public LocationService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    InjectedValue<Host> getHost() {
        return this.host;
    }

    InjectedValue<HttpHandler> getHttpHandler() {
        return this.httpHandler;
    }

    CopyOnWriteArrayList<InjectedValue<FilterService>> getInjectedFilters() {
        return this.injectedFilters;
    }

    private HttpHandler configureHandler() {
        ArrayList<Object> filters = new ArrayList<Object>(this.injectedFilters.size());
        for (InjectedValue<FilterService> injectedFilter : this.injectedFilters) {
            filters.add(injectedFilter.getValue());
        }
        Collections.reverse(filters);
        HttpHandler handler = (HttpHandler)this.getHttpHandler().getValue();
        for (FilterService filterService : filters) {
            handler = filterService.createHttpHandler(handler);
        }
        return handler;
    }
}

