/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ServletContainer;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ServletContainerService
implements Service<ServletContainerService> {
    private volatile ServletContainer servletContainer;
    @Deprecated
    private final Map<String, Integer> secureListeners = new ConcurrentHashMap<String, Integer>(1);

    static String getDeployedContextPath(DeploymentInfo deploymentInfo) {
        return "".equals(deploymentInfo.getContextPath()) ? "/" : deploymentInfo.getContextPath();
    }

    public void start(StartContext context) throws StartException {
        this.servletContainer = ServletContainer.Factory.newInstance();
    }

    public void stop(StopContext context) {
    }

    public ServletContainerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    public Integer lookupSecurePort(String listenerName) {
        Integer response = null;
        response = this.secureListeners.get(listenerName);
        if (response == null) {
            while (response == null && !this.secureListeners.isEmpty()) {
                try {
                    response = this.secureListeners.values().iterator().next();
                }
                catch (ConcurrentModificationException concurrentModificationException) {}
            }
        }
        if (response == null) {
            throw new IllegalStateException("No secure listeners defined.");
        }
        return response;
    }

    public void registerSecurePort(String listenerName, Integer port) {
        this.secureListeners.put(listenerName, port);
    }

    public void unregisterSecurePort(String name) {
        this.secureListeners.remove(name);
    }
}

