/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import java.net.InetSocketAddress;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.wildfly.extension.undertow.session.ClusteredSession;

@MessageLogger(projectCode="JBAS")
public interface UndertowLogger
extends BasicLogger {
    public static final UndertowLogger ROOT_LOGGER = (UndertowLogger)Logger.getMessageLogger(UndertowLogger.class, (String)UndertowLogger.class.getPackage().getName());
    public static final UndertowLogger WEB_SESSION_LOGGER = (UndertowLogger)Logger.getMessageLogger(UndertowLogger.class, (String)(UndertowLogger.class.getPackage().getName() + ".sessions"));

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18200, value="Failed to start welcome context")
    public void stopWelcomeContextFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18201, value="Failed to destroy welcome context")
    public void destroyWelcomeContextFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18202, value="Error calling onStartup for servlet container initializer: %s")
    public void sciOnStartupError(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18203, value="Error instantiating container component: %s")
    public void componentInstanceCreationFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18204, value="Clustering not supported, falling back to non-clustered session manager")
    public void clusteringNotSupported();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18205, value="Cannot setup overlays for [%s] due to custom resources")
    public void noOverlay(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18206, value="Webapp [%s] is unavailable due to startup errors")
    public void unavailable(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18208, value="Failed to start context")
    public void stopContextFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18209, value="Failed to destroy context")
    public void destroyContextFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18210, value="Register web context: %s")
    public void registerWebapp(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18214, value="Error during login/password authenticate")
    public void authenticateError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18215, value="Error during certificate authenticate")
    public void authenticateErrorCert(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18216, value="Error during digest authenticate")
    public void authenticateErrorDigest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18217, value="Error obtaining authorization helper")
    public void noAuthorizationHelper(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18218, value="Exception in obtaining server authentication manager")
    public void noServerAuthenticationManager(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18219, value="JASPI validation for unprotected request context %s failed")
    public void failJASPIValidation(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=18220, value="Caught Exception: %s")
    public void unsupportedEncoding(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18221, value="Error forwarding to login page: %s")
    public void errorForwardingToLoginPage(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18222, value="Error forwarding to error page: %s")
    public void errorForwardingToErrorPage(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18223, value="Snapshot mode set to 'interval' but snapshotInterval is < 1 or was not specified, using 'instant'")
    public void invalidSnapshotInterval();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18224, value="Unregister web context: %s")
    public void unregisterWebapp(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18226, value="Skipped SCI for jar: %s.")
    public void skippedSCI(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17500, value="Could not initialize JSP")
    public void couldNotInitJsp(@Cause ClassNotFoundException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17501, value="Failed to purge EL cache.")
    public void couldNotPurgeELCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17502, value="Undertow %s starting")
    public void serverStarting(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17506, value="Undertow %s stopping")
    public void serverStopping(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17507, value="Failed to queue session replication for session %s")
    public void failedQueueingSessionReplication(ClusteredSession<? extends OutgoingDistributableSessionData> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17508, value="Exception processing sessions")
    public void exceptionProcessingSessions(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17509, value="Failed to store session %s")
    public void failedToStoreSession(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17510, value="Failed to replicate session %s")
    public void failedToReplicateSession(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17511, value="Failed to passivate session %s")
    public void errorPassivatingSession(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17512, value="Received notification for inactive session %s")
    public void notificationForInactiveSession(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17513, value="Failed to load passivated session %s")
    public void failToPassivateLoad(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17514, value="Brute force cleanup failed for session %s")
    public void failToBruteForceCleanup(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17515, value="Problem running expiration passivation")
    public void processExpirationPassivationException(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17516, value="Failed to passivate %s %s")
    public void failToPassivate(String var1, String var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17517, value="Failed to rollback transaction")
    public void exceptionRollingBackTransaction(@Cause RuntimeException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17518, value="Performing brute force cleanup on %s due to %s")
    public void bruteForceCleanup(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17519, value="Undertow %s listener %s listening on %s")
    public void listenerStarted(String var1, String var2, InetSocketAddress var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17520, value="Undertow %s listener %s stopped, was bound to %s")
    public void listenerStopped(String var1, String var2, InetSocketAddress var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17521, value="Undertow %s listener %s suspending")
    public void listenerSuspend(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17522, value="Could not load class designated by HandlesTypes [%s].")
    public void cannotLoadDesignatedHandleTypes(ClassInfo var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17523, value="Could not load web socket endpoint %s.")
    public void couldNotLoadWebSocketEndpoint(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17524, value="Could not load web socket application config %s.")
    public void couldNotLoadWebSocketConfig(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17525, value="Started http handler %s.")
    public void startedHttpHandler(HttpHandler var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17526, value="Could not create redirect URI.")
    public void invalidRedirectURI(@Cause Throwable var1);
}

