/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.jsp.JspFileWrapper;
import io.undertow.jsp.JspServletBuilder;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.resource.CachingResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.ConfidentialPortManager;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.SessionManagerFactory;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.util.ConstructorInstanceFactory;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.jasper.deploy.FunctionInfo;
import org.apache.jasper.deploy.JspPropertyGroup;
import org.apache.jasper.deploy.TagAttributeInfo;
import org.apache.jasper.deploy.TagFileInfo;
import org.apache.jasper.deploy.TagInfo;
import org.apache.jasper.deploy.TagLibraryInfo;
import org.apache.jasper.deploy.TagLibraryValidatorInfo;
import org.apache.jasper.deploy.TagVariableInfo;
import org.apache.jasper.servlet.JspServlet;
import org.apache.tomcat.InstanceManager;
import org.jboss.annotation.javaee.Icon;
import org.jboss.as.clustering.ClassLoaderAwareClassResolver;
import org.jboss.as.clustering.web.DistributedCacheManagerFactory;
import org.jboss.as.ee.component.ComponentRegistry;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.web.common.ServletContextAttribute;
import org.jboss.as.web.common.WebInjectionContainer;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AttributeMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.EmptyRoleSemanticType;
import org.jboss.metadata.web.spec.ErrorPageMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FunctionMetaData;
import org.jboss.metadata.web.spec.HttpMethodConstraintMetaData;
import org.jboss.metadata.web.spec.JspConfigMetaData;
import org.jboss.metadata.web.spec.JspPropertyGroupMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.LocaleEncodingMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.MimeMappingMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.TagFileMetaData;
import org.jboss.metadata.web.spec.TagMetaData;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.metadata.web.spec.VariableMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.audit.AuditManager;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.JspConfigDescriptorImpl;
import org.wildfly.extension.undertow.deployment.ScisMetaData;
import org.wildfly.extension.undertow.deployment.TldsMetaData;
import org.wildfly.extension.undertow.deployment.UndertowJSPInstanceManager;
import org.wildfly.extension.undertow.security.AuditNotificationReceiver;
import org.wildfly.extension.undertow.security.JAASIdentityManagerImpl;
import org.wildfly.extension.undertow.security.SecurityContextAssociationHandler;
import org.wildfly.extension.undertow.security.SecurityContextCreationHandler;
import org.wildfly.extension.undertow.session.DistributableSessionManager;

public class UndertowDeploymentInfoService
implements Service<DeploymentInfo> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"UndertowDeploymentInfoService"});
    private DeploymentInfo deploymentInfo;
    private final JBossWebMetaData mergedMetaData;
    private final String deploymentName;
    private final TldsMetaData tldsMetaData;
    private final List<TldMetaData> sharedTlds;
    private final Module module;
    private final DeploymentClassIndex classReflectionIndex;
    private final WebInjectionContainer injectionContainer;
    private final ComponentRegistry componentRegistry;
    private final ScisMetaData scisMetaData;
    private final VirtualFile deploymentRoot;
    private final String securityContextId;
    private final String securityDomain;
    private final List<ServletContextAttribute> attributes;
    private final String contextPath;
    private final List<SetupAction> setupActions;
    private final InjectedValue<UndertowService> undertowService = new InjectedValue();
    private final InjectedValue<DistributedCacheManagerFactory> distributedCacheManagerFactoryInjectedValue = new InjectedValue();
    private final InjectedValue<SecurityDomainContext> securityDomainContextValue = new InjectedValue();
    private final InjectedValue<ServletContainerService> container = new InjectedValue();
    private final InjectedValue<DirectBufferCache> bufferCacheInjectedValue = new InjectedValue();

    private UndertowDeploymentInfoService(JBossWebMetaData mergedMetaData, String deploymentName, TldsMetaData tldsMetaData, List<TldMetaData> sharedTlds, Module module, DeploymentClassIndex classReflectionIndex, WebInjectionContainer injectionContainer, ComponentRegistry componentRegistry, ScisMetaData scisMetaData, VirtualFile deploymentRoot, String securityContextId, String securityDomain, List<ServletContextAttribute> attributes, String contextPath, List<SetupAction> setupActions) {
        this.mergedMetaData = mergedMetaData;
        this.deploymentName = deploymentName;
        this.tldsMetaData = tldsMetaData;
        this.sharedTlds = sharedTlds;
        this.module = module;
        this.classReflectionIndex = classReflectionIndex;
        this.injectionContainer = injectionContainer;
        this.componentRegistry = componentRegistry;
        this.scisMetaData = scisMetaData;
        this.deploymentRoot = deploymentRoot;
        this.securityContextId = securityContextId;
        this.securityDomain = securityDomain;
        this.attributes = attributes;
        this.contextPath = contextPath;
        this.setupActions = setupActions;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        DeploymentInfo deploymentInfo = this.createServletConfig();
        this.handleSessionReplication(deploymentInfo);
        this.handleIdentityManager(deploymentInfo);
        if (this.mergedMetaData.getSessionConfig() != null && this.mergedMetaData.getSessionConfig().getSessionTimeoutSet()) {
            deploymentInfo.setDefaultSessionTimeout(this.mergedMetaData.getSessionConfig().getSessionTimeout() * 60);
        }
        for (final SetupAction action : this.setupActions) {
            deploymentInfo.addThreadSetupAction(new ThreadSetupAction(){
                private final ThreadSetupAction.Handle handle = new ThreadSetupAction.Handle(){

                    public void tearDown() {
                        action.teardown(Collections.EMPTY_MAP);
                    }
                };

                public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
                    action.setup(Collections.EMPTY_MAP);
                    return this.handle;
                }
            });
        }
        this.deploymentInfo = deploymentInfo;
    }

    public synchronized void stop(StopContext stopContext) {
        this.deploymentInfo = null;
    }

    public synchronized DeploymentInfo getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentInfo;
    }

    private void handleIdentityManager(DeploymentInfo deploymentInfo) {
        SecurityDomainContext sdc = (SecurityDomainContext)this.securityDomainContextValue.getValue();
        deploymentInfo.setIdentityManager((IdentityManager)new JAASIdentityManagerImpl(sdc, this.mergedMetaData.getPrincipalVersusRolesMap()));
        AuditManager auditManager = sdc.getAuditManager();
        if (auditManager != null && !this.mergedMetaData.isDisableAudit()) {
            deploymentInfo.addNotificationReceiver((NotificationReceiver)new AuditNotificationReceiver(auditManager));
        }
        deploymentInfo.setConfidentialPortManager(this.getConfidentialPortManager());
    }

    private ConfidentialPortManager getConfidentialPortManager() {
        return new ConfidentialPortManager(){

            public int getConfidentialPort(HttpServerExchange exchange) {
                return ((ServletContainerService)UndertowDeploymentInfoService.this.container.getValue()).lookupSecurePort("default");
            }
        };
    }

    private void handleSessionReplication(DeploymentInfo deploymentInfo) {
        if (this.mergedMetaData.getDistributable() != null) {
            String instanceId = ((UndertowService)this.undertowService.getValue()).getInstanceId();
            ModularClassResolver resolver = ModularClassResolver.getInstance((ModuleLoader)this.module.getModuleLoader());
            final DistributableSessionManager sessionManager = new DistributableSessionManager((DistributedCacheManagerFactory)this.distributedCacheManagerFactoryInjectedValue.getValue(), this.mergedMetaData, (ClassResolver)new ClassLoaderAwareClassResolver((ClassResolver)resolver, (ClassLoader)this.module.getClassLoader()), deploymentInfo.getContextPath(), (ClassLoader)this.module.getClassLoader(), instanceId);
            deploymentInfo.setSessionManagerFactory((SessionManagerFactory)new ImmediateSessionManagerFactory(sessionManager));
            deploymentInfo.addOuterHandlerChainWrapper(new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return sessionManager.wrapHandlers(handler);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private DeploymentInfo createServletConfig() throws StartException {
        try {
            LoginConfigMetaData loginConfigMetaData;
            this.mergedMetaData.resolveAnnotations();
            DeploymentInfo d = new DeploymentInfo();
            d.setContextPath(this.contextPath);
            if (this.mergedMetaData.getDescriptionGroup() != null) {
                d.setDisplayName(this.mergedMetaData.getDescriptionGroup().getDisplayName());
            }
            d.setDeploymentName(this.deploymentName);
            try {
                d.setResourceManager((ResourceManager)new CachingResourceManager(100, 0xA00000L, (DirectBufferCache)this.bufferCacheInjectedValue.getOptionalValue(), (ResourceManager)new FileResourceManager(Paths.get(this.deploymentRoot.getPhysicalFile().getAbsolutePath(), new String[0])), -1));
            }
            catch (IOException e) {
                throw new StartException((Throwable)e);
            }
            d.setClassLoader((ClassLoader)this.module.getClassLoader());
            String servletVersion = this.mergedMetaData.getServletVersion();
            if (servletVersion != null) {
                d.setMajorVersion(Integer.parseInt(servletVersion.charAt(0) + ""));
                d.setMinorVersion(Integer.parseInt(servletVersion.charAt(2) + ""));
            } else {
                d.setMajorVersion(3);
                d.setMinorVersion(1);
            }
            boolean is22OrOlder = d.getMajorVersion() == 1 ? true : (d.getMajorVersion() == 2 ? d.getMinorVersion() < 3 : false);
            HashMap<String, TagLibraryInfo> tldInfo = UndertowDeploymentInfoService.createTldsInfo(this.tldsMetaData, this.sharedTlds, this.classReflectionIndex, this.componentRegistry, d);
            HashMap<String, JspPropertyGroup> propertyGroups = UndertowDeploymentInfoService.createJspConfig(this.mergedMetaData);
            JspServletBuilder.setupDeployment((DeploymentInfo)d, propertyGroups, tldInfo, (InstanceManager)new UndertowJSPInstanceManager(this.injectionContainer));
            d.setJspConfigDescriptor((JspConfigDescriptor)new JspConfigDescriptorImpl(tldInfo.values(), propertyGroups.values()));
            d.setDefaultServletConfig(new DefaultServletConfig(true, Collections.emptySet()));
            ServletInfo jspServlet = new ServletInfo("Default JSP Servlet", JspServlet.class).addMapping("*.jsp").addMapping("*.jspx").addInitParam("development", "false");
            d.addServlet(jspServlet);
            Set<String> jspPropertyGroupMappings = propertyGroups.keySet();
            for (String mapping : jspPropertyGroupMappings) {
                jspServlet.addMapping(mapping);
            }
            d.setClassIntrospecter((ClassIntrospecter)new ComponentClassIntrospector(this.componentRegistry));
            HashMap servletMappings = new HashMap();
            if (this.mergedMetaData.getServletMappings() != null) {
                for (ServletMappingMetaData mapping : this.mergedMetaData.getServletMappings()) {
                    void var11_13;
                    List list = (List)servletMappings.get(mapping.getServletName());
                    if (list == null) {
                        ArrayList arrayList = new ArrayList();
                        servletMappings.put(mapping.getServletName(), arrayList);
                    }
                    var11_13.add(mapping);
                }
            }
            HashSet<String> seenMappings = new HashSet<String>(jspPropertyGroupMappings);
            if (this.mergedMetaData.getServlets() != null) {
                for (JBossServletMetaData jBossServletMetaData : this.mergedMetaData.getServlets()) {
                    List mappings;
                    ServletInfo s;
                    if (jBossServletMetaData.getJspFile() != null) {
                        s = new ServletInfo(jBossServletMetaData.getName(), JspServlet.class);
                        s.addHandlerChainWrapper((HandlerWrapper)new JspFileWrapper(jBossServletMetaData.getJspFile()));
                    } else {
                        Class servletClass = this.classReflectionIndex.classIndex(jBossServletMetaData.getServletClass()).getModuleClass();
                        ComponentRegistry.ComponentManagedReferenceFactory creator = (ComponentRegistry.ComponentManagedReferenceFactory)this.componentRegistry.getComponentsByClass().get(servletClass);
                        if (creator != null) {
                            InstanceFactory factory = UndertowDeploymentInfoService.createInstanceFactory(creator);
                            s = new ServletInfo(jBossServletMetaData.getName(), servletClass, factory);
                        } else {
                            s = new ServletInfo(jBossServletMetaData.getName(), servletClass);
                        }
                    }
                    s.setAsyncSupported(jBossServletMetaData.isAsyncSupported()).setJspFile(jBossServletMetaData.getJspFile()).setEnabled(jBossServletMetaData.isEnabled());
                    if (jBossServletMetaData.getRunAs() != null) {
                        s.setRunAs(jBossServletMetaData.getRunAs().getRoleName());
                    }
                    if (jBossServletMetaData.getLoadOnStartupSet()) {
                        s.setLoadOnStartup(Integer.valueOf(jBossServletMetaData.getLoadOnStartupInt()));
                    }
                    if ((mappings = (List)servletMappings.get(jBossServletMetaData.getName())) != null) {
                        for (ServletMappingMetaData mapping : mappings) {
                            for (String pattern : mapping.getUrlPatterns()) {
                                if (is22OrOlder && !pattern.startsWith("*") && !pattern.startsWith("/")) {
                                    pattern = "/" + pattern;
                                }
                                if (seenMappings.contains(pattern)) continue;
                                s.addMapping(pattern);
                                seenMappings.add(pattern);
                            }
                        }
                    }
                    if (jBossServletMetaData.getInitParam() != null) {
                        for (ParamValueMetaData initParam : jBossServletMetaData.getInitParam()) {
                            if (s.getInitParams().containsKey(initParam.getParamName())) continue;
                            s.addInitParam(initParam.getParamName(), initParam.getParamValue());
                        }
                    }
                    if (jBossServletMetaData.getServletSecurity() != null) {
                        ServletSecurityInfo securityInfo = new ServletSecurityInfo();
                        s.setServletSecurityInfo(securityInfo);
                        ((ServletSecurityInfo)((ServletSecurityInfo)securityInfo.setEmptyRoleSemantic(jBossServletMetaData.getServletSecurity().getEmptyRoleSemantic() == EmptyRoleSemanticType.PERMIT ? SecurityInfo.EmptyRoleSemantic.PERMIT : SecurityInfo.EmptyRoleSemantic.DENY)).setTransportGuaranteeType(UndertowDeploymentInfoService.transportGuaranteeType(jBossServletMetaData.getServletSecurity().getTransportGuarantee()))).addRolesAllowed((Collection)jBossServletMetaData.getServletSecurity().getRolesAllowed());
                        if (jBossServletMetaData.getServletSecurity().getHttpMethodConstraints() != null) {
                            for (HttpMethodConstraintMetaData method : jBossServletMetaData.getServletSecurity().getHttpMethodConstraints()) {
                                securityInfo.addHttpMethodSecurityInfo(((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)((HttpMethodSecurityInfo)new HttpMethodSecurityInfo().setEmptyRoleSemantic(method.getEmptyRoleSemantic() == EmptyRoleSemanticType.PERMIT ? SecurityInfo.EmptyRoleSemantic.PERMIT : SecurityInfo.EmptyRoleSemantic.DENY)).setTransportGuaranteeType(UndertowDeploymentInfoService.transportGuaranteeType(method.getTransportGuarantee()))).addRolesAllowed((Collection)method.getRolesAllowed())).setMethod(method.getMethod()));
                            }
                        }
                    }
                    if (jBossServletMetaData.getSecurityRoleRefs() != null) {
                        for (SecurityRoleRefMetaData ref : jBossServletMetaData.getSecurityRoleRefs()) {
                            s.addSecurityRoleRef(ref.getRoleName(), ref.getRoleLink());
                        }
                    }
                    d.addServlet(s);
                }
            }
            if (this.mergedMetaData.getFilters() != null) {
                for (FilterMetaData filterMetaData : this.mergedMetaData.getFilters()) {
                    FilterInfo f;
                    Class filterClass = this.classReflectionIndex.classIndex(filterMetaData.getFilterClass()).getModuleClass();
                    ComponentRegistry.ComponentManagedReferenceFactory creator = (ComponentRegistry.ComponentManagedReferenceFactory)this.componentRegistry.getComponentsByClass().get(filterClass);
                    if (creator != null) {
                        InstanceFactory instanceFactory = UndertowDeploymentInfoService.createInstanceFactory(creator);
                        f = new FilterInfo(filterMetaData.getName(), filterClass, instanceFactory);
                    } else {
                        f = new FilterInfo(filterMetaData.getName(), filterClass);
                    }
                    f.setAsyncSupported(filterMetaData.isAsyncSupported());
                    d.addFilter(f);
                    if (filterMetaData.getInitParam() == null) continue;
                    for (ParamValueMetaData initParam : filterMetaData.getInitParam()) {
                        f.addInitParam(initParam.getParamName(), initParam.getParamValue());
                    }
                }
            }
            if (this.mergedMetaData.getFilterMappings() != null) {
                for (FilterMappingMetaData filterMappingMetaData : this.mergedMetaData.getFilterMappings()) {
                    if (filterMappingMetaData.getUrlPatterns() != null) {
                        for (String url : filterMappingMetaData.getUrlPatterns()) {
                            if (is22OrOlder && !url.startsWith("*") && !url.startsWith("/")) {
                                url = "/" + url;
                            }
                            if (filterMappingMetaData.getDispatchers() != null && !filterMappingMetaData.getDispatchers().isEmpty()) {
                                for (DispatcherType dispatcher : filterMappingMetaData.getDispatchers()) {
                                    d.addFilterUrlMapping(filterMappingMetaData.getFilterName(), url, javax.servlet.DispatcherType.valueOf((String)dispatcher.name()));
                                }
                                continue;
                            }
                            d.addFilterUrlMapping(filterMappingMetaData.getFilterName(), url, javax.servlet.DispatcherType.REQUEST);
                        }
                    }
                    if (filterMappingMetaData.getServletNames() == null) continue;
                    for (String servletName : filterMappingMetaData.getServletNames()) {
                        if (filterMappingMetaData.getDispatchers() != null && !filterMappingMetaData.getDispatchers().isEmpty()) {
                            for (DispatcherType dispatcher : filterMappingMetaData.getDispatchers()) {
                                d.addFilterServletNameMapping(filterMappingMetaData.getFilterName(), servletName, javax.servlet.DispatcherType.valueOf((String)dispatcher.name()));
                            }
                            continue;
                        }
                        d.addFilterServletNameMapping(filterMappingMetaData.getFilterName(), servletName, javax.servlet.DispatcherType.REQUEST);
                    }
                }
            }
            if (this.scisMetaData != null && this.scisMetaData.getHandlesTypes() != null) {
                for (Map.Entry entry : this.scisMetaData.getHandlesTypes().entrySet()) {
                    ImmediateInstanceFactory instanceFactory = new ImmediateInstanceFactory(entry.getKey());
                    d.addServletContainerInitalizer(new ServletContainerInitializerInfo(((ServletContainerInitializer)entry.getKey()).getClass(), (InstanceFactory)instanceFactory, (Set)entry.getValue()));
                }
            }
            if (this.mergedMetaData.getListeners() != null) {
                for (ListenerMetaData listenerMetaData : this.mergedMetaData.getListeners()) {
                    UndertowDeploymentInfoService.addListener(this.classReflectionIndex, this.componentRegistry, d, listenerMetaData);
                }
            }
            if (this.mergedMetaData.getContextParams() != null) {
                for (ParamValueMetaData paramValueMetaData : this.mergedMetaData.getContextParams()) {
                    d.addInitParameter(paramValueMetaData.getParamName(), paramValueMetaData.getParamValue());
                }
            }
            if (this.mergedMetaData.getWelcomeFileList() != null && this.mergedMetaData.getWelcomeFileList().getWelcomeFiles() != null) {
                List welcomeFiles = this.mergedMetaData.getWelcomeFileList().getWelcomeFiles();
                for (String file : welcomeFiles) {
                    if (file.startsWith("/")) {
                        d.addWelcomePages(file.substring(1));
                        continue;
                    }
                    d.addWelcomePages((Collection)welcomeFiles);
                }
            } else {
                d.addWelcomePages(new String[]{"index.html", "index.htm", "index.jsp"});
            }
            if (this.mergedMetaData.getErrorPages() != null) {
                for (ErrorPageMetaData errorPageMetaData : this.mergedMetaData.getErrorPages()) {
                    ErrorPage errorPage = errorPageMetaData.getExceptionType() == null || errorPageMetaData.getExceptionType().isEmpty() ? new ErrorPage(errorPageMetaData.getLocation(), Integer.parseInt(errorPageMetaData.getErrorCode())) : new ErrorPage(errorPageMetaData.getLocation(), this.classReflectionIndex.classIndex(errorPageMetaData.getExceptionType()).getModuleClass());
                    d.addErrorPages(new ErrorPage[]{errorPage});
                }
            }
            if (this.mergedMetaData.getMimeMappings() != null) {
                for (MimeMappingMetaData mimeMappingMetaData : this.mergedMetaData.getMimeMappings()) {
                    d.addMimeMapping(new MimeMapping(mimeMappingMetaData.getExtension(), mimeMappingMetaData.getMimeType()));
                }
            }
            Set securityRoleNames = this.mergedMetaData.getSecurityRoleNames();
            if (this.mergedMetaData.getSecurityConstraints() != null) {
                for (SecurityConstraintMetaData constraint : this.mergedMetaData.getSecurityConstraints()) {
                    SecurityConstraint securityConstraint = (SecurityConstraint)new SecurityConstraint().setTransportGuaranteeType(UndertowDeploymentInfoService.transportGuaranteeType(constraint.getTransportGuarantee()));
                    List roleNames = constraint.getRoleNames();
                    if (constraint.getAuthConstraint() == null) {
                        securityConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT);
                    } else if (roleNames.size() == 1 && roleNames.contains("*") && securityRoleNames.contains("*")) {
                        securityConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.AUTHENTICATE);
                    } else {
                        securityConstraint.addRolesAllowed((Collection)roleNames);
                    }
                    if (constraint.getResourceCollections() != null) {
                        for (WebResourceCollectionMetaData resourceCollection : constraint.getResourceCollections()) {
                            securityConstraint.addWebResourceCollection(new WebResourceCollection().addHttpMethods((Collection)resourceCollection.getHttpMethods()).addHttpMethodOmissions((Collection)resourceCollection.getHttpMethodOmissions()).addUrlPatterns((Collection)resourceCollection.getUrlPatterns()));
                        }
                    }
                    d.addSecurityConstraint(securityConstraint);
                }
            }
            if ((loginConfigMetaData = this.mergedMetaData.getLoginConfig()) != null) {
                String authMethod = UndertowDeploymentInfoService.authMethod(loginConfigMetaData.getAuthMethod());
                if (loginConfigMetaData.getFormLoginConfig() != null) {
                    d.setLoginConfig(new LoginConfig(authMethod, loginConfigMetaData.getRealmName(), loginConfigMetaData.getFormLoginConfig().getLoginPage(), loginConfigMetaData.getFormLoginConfig().getErrorPage()));
                } else {
                    d.setLoginConfig(new LoginConfig(authMethod, loginConfigMetaData.getRealmName()));
                }
            }
            d.addSecurityRoles((Collection)this.mergedMetaData.getSecurityRoleNames());
            d.addOuterHandlerChainWrapper(SecurityContextCreationHandler.wrapper(this.securityDomain));
            d.addInnerHandlerChainWrapper(SecurityContextAssociationHandler.wrapper(this.mergedMetaData.getPrincipalVersusRolesMap(), this.mergedMetaData.getRunAsIdentity(), this.securityContextId));
            for (ServletContextAttribute attribute : this.attributes) {
                d.addServletContextAttribute(attribute.getName(), attribute.getValue());
            }
            if (this.mergedMetaData.getLocalEncodings() != null && this.mergedMetaData.getLocalEncodings().getMappings() != null) {
                for (LocaleEncodingMetaData locale : this.mergedMetaData.getLocalEncodings().getMappings()) {
                    d.addLocaleCharsetMapping(locale.getLocale(), locale.getEncoding());
                }
            }
            return d;
        }
        catch (ClassNotFoundException e) {
            throw new StartException((Throwable)e);
        }
    }

    private static String authMethod(String configuredMethod) {
        if (configuredMethod.equals("CLIENT-CERT")) {
            return "CLIENT_CERT";
        }
        return configuredMethod;
    }

    private static TransportGuaranteeType transportGuaranteeType(org.jboss.metadata.web.spec.TransportGuaranteeType type) {
        if (type == null) {
            return TransportGuaranteeType.NONE;
        }
        switch (type) {
            case CONFIDENTIAL: {
                return TransportGuaranteeType.CONFIDENTIAL;
            }
            case INTEGRAL: {
                return TransportGuaranteeType.INTEGRAL;
            }
            case NONE: {
                return TransportGuaranteeType.NONE;
            }
        }
        throw new RuntimeException("UNREACHABLE");
    }

    private static HashMap<String, JspPropertyGroup> createJspConfig(JBossWebMetaData metaData) {
        List groups;
        HashMap<String, JspPropertyGroup> result = new HashMap<String, JspPropertyGroup>();
        JspConfigMetaData config = metaData.getJspConfig();
        if (config != null && (groups = config.getPropertyGroups()) != null) {
            for (JspPropertyGroupMetaData group : groups) {
                JspPropertyGroup jspPropertyGroup = new JspPropertyGroup();
                for (String pattern : group.getUrlPatterns()) {
                    jspPropertyGroup.addUrlPattern(pattern);
                }
                jspPropertyGroup.setElIgnored(group.getElIgnored());
                jspPropertyGroup.setPageEncoding(group.getPageEncoding());
                jspPropertyGroup.setScriptingInvalid(group.getScriptingInvalid());
                jspPropertyGroup.setIsXml(group.getIsXml());
                if (group.getIncludePreludes() != null) {
                    for (String includePrelude : group.getIncludePreludes()) {
                        jspPropertyGroup.addIncludePrelude(includePrelude);
                    }
                }
                if (group.getIncludeCodas() != null) {
                    for (String includeCoda : group.getIncludeCodas()) {
                        jspPropertyGroup.addIncludeCoda(includeCoda);
                    }
                }
                jspPropertyGroup.setDeferredSyntaxAllowedAsLiteral(group.getDeferredSyntaxAllowedAsLiteral());
                jspPropertyGroup.setTrimDirectiveWhitespaces(group.getTrimDirectiveWhitespaces());
                jspPropertyGroup.setDefaultContentType(group.getDefaultContentType());
                jspPropertyGroup.setBuffer(group.getBuffer());
                jspPropertyGroup.setErrorOnUndeclaredNamespace(group.getErrorOnUndeclaredNamespace());
                for (String pattern : jspPropertyGroup.getUrlPatterns()) {
                    result.put(pattern, jspPropertyGroup);
                }
            }
        }
        LinkedHashMap<String, JspPropertyGroup> ret = new LinkedHashMap<String, JspPropertyGroup>();
        ArrayList paths = new ArrayList(result.keySet());
        Collections.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }
        });
        for (String path : paths) {
            ret.put(path, (JspPropertyGroup)result.get(path));
        }
        return ret;
    }

    private static HashMap<String, TagLibraryInfo> createTldsInfo(TldsMetaData tldsMetaData, List<TldMetaData> sharedTlds, DeploymentClassIndex classReflectionIndex, ComponentRegistry components, DeploymentInfo d) throws ClassNotFoundException {
        HashMap<String, TagLibraryInfo> ret = new HashMap<String, TagLibraryInfo>();
        if (tldsMetaData != null) {
            if (tldsMetaData.getTlds() != null) {
                for (Map.Entry<String, TldMetaData> tld : tldsMetaData.getTlds().entrySet()) {
                    UndertowDeploymentInfoService.createTldInfo(tld.getKey(), tld.getValue(), ret, classReflectionIndex, components, d);
                }
            }
            if (sharedTlds != null) {
                for (TldMetaData metaData : sharedTlds) {
                    UndertowDeploymentInfoService.createTldInfo(null, metaData, ret, classReflectionIndex, components, d);
                }
            }
        }
        return ret;
    }

    private static TagLibraryInfo createTldInfo(String location, TldMetaData tldMetaData, HashMap<String, TagLibraryInfo> ret, DeploymentClassIndex classReflectionIndex, ComponentRegistry components, DeploymentInfo d) throws ClassNotFoundException {
        int pos;
        String relativeLocation = location;
        String jarPath = null;
        if (relativeLocation != null && relativeLocation.startsWith("/WEB-INF/lib/") && (pos = relativeLocation.indexOf(47, "/WEB-INF/lib/".length())) > 0) {
            jarPath = relativeLocation.substring(pos);
            if (jarPath.startsWith("/")) {
                jarPath = jarPath.substring(1);
            }
            relativeLocation = relativeLocation.substring(0, pos);
        }
        TagLibraryInfo tagLibraryInfo = new TagLibraryInfo();
        tagLibraryInfo.setTlibversion(tldMetaData.getTlibVersion());
        if (tldMetaData.getJspVersion() == null) {
            tagLibraryInfo.setJspversion(tldMetaData.getVersion());
        } else {
            tagLibraryInfo.setJspversion(tldMetaData.getJspVersion());
        }
        tagLibraryInfo.setShortname(tldMetaData.getShortName());
        tagLibraryInfo.setUri(tldMetaData.getUri());
        if (tldMetaData.getDescriptionGroup() != null) {
            tagLibraryInfo.setInfo(tldMetaData.getDescriptionGroup().getDescription());
        }
        if (tldMetaData.getValidator() != null) {
            TagLibraryValidatorInfo tagLibraryValidatorInfo = new TagLibraryValidatorInfo();
            tagLibraryValidatorInfo.setValidatorClass(tldMetaData.getValidator().getValidatorClass());
            if (tldMetaData.getValidator().getInitParams() != null) {
                for (ParamValueMetaData paramValueMetaData : tldMetaData.getValidator().getInitParams()) {
                    tagLibraryValidatorInfo.addInitParam(paramValueMetaData.getParamName(), (Object)paramValueMetaData.getParamValue());
                }
            }
            tagLibraryInfo.setValidator(tagLibraryValidatorInfo);
        }
        if (tldMetaData.getTags() != null) {
            for (TagMetaData tagMetaData : tldMetaData.getTags()) {
                TagInfo tagInfo = new TagInfo();
                tagInfo.setTagName(tagMetaData.getName());
                tagInfo.setTagClassName(tagMetaData.getTagClass());
                tagInfo.setTagExtraInfo(tagMetaData.getTeiClass());
                if (tagMetaData.getBodyContent() != null) {
                    tagInfo.setBodyContent(tagMetaData.getBodyContent().toString());
                }
                tagInfo.setDynamicAttributes(tagMetaData.getDynamicAttributes());
                if (tagMetaData.getDescriptionGroup() != null) {
                    DescriptionGroupMetaData descriptionGroup = tagMetaData.getDescriptionGroup();
                    if (descriptionGroup.getIcons() != null && descriptionGroup.getIcons().value() != null && descriptionGroup.getIcons().value().length > 0) {
                        Icon icon = descriptionGroup.getIcons().value()[0];
                        tagInfo.setLargeIcon(icon.largeIcon());
                        tagInfo.setSmallIcon(icon.smallIcon());
                    }
                    tagInfo.setInfoString(descriptionGroup.getDescription());
                    tagInfo.setDisplayName(descriptionGroup.getDisplayName());
                }
                if (tagMetaData.getVariables() != null) {
                    for (VariableMetaData variableMetaData : tagMetaData.getVariables()) {
                        TagVariableInfo tagVariableInfo = new TagVariableInfo();
                        tagVariableInfo.setNameGiven(variableMetaData.getNameGiven());
                        tagVariableInfo.setNameFromAttribute(variableMetaData.getNameFromAttribute());
                        tagVariableInfo.setClassName(variableMetaData.getVariableClass());
                        tagVariableInfo.setDeclare(variableMetaData.getDeclare());
                        if (variableMetaData.getScope() != null) {
                            tagVariableInfo.setScope(variableMetaData.getScope().toString());
                        }
                        tagInfo.addTagVariableInfo(tagVariableInfo);
                    }
                }
                if (tagMetaData.getAttributes() != null) {
                    for (AttributeMetaData attributeMetaData : tagMetaData.getAttributes()) {
                        TagAttributeInfo tagAttributeInfo = new TagAttributeInfo();
                        tagAttributeInfo.setName(attributeMetaData.getName());
                        tagAttributeInfo.setType(attributeMetaData.getType());
                        tagAttributeInfo.setReqTime(attributeMetaData.getRtexprvalue());
                        tagAttributeInfo.setRequired(attributeMetaData.getRequired());
                        tagAttributeInfo.setFragment(attributeMetaData.getFragment());
                        if (attributeMetaData.getDeferredValue() != null) {
                            tagAttributeInfo.setDeferredValue("true");
                            tagAttributeInfo.setExpectedTypeName(attributeMetaData.getDeferredValue().getType());
                        } else {
                            tagAttributeInfo.setDeferredValue("false");
                        }
                        if (attributeMetaData.getDeferredMethod() != null) {
                            tagAttributeInfo.setDeferredMethod("true");
                            tagAttributeInfo.setMethodSignature(attributeMetaData.getDeferredMethod().getMethodSignature());
                        } else {
                            tagAttributeInfo.setDeferredMethod("false");
                        }
                        tagInfo.addTagAttributeInfo(tagAttributeInfo);
                    }
                }
                tagLibraryInfo.addTagInfo(tagInfo);
            }
        }
        if (tldMetaData.getTagFiles() != null) {
            for (TagFileMetaData tagFileMetaData : tldMetaData.getTagFiles()) {
                TagFileInfo tagFileInfo = new TagFileInfo();
                tagFileInfo.setName(tagFileMetaData.getName());
                tagFileInfo.setPath(tagFileMetaData.getPath());
                tagLibraryInfo.addTagFileInfo(tagFileInfo);
            }
        }
        if (tldMetaData.getFunctions() != null) {
            for (FunctionMetaData functionMetaData : tldMetaData.getFunctions()) {
                FunctionInfo functionInfo = new FunctionInfo();
                functionInfo.setName(functionMetaData.getName());
                functionInfo.setFunctionClass(functionMetaData.getFunctionClass());
                functionInfo.setFunctionSignature(functionMetaData.getFunctionSignature());
                tagLibraryInfo.addFunctionInfo(functionInfo);
            }
        }
        if (jarPath == null && relativeLocation == null) {
            if (!ret.containsKey(tagLibraryInfo.getUri())) {
                ret.put(tagLibraryInfo.getUri(), tagLibraryInfo);
            }
        } else if (jarPath == null) {
            tagLibraryInfo.setLocation("");
            tagLibraryInfo.setPath(relativeLocation);
            if (!ret.containsKey(tagLibraryInfo.getUri())) {
                ret.put(tagLibraryInfo.getUri(), tagLibraryInfo);
            }
            ret.put(relativeLocation, tagLibraryInfo);
        } else {
            tagLibraryInfo.setLocation(relativeLocation);
            tagLibraryInfo.setPath(jarPath);
            if (!ret.containsKey(tagLibraryInfo.getUri())) {
                ret.put(tagLibraryInfo.getUri(), tagLibraryInfo);
            }
            if (jarPath.equals("META-INF/taglib.tld")) {
                ret.put(relativeLocation, tagLibraryInfo);
            }
        }
        return tagLibraryInfo;
    }

    private static void addListener(DeploymentClassIndex classReflectionIndex, ComponentRegistry components, DeploymentInfo d, ListenerMetaData listener) throws ClassNotFoundException {
        ListenerInfo l;
        Class listenerClass = classReflectionIndex.classIndex(listener.getListenerClass()).getModuleClass();
        ComponentRegistry.ComponentManagedReferenceFactory creator = (ComponentRegistry.ComponentManagedReferenceFactory)components.getComponentsByClass().get(listenerClass);
        if (creator != null) {
            InstanceFactory factory = UndertowDeploymentInfoService.createInstanceFactory(creator);
            l = new ListenerInfo(listenerClass, factory);
        } else {
            l = new ListenerInfo(listenerClass);
        }
        d.addListener(l);
    }

    private static <T> InstanceFactory<T> createInstanceFactory(final ComponentRegistry.ComponentManagedReferenceFactory creator) {
        return new InstanceFactory<T>(){

            public InstanceHandle<T> createInstance() throws InstantiationException {
                final ManagedReference instance = creator.getReference();
                return new InstanceHandle<T>(){

                    public T getInstance() {
                        return instance.getInstance();
                    }

                    public void release() {
                        instance.release();
                    }
                };
            }
        };
    }

    public InjectedValue<ServletContainerService> getContainer() {
        return this.container;
    }

    public InjectedValue<SecurityDomainContext> getSecurityDomainContextValue() {
        return this.securityDomainContextValue;
    }

    public InjectedValue<DistributedCacheManagerFactory> getDistributedCacheManagerFactoryInjectedValue() {
        return this.distributedCacheManagerFactoryInjectedValue;
    }

    public InjectedValue<UndertowService> getUndertowService() {
        return this.undertowService;
    }

    public InjectedValue<DirectBufferCache> getBufferCacheInjectedValue() {
        return this.bufferCacheInjectedValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class ImmediateSessionManagerFactory
    implements SessionManagerFactory {
        private final SessionManager sessionManager;

        private ImmediateSessionManagerFactory(SessionManager sessionManager) {
            this.sessionManager = sessionManager;
        }

        public SessionManager createSessionManager(Deployment deployment) {
            return this.sessionManager;
        }
    }

    public static class Builder {
        private JBossWebMetaData mergedMetaData;
        private String deploymentName;
        private TldsMetaData tldsMetaData;
        private List<TldMetaData> sharedTlds;
        private Module module;
        private DeploymentClassIndex classReflectionIndex;
        private WebInjectionContainer injectionContainer;
        private ComponentRegistry componentRegistry;
        private ScisMetaData scisMetaData;
        private VirtualFile deploymentRoot;
        private String securityContextId;
        private List<ServletContextAttribute> attributes;
        private String contextPath;
        private String securityDomain;
        private List<SetupAction> setupActions;

        Builder setMergedMetaData(JBossWebMetaData mergedMetaData) {
            this.mergedMetaData = mergedMetaData;
            return this;
        }

        public Builder setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public Builder setTldsMetaData(TldsMetaData tldsMetaData) {
            this.tldsMetaData = tldsMetaData;
            return this;
        }

        public Builder setSharedTlds(List<TldMetaData> sharedTlds) {
            this.sharedTlds = sharedTlds;
            return this;
        }

        public Builder setModule(Module module) {
            this.module = module;
            return this;
        }

        public Builder setClassReflectionIndex(DeploymentClassIndex classReflectionIndex) {
            this.classReflectionIndex = classReflectionIndex;
            return this;
        }

        public Builder setInjectionContainer(WebInjectionContainer injectionContainer) {
            this.injectionContainer = injectionContainer;
            return this;
        }

        public Builder setComponentRegistry(ComponentRegistry componentRegistry) {
            this.componentRegistry = componentRegistry;
            return this;
        }

        public Builder setScisMetaData(ScisMetaData scisMetaData) {
            this.scisMetaData = scisMetaData;
            return this;
        }

        public Builder setDeploymentRoot(VirtualFile deploymentRoot) {
            this.deploymentRoot = deploymentRoot;
            return this;
        }

        public Builder setSecurityContextId(String securityContextId) {
            this.securityContextId = securityContextId;
            return this;
        }

        public Builder setAttributes(List<ServletContextAttribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder setSetupActions(List<SetupAction> setupActions) {
            this.setupActions = setupActions;
            return this;
        }

        public UndertowDeploymentInfoService createUndertowDeploymentInfoService() {
            return new UndertowDeploymentInfoService(this.mergedMetaData, this.deploymentName, this.tldsMetaData, this.sharedTlds, this.module, this.classReflectionIndex, this.injectionContainer, this.componentRegistry, this.scisMetaData, this.deploymentRoot, this.securityContextId, this.securityDomain, this.attributes, this.contextPath, this.setupActions);
        }

        public Builder setSecurityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }
    }

    private static class ManagedReferenceInstanceFactory<T>
    implements InstanceFactory<T> {
        private final ComponentRegistry.ComponentManagedReferenceFactory component;

        public ManagedReferenceInstanceFactory(ComponentRegistry.ComponentManagedReferenceFactory component) {
            this.component = component;
        }

        public InstanceHandle<T> createInstance() throws InstantiationException {
            final ManagedReference reference = this.component.getReference();
            return new InstanceHandle<T>(){

                public T getInstance() {
                    return reference.getInstance();
                }

                public void release() {
                    reference.release();
                }
            };
        }
    }

    private static class ComponentClassIntrospector
    implements ClassIntrospecter {
        private final ComponentRegistry componentRegistry;

        public ComponentClassIntrospector(ComponentRegistry componentRegistry) {
            this.componentRegistry = componentRegistry;
        }

        public <T> InstanceFactory<T> createInstanceFactory(Class<T> clazz) throws NoSuchMethodException {
            ComponentRegistry.ComponentManagedReferenceFactory component = (ComponentRegistry.ComponentManagedReferenceFactory)this.componentRegistry.getComponentsByClass().get(clazz);
            if (component == null) {
                return new ConstructorInstanceFactory(clazz.getDeclaredConstructor(new Class[0]));
            }
            return new ManagedReferenceInstanceFactory(component);
        }
    }
}

