/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.server.session.Session;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.wildfly.extension.undertow.session.ReplicationStatistics;
import org.wildfly.extension.undertow.session.SessionManager;

public abstract class AbstractSessionManager
implements SessionManager {
    protected volatile int maxActiveAllowed = -1;
    protected volatile boolean started = false;
    private final ReplicationStatistics stats = new ReplicationStatistics();
    protected final AtomicInteger createdCounter = new AtomicInteger();
    protected final AtomicInteger rejectedCounter = new AtomicInteger();
    protected final AtomicInteger localActiveCounter = new AtomicInteger();
    protected final AtomicInteger maxLocalActiveCounter = new AtomicInteger();
    protected final AtomicInteger maxActiveCounter = new AtomicInteger();
    protected final AtomicInteger expiredCounter = new AtomicInteger();
    protected long timeSinceLastReset = 0L;
    protected final AtomicLong processingTime = new AtomicLong();
    protected final AtomicInteger maxAliveTime = new AtomicInteger();
    protected final AtomicInteger averageAliveTime = new AtomicInteger();
    protected final AtomicInteger duplicates = new AtomicInteger();
    protected volatile int maxInactiveTime = 1800;
    protected volatile int maxActive = 0;
    protected final Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();

    protected AbstractSessionManager(JBossWebMetaData metaData) {
        SessionConfigMetaData config;
        Integer maxActiveSessions = metaData.getMaxActiveSessions();
        if (maxActiveSessions != null) {
            this.setMaxActiveAllowed(maxActiveSessions);
        }
        if ((config = metaData.getSessionConfig()) != null) {
            this.maxInactiveTime = config.getSessionTimeout() * 60;
        }
    }

    public synchronized void start() {
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            this.resetStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExpires() {
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            if (this.started) {
                long start = System.currentTimeMillis();
                this.processExpirationPassivation();
                this.processingTime.addAndGet(System.currentTimeMillis() - start);
            }
        }
    }

    protected abstract void processExpirationPassivation();

    public int getRejectedSessions() {
        return this.rejectedCounter.get();
    }

    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedCounter.set(rejectedSessions);
    }

    public ReplicationStatistics getReplicationStatistics() {
        return this.stats;
    }

    public void resetStats() {
        this.stats.resetStats();
        this.maxActiveCounter.set(this.localActiveCounter.get());
        this.rejectedCounter.set(0);
        this.createdCounter.set(0);
        this.expiredCounter.set(0);
        this.processingTime.set(0L);
        this.maxAliveTime.set(0);
        this.averageAliveTime.set(0);
        this.duplicates.set(0);
        this.timeSinceLastReset = System.currentTimeMillis();
    }

    public long getTimeSinceLastReset() {
        return this.timeSinceLastReset;
    }

    public long getActiveSessionCount() {
        return this.calcActiveSessions();
    }

    public long getLocalActiveSessionCount() {
        return this.localActiveCounter.get();
    }

    public long getRejectedSessionCount() {
        return this.rejectedCounter.get();
    }

    public long getCreatedSessionCount() {
        return this.createdCounter.get();
    }

    public long getExpiredSessionCount() {
        return this.expiredCounter.get();
    }

    public long getMaxActiveSessionCount() {
        return this.maxActiveCounter.get();
    }

    public long getMaxLocalActiveSessionCount() {
        return this.maxLocalActiveCounter.get();
    }

    public int getMaxActiveAllowed() {
        return this.maxActiveAllowed;
    }

    public void setMaxActiveAllowed(int max) {
        this.maxActiveAllowed = max;
    }

    public int getMaxActiveSessions() {
        return this.maxActive;
    }

    @Override
    public Map.Entry<String, String> parse(String sessionId) {
        String realId = sessionId;
        String jvmRoute = null;
        int index = sessionId.indexOf(46, 0);
        if (index > 0) {
            realId = sessionId.substring(0, index);
            if (index < sessionId.length() - 1) {
                jvmRoute = sessionId.substring(index + 1);
            }
        }
        return new AbstractMap.SimpleImmutableEntry<String, Object>(realId, jvmRoute);
    }

    @Override
    public String createSessionId(String realId, String jvmRoute) {
        return jvmRoute != null ? realId + "." + jvmRoute : realId;
    }

    protected void sessionExpired(int sessionAliveTime) {
        int expCount;
        int newAverage;
        int current = this.maxAliveTime.get();
        while (sessionAliveTime > current && !this.maxAliveTime.compareAndSet(current, sessionAliveTime)) {
            current = this.maxAliveTime.get();
        }
        this.expiredCounter.incrementAndGet();
        do {
            expCount = this.expiredCounter.get();
        } while (!this.averageAliveTime.compareAndSet(current = this.averageAliveTime.get(), newAverage = (current * (expCount - 1) + sessionAliveTime) / expCount));
    }

    protected int calcActiveSessions() {
        this.localActiveCounter.set(this.sessions.size());
        int active = this.localActiveCounter.get();
        int maxLocal = this.maxLocalActiveCounter.get();
        while (active > maxLocal) {
            if (this.maxLocalActiveCounter.compareAndSet(maxLocal, active)) continue;
            maxLocal = this.maxLocalActiveCounter.get();
        }
        int count = this.getTotalActiveSessions();
        int max = this.maxActiveCounter.get();
        while (count > max) {
            if (this.maxActiveCounter.compareAndSet(max, count)) continue;
            max = this.maxActiveCounter.get();
            count = this.getTotalActiveSessions();
        }
        return count;
    }

    protected abstract int getTotalActiveSessions();
}

