/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpSessionActivationListener;
import org.jboss.as.clustering.web.DistributableSessionMetadata;
import org.jboss.as.clustering.web.DistributedCacheManager;
import org.jboss.as.clustering.web.IncomingDistributableSessionData;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.as.clustering.web.SessionOwnershipSupport;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.ReplicationTrigger;
import org.wildfly.extension.undertow.UndertowMessages;
import org.wildfly.extension.undertow.session.ClusteredSessionManager;
import org.wildfly.extension.undertow.session.DistributableSessionManager;
import org.wildfly.extension.undertow.session.SessionManager;
import org.wildfly.extension.undertow.session.notification.ClusteredSessionManagementStatus;
import org.wildfly.extension.undertow.session.notification.ClusteredSessionNotificationCause;
import org.wildfly.extension.undertow.session.notification.ClusteredSessionNotificationPolicy;

public abstract class ClusteredSession<O extends OutgoingDistributableSessionData>
implements Session {
    private static final boolean ACTIVITY_CHECK = false;
    protected static final String[] excludedAttributes = new String[0];
    protected static final Set<String> replicationExcludes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(excludedAttributes)));
    protected static final Logger log = Logger.getLogger(ClusteredSession.class);
    private static final long FULL_REPLICATION_WINDOW_LENGTH = 5000L;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>(16, 0.75f, 2);
    private volatile transient String authType = null;
    private volatile long creationTime = 0L;
    private volatile transient boolean expiring = false;
    private volatile String id = null;
    private volatile long lastAccessedTime = this.creationTime;
    private volatile transient DistributableSessionManager<O> manager = null;
    private volatile transient DistributedCacheManager<O> distributedCacheManager;
    private volatile int maxInactiveInterval = -1;
    private volatile boolean isNew = false;
    private volatile boolean isValid = false;
    private final transient Map<String, Object> notes = new Hashtable<String, Object>();
    private volatile transient Principal principal = null;
    private final transient PropertyChangeSupport support = new PropertyChangeSupport(this);
    private volatile long thisAccessedTime = this.creationTime;
    private final transient AtomicInteger accessCount = null;
    private volatile ReplicationTrigger invalidationPolicy;
    private volatile transient boolean sessionMetadataDirty;
    private volatile transient boolean sessionAttributesDirty;
    private final transient AtomicLong timestamp = new AtomicLong(0L);
    private volatile transient DistributableSessionMetadata metadata = new DistributableSessionMetadata();
    private volatile transient long outdatedTime;
    private final AtomicInteger version = new AtomicInteger(0);
    private volatile transient String realId;
    private volatile transient long lastReplicated;
    private volatile transient long maxUnreplicatedInterval;
    private volatile transient boolean alwaysReplicateTimestamp = true;
    private volatile transient Boolean hasActivationListener;
    private volatile transient boolean firstAccess = true;
    private volatile transient ClusteredSessionNotificationPolicy notificationPolicy;
    private volatile transient ClusteredSessionManagementStatus clusterStatus;
    private volatile transient boolean needsPostReplicateActivation;
    private volatile transient boolean fullReplicationRequired = true;
    private volatile transient long fullReplicationWindow = -1L;
    private final transient Lock ownershipLock = new ReentrantLock();

    protected ClusteredSession(DistributableSessionManager<O> manager) {
        this.setManager(manager);
        this.requireFullReplication();
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        String oldAuthType = this.authType;
        this.authType = authType;
        this.support.firePropertyChange("authType", oldAuthType, this.authType);
    }

    public long getCreationTime() {
        if (!this.isValidInternal()) {
            throw UndertowMessages.MESSAGES.expiredSession();
        }
        return this.creationTime;
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
        this.lastAccessedTime = time;
        this.thisAccessedTime = time;
        this.sessionMetadataDirty();
    }

    public String getId() {
        return this.id;
    }

    public String getIdInternal() {
        return this.id;
    }

    public void setId(String id) {
        this.parseRealId(id);
        if (this.id != null && this.manager != null) {
            this.manager.remove(this);
        }
        this.id = id;
        this.clusterStatus = new ClusteredSessionManagementStatus(this.realId, true, null, null);
        if (this.manager != null) {
            this.manager.add(this);
        }
    }

    public long getLastAccessedTime() {
        if (!this.isValidInternal()) {
            throw UndertowMessages.MESSAGES.expiredSession();
        }
        return this.lastAccessedTime;
    }

    public long getLastAccessedTimeInternal() {
        return this.lastAccessedTime;
    }

    public SessionManager getManager() {
        return this.manager;
    }

    public void setManager(DistributableSessionManager manager) {
        DistributableSessionManager unchecked;
        this.manager = unchecked = manager;
        this.invalidationPolicy = this.manager.getReplicationTrigger();
        int maxUnrep = this.manager.getMaxUnreplicatedInterval() * 1000;
        this.setMaxUnreplicatedInterval(maxUnrep);
        this.notificationPolicy = this.manager.getNotificationPolicy();
        this.establishDistributedCacheManager();
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
        this.checkAlwaysReplicateTimestamp();
        this.sessionMetadataDirty();
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        throw new RuntimeException("NYI");
    }

    public io.undertow.server.session.SessionManager getSessionManager() {
        return this.manager;
    }

    public void setPrincipal(Principal principal) {
        Principal oldPrincipal = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", oldPrincipal, this.principal);
        if (oldPrincipal != null && !oldPrincipal.equals(principal) || oldPrincipal == null && principal != null) {
            this.sessionMetadataDirty();
        }
    }

    public void access() {
        try {
            this.acquireSessionOwnership();
        }
        catch (TimeoutException e) {
            try {
                this.acquireSessionOwnership();
            }
            catch (TimeoutException te) {
                throw UndertowMessages.MESSAGES.failAcquiringOwnership(this.realId, te);
            }
        }
        this.lastAccessedTime = this.thisAccessedTime;
        this.thisAccessedTime = System.currentTimeMillis();
        if (!this.firstAccess && this.isNew) {
            this.setNew(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireSessionOwnership() throws TimeoutException {
        SessionOwnershipSupport support = this.distributedCacheManager.getSessionOwnershipSupport();
        if (support != null) {
            try {
                this.ownershipLock.lockInterruptibly();
                try {
                    IncomingDistributableSessionData data;
                    if (support.acquireSessionOwnership(this.realId, this.needNewLock()) == SessionOwnershipSupport.LockResult.ACQUIRED_FROM_CLUSTER && (data = this.distributedCacheManager.getSessionData(this.realId, false)) != null) {
                        this.update(data);
                    }
                }
                finally {
                    this.ownershipLock.unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw UndertowMessages.MESSAGES.interruptedAcquiringOwnership(this.realId, e);
            }
        }
    }

    private boolean needNewLock() {
        return this.firstAccess && this.isNew;
    }

    public void requestDone(HttpServerExchange exchange) {
        this.isNew = false;
        this.lastAccessedTime = this.thisAccessedTime;
        if (this.firstAccess) {
            this.firstAccess = false;
            this.isNew = true;
        }
        this.relinquishSessionOwnership(false);
    }

    private void relinquishSessionOwnership(boolean remove) {
        SessionOwnershipSupport support = this.distributedCacheManager.getSessionOwnershipSupport();
        if (support != null) {
            support.relinquishSessionOwnership(this.realId, remove);
        }
    }

    public boolean isNew() {
        if (!this.isValidInternal()) {
            throw UndertowMessages.MESSAGES.expiredSession();
        }
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isValid() {
        return this.isValid(true);
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
        this.sessionMetadataDirty();
    }

    public void invalidate(HttpServerExchange exchange) {
        if (!this.isValid()) {
            throw UndertowMessages.MESSAGES.expiredSession();
        }
        boolean notify = true;
        boolean localCall = true;
        boolean localOnly = false;
        this.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.INVALIDATE, exchange);
        this.relinquishSessionOwnership(false);
    }

    public Object getNote(String name) {
        return this.notes.get(name);
    }

    public Iterator<String> getNoteNames() {
        return this.notes.keySet().iterator();
    }

    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    public void removeNote(String name) {
        this.notes.remove(name);
    }

    public Object getAttribute(String name) {
        if (!this.isValid()) {
            throw UndertowMessages.MESSAGES.expiredSession();
        }
        return this.getAttributeInternal(name);
    }

    public Set<String> getAttributeNames() {
        if (!this.isValid()) {
            throw UndertowMessages.MESSAGES.expiredSession();
        }
        return this.getAttributesInternal().keySet();
    }

    public Object setAttribute(String name, Object value) {
        Object old;
        if (name == null) {
            throw UndertowMessages.MESSAGES.expiredSession();
        }
        if (value == null) {
            return this.removeAttribute(name);
        }
        if (!this.isValidInternal()) {
            throw UndertowMessages.MESSAGES.expiredSession();
        }
        if (!this.canAttributeBeReplicated(value)) {
            throw UndertowMessages.MESSAGES.failToReplicateAttribute(name, value.getClass().getCanonicalName());
        }
        if (value instanceof HttpSessionActivationListener) {
            this.hasActivationListener = Boolean.TRUE;
        }
        if ((old = this.setAttributeInternal(name, value)) == null) {
            this.manager.getSessionListeners().attributeAdded((Session)this, name, value);
        } else {
            this.manager.getSessionListeners().attributeUpdated((Session)this, name, value, old);
        }
        return old;
    }

    public Object removeAttribute(String name) {
        if (!this.isValidInternal()) {
            throw UndertowMessages.MESSAGES.expiredSession();
        }
        boolean localCall = true;
        boolean localOnly = false;
        boolean notify = true;
        Object old = this.removeAttributeInternal(name, true, false, true, ClusteredSessionNotificationCause.MODIFY);
        if (old != null) {
            this.manager.getSessionListeners().attributeRemoved((Session)this, name, old);
        }
        return old;
    }

    public String getRealId() {
        return this.realId;
    }

    public boolean getMustReplicateTimestamp() {
        boolean exceeds;
        boolean touched = this.thisAccessedTime != this.lastAccessedTime;
        boolean bl = exceeds = this.alwaysReplicateTimestamp && touched;
        if (!exceeds && touched && this.maxUnreplicatedInterval > 0L) {
            long unrepl = System.currentTimeMillis() - this.lastReplicated;
            exceeds = unrepl >= this.maxUnreplicatedInterval;
        }
        return exceeds;
    }

    public void update(IncomingDistributableSessionData sessionData) {
        long ts;
        assert (sessionData != null) : UndertowMessages.MESSAGES.nullParamter("sessionData");
        this.version.set(sessionData.getVersion());
        this.lastAccessedTime = this.thisAccessedTime = (ts = sessionData.getTimestamp());
        this.timestamp.set(ts);
        DistributableSessionMetadata md = sessionData.getMetadata();
        this.id = md.getId();
        this.creationTime = md.getCreationTime();
        this.maxInactiveInterval = md.getMaxInactiveInterval();
        this.isNew = md.isNew();
        this.isValid = md.isValid();
        this.metadata = md;
        this.parseRealId(this.id);
        this.hasActivationListener = null;
        this.firstAccess = false;
        this.lastReplicated = this.creationTime;
        this.clusterStatus = new ClusteredSessionManagementStatus(this.realId, true, null, null);
        this.checkAlwaysReplicateTimestamp();
        this.populateAttributes(sessionData.getSessionAttributes());
        this.outdatedTime = 0L;
        this.requireFullReplication();
    }

    public synchronized void processSessionReplication() {
        if (log.isTraceEnabled()) {
            log.tracef("processSessionReplication(): session is dirty. Will increment version from: %s and replicate.", (Object)this.getVersion());
        }
        this.version.incrementAndGet();
        O outgoingData = this.getOutgoingSessionData();
        this.distributedCacheManager.storeSessionData(outgoingData);
        this.sessionAttributesDirty = false;
        this.sessionMetadataDirty = false;
        this.lastReplicated = System.currentTimeMillis();
        this.fullReplicationRequired = false;
        if (this.fullReplicationWindow > 0L && System.currentTimeMillis() > this.fullReplicationWindow) {
            this.fullReplicationWindow = -1L;
        }
    }

    public void removeMyself() {
        this.getDistributedCacheManager().removeSession(this.getRealId());
    }

    public void removeMyselfLocal() {
        this.getDistributedCacheManager().removeSessionLocal(this.getRealId());
    }

    public long getCreationTimeInternal() {
        return this.creationTime;
    }

    public long getLastReplicated() {
        return this.lastReplicated;
    }

    public long getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval;
    }

    public void setMaxUnreplicatedInterval(long interval) {
        this.maxUnreplicatedInterval = Math.max(interval, -1L);
        this.checkAlwaysReplicateTimestamp();
    }

    public void resetIdWithRouteInfo(String id) {
        this.id = id;
        this.parseRealId(id);
    }

    public boolean setVersionFromDistributedCache(int version) {
        boolean outdated;
        boolean bl = outdated = this.getVersion() < version;
        if (outdated) {
            this.outdatedTime = System.currentTimeMillis();
        }
        return outdated;
    }

    public boolean isOutdated() {
        return this.thisAccessedTime < this.outdatedTime || this.creationTime == 0L;
    }

    public boolean isSessionDirty() {
        return this.sessionAttributesDirty || this.sessionMetadataDirty;
    }

    public void tellNew(ClusteredSessionNotificationCause cause, HttpServerExchange exchange) {
        if (cause == ClusteredSessionNotificationCause.CREATE) {
            this.manager.getSessionListeners().sessionCreated((Session)this, exchange);
        }
    }

    public boolean isValid(boolean expireIfInvalid) {
        long timeNow;
        int timeIdle;
        if (this.expiring) {
            return true;
        }
        if (!this.isValid) {
            return false;
        }
        if (this.maxInactiveInterval > 0 && (timeIdle = (int)(((timeNow = System.currentTimeMillis()) - this.thisAccessedTime) / 1000L)) >= this.maxInactiveInterval) {
            if (expireIfInvalid) {
                boolean notify = true;
                boolean localCall = true;
                boolean localOnly = true;
                this.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.TIMEOUT, null);
            } else {
                return false;
            }
        }
        return this.isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(boolean notify, boolean localCall, boolean localOnly, ClusteredSessionNotificationCause cause, HttpServerExchange exchange) {
        if (log.isTraceEnabled()) {
            log.tracef("The session has expired with id: %s  -- is expiration local? %s", (Object)this.id, (Object)localOnly);
        }
        if (this.expiring) {
            return;
        }
        ClusteredSession clusteredSession = this;
        synchronized (clusteredSession) {
            boolean requireOwnershipLock;
            if (!this.isValid) {
                return;
            }
            if (this.manager == null) {
                return;
            }
            this.expiring = true;
            RuntimeException listenerException = null;
            boolean bl = requireOwnershipLock = localCall && !localOnly;
            if (requireOwnershipLock) {
                try {
                    this.acquireSessionOwnership();
                }
                catch (TimeoutException e) {
                    this.expiring = false;
                    throw UndertowMessages.MESSAGES.failAcquiringOwnership(this.realId, e);
                }
            }
            try {
                if (notify) {
                    this.manager.getSessionListeners().sessionDestroyed((Session)this, exchange, this.translateReason(cause));
                }
                String[] keys = this.keys();
                for (int i = 0; i < keys.length; ++i) {
                    try {
                        this.removeAttributeInternal(keys[i], localCall, localOnly, notify, cause);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (listenerException != null) continue;
                        listenerException = e;
                    }
                }
                if (localCall) {
                    this.removeFromManager(localOnly);
                }
                if (listenerException != null) {
                    throw listenerException;
                }
            }
            finally {
                this.setValid(false);
                this.expiring = false;
                if (requireOwnershipLock) {
                    this.relinquishSessionOwnership(true);
                }
            }
        }
    }

    protected SessionListener.SessionDestroyedReason translateReason(ClusteredSessionNotificationCause cause) {
        switch (cause) {
            case TIMEOUT: {
                return SessionListener.SessionDestroyedReason.TIMEOUT;
            }
            case INVALIDATE: {
                return SessionListener.SessionDestroyedReason.INVALIDATED;
            }
        }
        return SessionListener.SessionDestroyedReason.UNDEPLOY;
    }

    public void notifyWillPassivate(ClusteredSessionNotificationCause cause) {
    }

    public void notifyDidActivate(ClusteredSessionNotificationCause cause) {
        if (cause == ClusteredSessionNotificationCause.ACTIVATION) {
            this.needsPostReplicateActivation = true;
        }
    }

    public boolean getNeedsPostReplicateActivation() {
        return this.needsPostReplicateActivation;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "id: " + this.id + " lastAccessedTime: " + this.lastAccessedTime + " version: " + this.version + " lastOutdated: " + this.outdatedTime + ']';
    }

    protected abstract Object setAttributeInternal(String var1, Object var2);

    protected abstract Object removeAttributeInternal(String var1, boolean var2, boolean var3);

    protected abstract O getOutgoingSessionData();

    protected Object getAttributeInternal(String name) {
        Object result = this.getAttributesInternal().get(name);
        if (this.isGetDirty(result)) {
            this.sessionAttributesDirty();
        }
        return result;
    }

    protected void populateAttributes(Map<String, Object> distributedCacheAttributes) {
        Map<String, Object> existing = this.getAttributesInternal();
        Map<String, Object> excluded = this.removeExcludedAttributes(existing);
        existing.clear();
        existing.putAll(distributedCacheAttributes);
        if (excluded != null) {
            existing.putAll(excluded);
        }
    }

    protected final Map<String, Object> getAttributesInternal() {
        return this.attributes;
    }

    protected final ClusteredSessionManager<O> getManagerInternal() {
        return this.manager;
    }

    protected final DistributedCacheManager<O> getDistributedCacheManager() {
        return this.distributedCacheManager;
    }

    protected final void setDistributedCacheManager(DistributedCacheManager<O> distributedCacheManager) {
        this.distributedCacheManager = distributedCacheManager;
    }

    protected boolean canAttributeBeReplicated(Object attribute) {
        if (attribute instanceof Serializable || attribute == null) {
            return true;
        }
        Class<?> clazz = attribute.getClass().getComponentType();
        return clazz != null && clazz.isPrimitive();
    }

    protected final Map<String, Object> removeExcludedAttributes(Map<String, Object> attributes) {
        ConcurrentHashMap<String, Object> excluded = null;
        for (int i = 0; i < excludedAttributes.length; ++i) {
            Object attr = attributes.remove(excludedAttributes[i]);
            if (attr == null) continue;
            if (log.isTraceEnabled()) {
                log.tracef("Excluding attribute %s from replication", (Object)excludedAttributes[i]);
            }
            if (excluded == null) {
                excluded = new ConcurrentHashMap<String, Object>();
            }
            excluded.put(excludedAttributes[i], attr);
        }
        return excluded;
    }

    protected final boolean isGetDirty(Object attribute) {
        boolean result = false;
        switch (this.invalidationPolicy) {
            case SET_AND_GET: {
                result = true;
                break;
            }
            case SET_AND_NON_PRIMITIVE_GET: {
                result = this.isMutable(attribute);
                break;
            }
        }
        return result;
    }

    protected boolean isMutable(Object attribute) {
        return attribute != null && !(attribute instanceof String) && !(attribute instanceof Number) && !(attribute instanceof Character) && !(attribute instanceof Boolean);
    }

    protected void establishDistributedCacheManager() {
        if (this.distributedCacheManager == null) {
            this.distributedCacheManager = this.getManagerInternal().getDistributedCacheManager();
            if (this.distributedCacheManager == null) {
                throw UndertowMessages.MESSAGES.nullParamter("distributedCacheManager");
            }
        }
    }

    protected final void sessionAttributesDirty() {
        if (!this.sessionAttributesDirty && log.isTraceEnabled()) {
            log.tracef("Marking session attributes dirty %s", (Object)this.id);
        }
        this.sessionAttributesDirty = true;
    }

    protected final void setHasActivationListener(boolean hasListener) {
        this.hasActivationListener = hasListener;
    }

    protected int getVersion() {
        return this.version.get();
    }

    protected long getSessionTimestamp() {
        this.timestamp.set(this.thisAccessedTime);
        return this.timestamp.get();
    }

    protected boolean isSessionMetadataDirty() {
        return this.sessionMetadataDirty;
    }

    protected DistributableSessionMetadata getSessionMetadata() {
        this.metadata.setId(this.id);
        this.metadata.setCreationTime(this.creationTime);
        this.metadata.setMaxInactiveInterval(this.maxInactiveInterval);
        this.metadata.setNew(this.isNew);
        this.metadata.setValid(this.isValid);
        return this.metadata;
    }

    protected boolean isSessionAttributeMapDirty() {
        return this.sessionAttributesDirty || this.isFullReplicationNeeded();
    }

    protected boolean isFullReplicationNeeded() {
        if (this.fullReplicationRequired) {
            return true;
        }
        return this.fullReplicationRequired || this.fullReplicationWindow > 0L && System.currentTimeMillis() < this.fullReplicationWindow;
    }

    private void checkAlwaysReplicateTimestamp() {
        this.alwaysReplicateTimestamp = this.maxUnreplicatedInterval == 0L || this.maxUnreplicatedInterval > 0L && this.maxInactiveInterval >= 0 && this.maxUnreplicatedInterval > (long)(this.maxInactiveInterval * 1000);
    }

    private void parseRealId(String sessionId) {
        String newId = this.manager.parse(sessionId).getKey();
        if (!newId.equals(this.realId)) {
            this.realId = newId;
        }
    }

    private Object removeAttributeInternal(String name, boolean localCall, boolean localOnly, boolean notify, ClusteredSessionNotificationCause cause) {
        Object value = this.removeAttributeInternal(name, localCall, localOnly);
        return value;
    }

    private String[] keys() {
        Set<String> keySet = this.getAttributesInternal().keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public boolean isValidInternal() {
        return this.isValid || this.expiring;
    }

    private void sessionMetadataDirty() {
        if (!this.sessionMetadataDirty && !this.isNew && log.isTraceEnabled()) {
            log.tracef("Marking session metadata dirty %s", (Object)this.id);
        }
        this.sessionMetadataDirty = true;
    }

    private void removeFromManager(boolean localOnly) {
        if (localOnly) {
            this.manager.removeLocal(this);
        } else {
            this.manager.remove(this);
        }
    }

    private void requireFullReplication() {
        this.fullReplicationRequired = true;
        this.fullReplicationWindow = System.currentTimeMillis() + 5000L;
    }
}

