/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.jboss.as.clustering.web.BatchingManager;
import org.jboss.as.clustering.web.ClusteringNotSupportedException;
import org.jboss.as.clustering.web.DistributableSessionMetadata;
import org.jboss.as.clustering.web.DistributedCacheManager;
import org.jboss.as.clustering.web.DistributedCacheManagerFactory;
import org.jboss.as.clustering.web.IncomingDistributableSessionData;
import org.jboss.as.clustering.web.LocalDistributableSessionManager;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.logging.Logger;
import org.jboss.marshalling.ClassResolver;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.PassivationConfig;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.metadata.web.jboss.ReplicationTrigger;
import org.jboss.metadata.web.jboss.SnapshotMode;
import org.wildfly.extension.undertow.UndertowLogger;
import org.wildfly.extension.undertow.UndertowMessages;
import org.wildfly.extension.undertow.session.AbstractSessionManager;
import org.wildfly.extension.undertow.session.AskSessionOutdatedSessionChecker;
import org.wildfly.extension.undertow.session.AttributeBasedClusteredSession;
import org.wildfly.extension.undertow.session.ClusteredSession;
import org.wildfly.extension.undertow.session.ClusteredSessionHandler;
import org.wildfly.extension.undertow.session.ClusteredSessionManager;
import org.wildfly.extension.undertow.session.InstantSnapshotManager;
import org.wildfly.extension.undertow.session.IntervalSnapshotManager;
import org.wildfly.extension.undertow.session.JvmRouteHandler;
import org.wildfly.extension.undertow.session.LockingHandler;
import org.wildfly.extension.undertow.session.OutdatedSessionChecker;
import org.wildfly.extension.undertow.session.OwnedSessionUpdate;
import org.wildfly.extension.undertow.session.ReplicationStatistics;
import org.wildfly.extension.undertow.session.SessionBasedClusteredSession;
import org.wildfly.extension.undertow.session.SessionInvalidationTracker;
import org.wildfly.extension.undertow.session.SessionReplicationContext;
import org.wildfly.extension.undertow.session.SnapshotManager;
import org.wildfly.extension.undertow.session.notification.ClusteredSessionNotificationCapability;
import org.wildfly.extension.undertow.session.notification.ClusteredSessionNotificationCause;
import org.wildfly.extension.undertow.session.notification.ClusteredSessionNotificationPolicy;
import org.wildfly.extension.undertow.session.notification.IgnoreUndeployLegacyClusteredSessionNotificationPolicy;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DistributableSessionManager<O extends OutgoingDistributableSessionData>
extends AbstractSessionManager
implements LocalDistributableSessionManager,
ClusteredSessionManager<O> {
    private static final String info = "DistributableSessionManager/1.0";
    private static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    private final DistributedCacheManager<O> distributedCacheManager;
    private volatile SnapshotManager snapshotManager;
    private final ReplicationConfig replicationConfig;
    private final ClassResolver resolver;
    private final ClusteredSessionNotificationPolicy notificationPolicy;
    private final OutdatedSessionChecker outdatedSessionChecker = new AskSessionOutdatedSessionChecker();
    private final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE, true);
    private final Lock valveLock = new SemaphoreLock(this.semaphore);
    private final AtomicInteger passivatedCount = new AtomicInteger();
    private final AtomicInteger maxPassivatedCount = new AtomicInteger();
    private final boolean passivate;
    private final long passivationMinIdleTime;
    private final long passivationMaxIdleTime;
    private final boolean persistence;
    private volatile int maxUnreplicatedInterval;
    protected static final int maxInactiveInterval = 1800;
    private final Map<String, OwnedSessionUpdate> unloadedSessions = new ConcurrentHashMap<String, OwnedSessionUpdate>();
    private final ConcurrentMap<String, ClusteredSession<O>> embryonicSessions = new ConcurrentHashMap<String, ClusteredSession<O>>();
    private final SessionIdGenerator sessionIdGenerator = new SecureRandomSessionIdGenerator();
    private final String contextPath;
    private final ClassLoader classLoader;
    private final String jvmRoute;
    private final SessionListeners sessionListeners = new SessionListeners();
    private static final Logger log = Logger.getLogger(DistributableSessionManager.class);

    public DistributableSessionManager(DistributedCacheManagerFactory factory, JBossWebMetaData metaData, ClassResolver resolver, String contextPath, ClassLoader classLoader, String jvmRoute) {
        super(metaData);
        Integer interval;
        this.contextPath = contextPath;
        this.classLoader = classLoader;
        this.jvmRoute = jvmRoute;
        PassivationConfig passivationConfig = metaData.getPassivationConfig();
        Boolean useSessionPassivation = passivationConfig != null ? passivationConfig.getUseSessionPassivation() : null;
        this.passivate = useSessionPassivation != null ? useSessionPassivation : false;
        Integer minIdleTime = passivationConfig != null ? passivationConfig.getPassivationMinIdleTime() : null;
        this.passivationMinIdleTime = minIdleTime != null && this.passivate ? (long)minIdleTime.intValue() : -1L;
        Integer maxIdleTime = passivationConfig != null ? passivationConfig.getPassivationMaxIdleTime() : null;
        this.passivationMaxIdleTime = maxIdleTime != null && this.passivate ? (long)maxIdleTime.intValue() : -1L;
        ReplicationConfig config = metaData.getReplicationConfig();
        ReplicationConfig replicationConfig = this.replicationConfig = config != null ? config : new ReplicationConfig();
        if (this.replicationConfig.getReplicationGranularity() == ReplicationGranularity.FIELD) {
            this.replicationConfig.setReplicationGranularity(ReplicationGranularity.SESSION);
        }
        this.maxUnreplicatedInterval = (interval = this.replicationConfig.getMaxUnreplicatedInterval()) != null ? interval : -1;
        this.notificationPolicy = this.createClusteredSessionNotificationPolicy();
        this.resolver = resolver;
        try {
            this.distributedCacheManager = factory.getDistributedCacheManager((LocalDistributableSessionManager)this);
        }
        catch (ClusteringNotSupportedException e) {
            throw new RuntimeException(e);
        }
        this.persistence = this.distributedCacheManager.isPersistenceEnabled();
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        super.start();
        try {
            this.distributedCacheManager.start();
            this.initializeUnloadedSessions();
            this.snapshotManager = this.createSnapshotManager();
            this.snapshotManager.start();
            log.debug((Object)"start(): DistributedCacheManager started");
        }
        catch (Exception e) {
            throw UndertowMessages.MESSAGES.failToStartManager(e);
        }
        if (!this.semaphore.tryAcquire()) {
            log.debug((Object)"Opening up LockingValve");
            this.semaphore.release(Integer.MAX_VALUE);
        } else {
            this.semaphore.release();
        }
    }

    public HttpHandler wrapHandlers(HttpHandler handler) {
        HttpHandler current = handler;
        current = new LockingHandler(this.valveLock, current);
        if (this.getUseJK()) {
            current = new JvmRouteHandler(this, current);
        }
        current = new ClusteredSessionHandler(this, null, current);
        return current;
    }

    protected SnapshotManager createSnapshotManager() {
        String ctxPath = this.contextPath;
        switch (this.getSnapshotMode()) {
            case INTERVAL: {
                int interval = this.getSnapshotInterval();
                if (interval > 0) {
                    return new IntervalSnapshotManager(this, this.classLoader, ctxPath, interval);
                }
                UndertowLogger.WEB_SESSION_LOGGER.invalidSnapshotInterval();
            }
            case INSTANT: {
                return new InstantSnapshotManager(this, ctxPath);
            }
        }
        throw UndertowMessages.MESSAGES.invalidSnapshotMode();
    }

    protected void initializeUnloadedSessions() {
        Map sessions = this.distributedCacheManager.getSessionIds();
        if (sessions != null) {
            String realId;
            boolean passivate = this.isPassivationEnabled();
            long passivationMax = this.passivationMaxIdleTime * 1000L;
            long passivationMin = this.passivationMinIdleTime * 1000L;
            for (Map.Entry entry : sessions.entrySet()) {
                realId = (String)entry.getKey();
                String owner = (String)entry.getValue();
                long ts = -1L;
                DistributableSessionMetadata md = null;
                try {
                    IncomingDistributableSessionData sessionData = this.distributedCacheManager.getSessionData(realId, owner, false);
                    if (sessionData == null) {
                        log.debugf("Metadata unavailable for unloaded session %s", (Object)realId);
                        continue;
                    }
                    ts = sessionData.getTimestamp();
                    md = sessionData.getMetadata();
                }
                catch (Exception e) {
                    log.debug((Object)("Problem reading metadata for session " + realId + " -- " + e.toString()), (Throwable)e);
                }
                long lastMod = ts == -1L ? System.currentTimeMillis() : ts;
                int maxLife = md == null ? 1800 : md.getMaxInactiveInterval();
                OwnedSessionUpdate osu = new OwnedSessionUpdate(owner, lastMod, maxLife, false);
                this.unloadedSessions.put(realId, osu);
            }
            if (passivate) {
                for (Map.Entry<Object, Object> entry : this.unloadedSessions.entrySet()) {
                    realId = (String)entry.getKey();
                    OwnedSessionUpdate osu = (OwnedSessionUpdate)entry.getValue();
                    try {
                        long elapsed = System.currentTimeMillis() - osu.getUpdateTime();
                        if (passivationMax >= 0L && elapsed > passivationMax) {
                            log.tracef("Elapsed time of %d for session %s exceeds max of %d; passivating", (Object)elapsed, (Object)realId, (Object)passivationMax);
                            this.processUnloadedSessionPassivation(realId, osu);
                            continue;
                        }
                        if (this.maxActiveAllowed <= 0 || passivationMin < 0L || this.calcActiveSessions() <= this.maxActiveAllowed || elapsed < passivationMin) continue;
                        log.tracef("Elapsed time of %d for session %s exceeds min of %d; passivating", (Object)elapsed, (Object)realId, (Object)passivationMin);
                        this.processUnloadedSessionPassivation(realId, osu);
                    }
                    catch (Exception e) {
                        log.debugf("Problem passivating session %s -- %s", (Object)realId, (Object)e);
                    }
                }
            }
        }
    }

    private void processUnloadedSessionPassivation(String realId, OwnedSessionUpdate osu) {
        log.tracef("Passivating session with id: %s", (Object)realId);
        this.distributedCacheManager.evictSession(realId, osu.getOwner());
        osu.setPassivated(true);
        this.sessionPassivated();
    }

    private void sessionPassivated() {
        int pc = this.passivatedCount.incrementAndGet();
        int max = this.maxPassivatedCount.get();
        while (pc > max) {
            if (this.maxPassivatedCount.compareAndSet(max, pc)) continue;
            max = this.maxPassivatedCount.get();
        }
    }

    protected ClusteredSessionNotificationPolicy createClusteredSessionNotificationPolicy() {
        String policyClass = this.replicationConfig.getSessionNotificationPolicy();
        if (policyClass == null || policyClass.isEmpty()) {
            policyClass = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.web.clustered.session.notification.policy", (String)IgnoreUndeployLegacyClusteredSessionNotificationPolicy.class.getName());
        }
        try {
            ClusteredSessionNotificationPolicy policy = DistributableSessionManager.loadClass(policyClass, ClusteredSessionNotificationPolicy.class).newInstance();
            policy.setClusteredSessionNotificationCapability(new ClusteredSessionNotificationCapability());
            return policy;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UndertowMessages.MESSAGES.failToCreateSessionNotificationPolicy(ClusteredSessionNotificationPolicy.class.getName(), policyClass, e);
        }
    }

    private static <T> Class<? extends T> loadClass(String className, Class<T> targetClass) throws Exception {
        Exception lastException = new IllegalStateException();
        for (ClassLoader loader : Arrays.asList(Thread.currentThread().getContextClassLoader(), DistributableSessionManager.class.getClassLoader())) {
            if (loader == null) continue;
            try {
                return loader.loadClass(className).asSubclass(targetClass);
            }
            catch (ClassNotFoundException e) {
                lastException = e;
            }
        }
        throw lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        log.debug((Object)"Stopping");
        if (!this.started) {
            return;
        }
        this.started = false;
        DistributableSessionManager distributableSessionManager = this;
        synchronized (distributableSessionManager) {
            log.trace((Object)"Waiting until backgroundProcess() short-circuits.");
        }
        if (this.semaphore.tryAcquire()) {
            try {
                log.debug((Object)"Closing off LockingValve");
                this.semaphore.acquire(0x7FFFFFFE);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.semaphore.release();
                throw new RuntimeException(e);
            }
        }
        this.resetStats();
        this.clearSessions();
        this.distributedCacheManager.stop();
        this.snapshotManager.stop();
        this.snapshotManager = null;
        this.sessions.clear();
        this.unloadedSessions.clear();
        this.passivatedCount.set(0);
        this.sessionListeners.clear();
    }

    private void clearSessions() {
        boolean passivation = this.isPassivationEnabled();
        boolean persistence = this.isPersistenceEnabled();
        for (Session session : this.sessions.values()) {
            ClusteredSession<O> ses = this.cast(session);
            log.tracef("clearSessions(): clear session by expiring or passivating: %s", ses);
            try {
                if (passivation && ses.isValid()) {
                    this.processSessionPassivation(ses.getRealId());
                    continue;
                }
                if (persistence) continue;
                boolean notify = true;
                boolean localCall = true;
                boolean localOnly = true;
                ses.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.UNDEPLOY, null);
            }
            catch (Throwable t) {
                UndertowLogger.WEB_SESSION_LOGGER.errorPassivatingSession(ses.getIdInternal(), t);
            }
        }
        Set<Map.Entry<String, OwnedSessionUpdate>> unloaded = this.unloadedSessions.entrySet();
        Iterator<Map.Entry<String, OwnedSessionUpdate>> it = unloaded.iterator();
        while (it.hasNext()) {
            Map.Entry<String, OwnedSessionUpdate> entry = it.next();
            String realId = entry.getKey();
            try {
                if (passivation) {
                    OwnedSessionUpdate osu = entry.getValue();
                    if (!osu.isPassivated()) {
                        this.distributedCacheManager.evictSession(realId, osu.getOwner());
                    }
                } else {
                    this.distributedCacheManager.removeSessionLocal(realId);
                }
            }
            catch (Exception e) {
                log.debugf("Problem %s session %s -- %s", (Object)(passivation ? "evicting" : "removing"), (Object)realId, (Object)e);
            }
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionPassivation(String realId) {
        ClusteredSession<O> session = this.cast((Session)this.sessions.get(realId));
        if (session != null) {
            ClusteredSession<O> clusteredSession = session;
            synchronized (clusteredSession) {
                log.tracef("Passivating session with id: %s", (Object)realId);
                session.notifyWillPassivate(ClusteredSessionNotificationCause.PASSIVATION);
                this.distributedCacheManager.evictSession(realId);
                this.sessionPassivated();
                OwnedSessionUpdate obj = this.unloadedSessions.put(realId, new OwnedSessionUpdate(null, session.getLastAccessedTimeInternal(), session.getMaxInactiveInterval(), true));
                if (obj == null) {
                    log.tracef("New session %s added to unloaded session map", (Object)realId);
                } else {
                    log.tracef("Updated timestamp for unloaded session %s", (Object)realId);
                }
                this.sessions.remove(realId);
            }
        } else {
            log.tracef("processSessionPassivation():  could not find session %s", (Object)realId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(HttpServerExchange serverExchange, SessionConfig sessionCookieConfig) {
        ClusteredSession<O> session;
        block7: {
            session = null;
            try {
                boolean inLockingValve = SessionReplicationContext.isLocallyActive();
                if (inLockingValve || this.valveLock.tryLock(0L, TimeUnit.SECONDS)) {
                    try {
                        session = this.createSessionInternal(serverExchange, sessionCookieConfig);
                        break block7;
                    }
                    finally {
                        if (!inLockingValve) {
                            this.valveLock.unlock();
                        }
                    }
                }
                log.trace((Object)"createEmptySession(): Manager is not handling requests; returning null");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return session;
    }

    private ClusteredSession<O> createSessionInternal(HttpServerExchange serverExchange, SessionConfig config) {
        ClusteredSession<O> session;
        if (this.maxActiveAllowed != -1 && this.calcActiveSessions() >= this.maxActiveAllowed) {
            log.tracef("createSession(): active sessions = %d and max allowed sessions = %d", (Object)this.calcActiveSessions(), (Object)this.maxActiveAllowed);
            this.processExpires();
            if (this.calcActiveSessions() >= this.maxActiveAllowed) {
                this.rejectedCounter.incrementAndGet();
                throw UndertowMessages.MESSAGES.tooManyActiveSessions(this.maxActiveAllowed);
            }
        }
        if ((session = this.createEmptyClusteredSession()) != null) {
            session.setNew(true);
            session.setCreationTime(System.currentTimeMillis());
            session.setMaxInactiveInterval(1800);
            session.setValid(true);
            String clearInvalidated = null;
            String sessionId = config.findSessionId(serverExchange);
            if (sessionId != null) {
                clearInvalidated = sessionId;
                if (this.sessions.containsKey(sessionId)) {
                    throw io.undertow.UndertowMessages.MESSAGES.sessionAlreadyExists(sessionId);
                }
            } else {
                sessionId = this.generateSessionId();
            }
            config.setSessionId(serverExchange, sessionId);
            session.setId(sessionId);
            this.getDistributedCacheManager().sessionCreated(session.getRealId());
            session.tellNew(ClusteredSessionNotificationCause.CREATE, serverExchange);
            log.tracef("Created a ClusteredSession with id: %s", (Object)sessionId);
            this.createdCounter.incrementAndGet();
            SessionReplicationContext.bindSession(session, this.snapshotManager);
            if (clearInvalidated != null) {
                SessionInvalidationTracker.clearInvalidatedSession(this);
            }
        }
        return session;
    }

    protected String generateSessionId() {
        return this.createSessionId(this.distributedCacheManager.createSessionId(), this.getJvmRoute());
    }

    public Session getSession(HttpServerExchange serverExchange, SessionConfig sessionCookieConfig) {
        String id = sessionCookieConfig.findSessionId(serverExchange);
        if (id == null) {
            return null;
        }
        return this.findSession(id);
    }

    public void registerSessionListener(SessionListener listener) {
        this.sessionListeners.addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.removeSessionListener(listener);
    }

    public void setDefaultSessionTimeout(int timeout) {
    }

    private ClusteredSession<O> findSession(String id) {
        String realId = this.parse(id).getKey();
        ClusteredSession<O> session = this.cast((Session)this.sessions.get(realId));
        if (session == null && !SessionInvalidationTracker.isSessionInvalidated(realId, this)) {
            log.tracef("Checking for session %s in the distributed cache", (Object)realId);
            session = this.loadSession(realId);
        } else if (session != null && this.outdatedSessionChecker.isSessionOutdated(session)) {
            log.tracef("Updating session %s from the distributed cache", (Object)realId);
            session = this.loadSession(realId);
            if (session == null) {
                this.sessions.remove(realId);
            }
        }
        if (session != null) {
            SessionReplicationContext.bindSession(session, this.snapshotManager);
            if (session.getNeedsPostReplicateActivation()) {
                session.notifyDidActivate(ClusteredSessionNotificationCause.REPLICATION);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session s) {
        ClusteredSession<O> session;
        ClusteredSession<O> clusteredSession = session = this.cast(s);
        synchronized (clusteredSession) {
            String realId = session.getRealId();
            if (realId == null) {
                return;
            }
            log.tracef("Removing session from store with id: %s", (Object)realId);
            try {
                session.removeMyself();
            }
            finally {
                SessionReplicationContext.sessionExpired(session, realId, this.snapshotManager);
                SessionInvalidationTracker.sessionInvalidated(realId, this);
                this.sessions.remove(realId);
                this.getReplicationStatistics().removeStats(realId);
                int timeAlive = (int)((System.currentTimeMillis() - session.getCreationTimeInternal()) / 1000L);
                this.sessionExpired(timeAlive);
            }
        }
    }

    private void handleForceSynchronousNotification(String type, String enableType, String disableType) {
        boolean enabled = type.equals(enableType);
        if ((enabled || type.equals(disableType)) && this.distributedCacheManager != null) {
            this.distributedCacheManager.setForceSynchronous(enabled);
        }
    }

    @Override
    public String getJvmRoute() {
        return null;
    }

    @Override
    public String locateJvmRoute(String sessionId) {
        return this.distributedCacheManager.locate(sessionId);
    }

    public String createSessionId() {
        return this.sessionIdGenerator.createSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocal(Session s) {
        ClusteredSession<O> session;
        ClusteredSession<O> clusteredSession = session = this.cast(s);
        synchronized (clusteredSession) {
            String realId = session.getRealId();
            if (realId == null) {
                return;
            }
            log.tracef("Removing session from local store with id: %s", (Object)realId);
            try {
                session.removeMyselfLocal();
            }
            finally {
                SessionReplicationContext.sessionExpired(session, realId, this.snapshotManager);
                SessionInvalidationTracker.sessionInvalidated(realId, this);
                this.sessions.remove(realId);
                this.getReplicationStatistics().removeStats(realId);
                int timeAlive = (int)((System.currentTimeMillis() - session.getCreationTimeInternal()) / 1000L);
                this.sessionExpired(timeAlive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeSession(Session s) {
        boolean stored = false;
        if (s != null) {
            ClusteredSession<O> session;
            ClusteredSession<O> clusteredSession = session = this.cast(s);
            synchronized (clusteredSession) {
                log.tracef("check to see if needs to store and replicate session with id %s ", (Object)session.getIdInternal());
                if (session.isValid() && (session.isSessionDirty() || session.getMustReplicateTimestamp())) {
                    String realId = session.getRealId();
                    long begin = System.currentTimeMillis();
                    session.notifyWillPassivate(ClusteredSessionNotificationCause.REPLICATION);
                    long elapsed = System.currentTimeMillis() - begin;
                    ReplicationStatistics stats = this.getReplicationStatistics();
                    stats.updatePassivationStats(realId, elapsed);
                    begin = System.currentTimeMillis();
                    this.processSessionRepl(session);
                    elapsed = System.currentTimeMillis() - begin;
                    stored = true;
                    stats.updateReplicationStats(realId, elapsed);
                } else {
                    log.tracef("Session %s did not require replication.", (Object)session.getIdInternal());
                }
            }
        }
        return stored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session) {
        block8: {
            if (session == null) {
                return;
            }
            try {
                boolean inLockingValve = SessionReplicationContext.isLocallyActive();
                if (inLockingValve || this.valveLock.tryLock(0L, TimeUnit.SECONDS)) {
                    try {
                        this.add(this.cast(session), false);
                        break block8;
                    }
                    finally {
                        if (!inLockingValve) {
                            this.valveLock.unlock();
                        }
                    }
                }
                log.trace((Object)"add(): ignoring add -- Manager is not actively handling requests");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void add(ClusteredSession<O> session, boolean replicate) {
        if (!session.isValid()) {
            log.debugf("Cannot add session with id=%s because it is invalid", (Object)session.getIdInternal());
            return;
        }
        String realId = session.getRealId();
        ClusteredSession<O> existing = this.sessions.put(realId, session);
        this.unloadedSessions.remove(realId);
        if (!session.equals(existing)) {
            if (replicate) {
                this.storeSession(session);
            }
            this.calcActiveSessions();
            log.tracef("Session with id=%s added. Current active sessions %d", (Object)session.getIdInternal(), (Object)this.localActiveCounter.get());
        }
    }

    public String getCacheConfigName() {
        return this.replicationConfig.getCacheName();
    }

    public ReplicationGranularity getReplicationGranularity() {
        ReplicationGranularity granularity = this.replicationConfig.getReplicationGranularity();
        return granularity != null ? granularity : ReplicationGranularity.SESSION;
    }

    public SnapshotMode getSnapshotMode() {
        SnapshotMode mode = this.replicationConfig.getSnapshotMode();
        return mode != null ? mode : SnapshotMode.INSTANT;
    }

    public int getSnapshotInterval() {
        Integer interval = this.replicationConfig.getSnapshotInterval();
        return interval != null ? interval : -1;
    }

    public void setMaxUnreplicatedInterval(int maxUnreplicatedInterval) {
        this.maxUnreplicatedInterval = maxUnreplicatedInterval;
    }

    public String listLocalSessionIds() {
        ArrayList<String> ids = new ArrayList<String>(this.sessions.size());
        this.addLocal(ids, this.sessions.keySet());
        return this.reportSessionIds(ids);
    }

    private void addLocal(Collection<String> localIds, Collection<String> ids) {
        for (String id : ids) {
            if (!this.distributedCacheManager.isLocal(id)) continue;
            localIds.add(id);
        }
    }

    private String reportSessionIds(Collection<String> sessions) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> ids = sessions.iterator();
        while (ids.hasNext()) {
            builder.append(ids.next());
            if (!ids.hasNext()) continue;
            builder.append(',');
        }
        return builder.toString();
    }

    public long getPassivatedSessionCount() {
        return this.passivatedCount.get();
    }

    public long getMaxPassivatedSessionCount() {
        return this.maxPassivatedCount.get();
    }

    public long getPassivationMaxIdleTime() {
        return this.passivationMaxIdleTime;
    }

    public long getPassivationMinIdleTime() {
        return this.passivationMinIdleTime;
    }

    @Override
    public int getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval;
    }

    @Override
    public ClusteredSessionNotificationPolicy getNotificationPolicy() {
        return this.notificationPolicy;
    }

    @Override
    public ReplicationTrigger getReplicationTrigger() {
        ReplicationTrigger trigger = this.replicationConfig.getReplicationTrigger();
        return trigger != null ? trigger : ReplicationTrigger.SET_AND_NON_PRIMITIVE_GET;
    }

    public boolean getUseJK() {
        Boolean useJK = this.replicationConfig.getUseJK();
        return useJK != null ? useJK : true;
    }

    @Override
    public DistributedCacheManager<O> getDistributedCacheManager() {
        return this.distributedCacheManager;
    }

    public boolean isPassivationEnabled() {
        return this.passivate;
    }

    public boolean isPersistenceEnabled() {
        return this.persistence;
    }

    public ClassResolver getApplicationClassResolver() {
        return this.resolver;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    SessionListeners getSessionListeners() {
        return this.sessionListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemoteInvalidation(String realId) {
        ClusteredSession<O> session = this.cast((Session)this.sessions.remove(realId));
        if (session == null) {
            if (this.unloadedSessions.remove(realId) != null) {
                log.tracef("Removed entry for session %s from unloaded session map", (Object)realId);
            }
            this.getReplicationStatistics().removeStats(realId);
        } else {
            boolean notify = false;
            boolean localCall = false;
            boolean localOnly = true;
            try {
                SessionInvalidationTracker.suspend();
                session.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.INVALIDATE, null);
            }
            finally {
                SessionInvalidationTracker.resume();
                this.getReplicationStatistics().removeStats(realId);
            }
        }
    }

    public void notifyLocalAttributeModification(String realId) {
        ClusteredSession<O> session = this.cast((Session)this.sessions.get(realId));
        if (session != null) {
            session.sessionAttributesDirty();
        } else {
            UndertowLogger.WEB_SESSION_LOGGER.notificationForInactiveSession(realId);
        }
    }

    public void sessionActivated() {
        int pc = this.passivatedCount.decrementAndGet();
        if (pc < 0) {
            this.passivatedCount.incrementAndGet();
        }
    }

    public boolean sessionChangedInDistributedCache(String realId, String dataOwner, int distributedVersion, long timestamp, DistributableSessionMetadata metadata) {
        boolean updated = true;
        ClusteredSession<O> session = this.cast((Session)this.sessions.get(realId));
        if (session != null) {
            updated = session.setVersionFromDistributedCache(distributedVersion);
            if (updated) {
                log.tracef("session in-memory data is invalidated for id: %s new version: %d", (Object)realId, (Object)distributedVersion);
            }
        } else {
            int maxLife = metadata == null ? 1800 : metadata.getMaxInactiveInterval();
            OwnedSessionUpdate existing = this.unloadedSessions.put(realId, new OwnedSessionUpdate(dataOwner, timestamp, maxLife, false));
            if (existing == null) {
                this.calcActiveSessions();
                log.tracef("New session %s added to unloaded session map", (Object)realId);
            } else {
                log.tracef("Updated timestamp for unloaded session %s", (Object)realId);
            }
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processExpirationPassivation() {
        boolean passivate;
        block30: {
            boolean expire = true;
            passivate = this.isPassivationEnabled();
            long passivationMax = this.passivationMaxIdleTime * 1000L;
            long passivationMin = this.passivationMinIdleTime * 1000L;
            log.trace((Object)"processExpirationPassivation(): Looking for sessions that have expired ...");
            log.tracef("processExpirationPassivation(): active sessions = %d", (Object)this.calcActiveSessions());
            log.tracef("processExpirationPassivation(): expired sessions = %d", (Object)this.expiredCounter.get());
            if (passivate) {
                log.tracef("processExpirationPassivation(): passivated count = %d", (Object)this.getPassivatedSessionCount());
            }
            TreeSet<PassivationCheck> passivationChecks = new TreeSet<PassivationCheck>();
            try {
                SessionInvalidationTracker.suspend();
                for (Session s : this.sessions.values()) {
                    if (!this.started) {
                        return;
                    }
                    boolean likelyExpired = false;
                    String realId = null;
                    try {
                        ClusteredSession<O> session = this.cast(s);
                        realId = session.getRealId();
                        likelyExpired = expire;
                        if (expire) {
                            boolean bl = likelyExpired = !session.isValid(false);
                            if (likelyExpired && this.outdatedSessionChecker.isSessionOutdated(session)) {
                                this.loadSession(session.getRealId());
                            }
                            if (!session.isValid()) continue;
                            likelyExpired = false;
                        }
                        if (!passivate) continue;
                        passivationChecks.add(new PassivationCheck(session));
                    }
                    catch (Exception e) {
                        if (likelyExpired) {
                            this.bruteForceCleanup(realId, e);
                            continue;
                        }
                        UndertowLogger.WEB_SESSION_LOGGER.failToPassivateLoad(realId, e);
                    }
                }
                long maxUnrep = this.maxUnreplicatedInterval < 0 ? 60L : (long)this.maxUnreplicatedInterval;
                for (Map.Entry<String, OwnedSessionUpdate> entry : this.unloadedSessions.entrySet()) {
                    if (!this.started) {
                        return;
                    }
                    String realId = entry.getKey();
                    OwnedSessionUpdate osu = entry.getValue();
                    boolean likelyExpired = false;
                    long now = System.currentTimeMillis();
                    long elapsed = now - osu.getUpdateTime();
                    try {
                        boolean bl = likelyExpired = expire && osu.getMaxInactive() >= 1 && elapsed >= ((long)osu.getMaxInactive() + maxUnrep) * 1000L;
                        if (likelyExpired) {
                            ClusteredSession<O> session;
                            if (osu.isPassivated() && (session = this.findSession(realId)) != null) {
                                session.isValid();
                                continue;
                            }
                            this.distributedCacheManager.removeSessionLocal(realId, osu.getOwner());
                            this.unloadedSessions.remove(realId);
                            this.getReplicationStatistics().removeStats(realId);
                            continue;
                        }
                        if (!passivate || osu.isPassivated()) continue;
                        passivationChecks.add(new PassivationCheck(realId, osu));
                    }
                    catch (Exception e) {
                        if (likelyExpired) {
                            this.bruteForceCleanup(realId, e);
                            continue;
                        }
                        UndertowLogger.WEB_SESSION_LOGGER.failToPassivate("unloaded", realId, e);
                    }
                }
                if (!this.started) {
                    return;
                }
                if (!passivate) break block30;
                for (PassivationCheck passivationCheck : passivationChecks) {
                    try {
                        long timeNow = System.currentTimeMillis();
                        long timeIdle = timeNow - passivationCheck.getLastUpdate();
                        if (passivationMax >= 0L && timeIdle > passivationMax) {
                            passivationCheck.passivate();
                            continue;
                        }
                        if (this.maxActiveAllowed > 0 && passivationMin > 0L && this.calcActiveSessions() >= this.maxActiveAllowed && timeIdle > passivationMin) {
                            passivationCheck.passivate();
                        }
                        break;
                    }
                    catch (Exception e) {
                        UndertowLogger.WEB_SESSION_LOGGER.failToPassivate(passivationCheck.isUnloaded() ? "unloaded " : "", passivationCheck.getRealId(), e);
                    }
                }
            }
            catch (Exception ex) {
                UndertowLogger.WEB_SESSION_LOGGER.processExpirationPassivationException(ex);
            }
            finally {
                SessionInvalidationTracker.resume();
            }
        }
        log.trace((Object)"processExpirationPassivation(): Completed ...");
        log.tracef("processExpirationPassivation(): active sessions = %d", (Object)this.calcActiveSessions());
        log.tracef("processExpirationPassivation(): expired sessions = %d", (Object)this.expiredCounter.get());
        if (passivate) {
            log.tracef("processExpirationPassivation(): passivated count = %d", (Object)this.getPassivatedSessionCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClusteredSession<O> loadSession(String realId) {
        if (realId == null) {
            return null;
        }
        try {
            boolean inLockingValve = SessionReplicationContext.isLocallyActive();
            if (!inLockingValve) {
                if (!this.valveLock.tryLock(0L, TimeUnit.SECONDS)) return null;
            }
            try {
                Object osu;
                long begin = System.currentTimeMillis();
                boolean mustAdd = false;
                boolean passivated = false;
                ClusteredSession<O> session = this.cast((Session)this.sessions.get(realId));
                boolean initialLoad = false;
                if (session == null) {
                    initialLoad = true;
                    mustAdd = true;
                    session = this.createEmptyClusteredSession();
                    ClusteredSession<O> embryo = this.embryonicSessions.putIfAbsent(realId, session);
                    if (embryo != null) {
                        session = embryo;
                    }
                    passivated = (osu = this.unloadedSessions.get(realId)) != null && ((OwnedSessionUpdate)osu).isPassivated();
                }
                ClusteredSession<O> clusteredSession = session;
                synchronized (clusteredSession) {
                    if (initialLoad && !session.isOutdated()) {
                        osu = session;
                        return osu;
                    }
                    IncomingDistributableSessionData data = this.distributedCacheManager.getSessionData(realId, initialLoad);
                    if (data != null) {
                        session.update(data);
                    } else {
                        session = null;
                    }
                    if (session != null) {
                        ClusteredSessionNotificationCause cause = passivated ? ClusteredSessionNotificationCause.ACTIVATION : ClusteredSessionNotificationCause.FAILOVER;
                        session.notifyDidActivate(cause);
                    }
                    if (session != null) {
                        if (mustAdd) {
                            this.add(session, false);
                            if (!passivated) {
                                session.tellNew(ClusteredSessionNotificationCause.FAILOVER, null);
                            }
                        }
                        long elapsed = System.currentTimeMillis() - begin;
                        this.getReplicationStatistics().updateLoadStats(realId, elapsed);
                        log.tracef("loadSession(): id=%s, session=%s", (Object)realId, session);
                    } else {
                        log.tracef("loadSession(): session %s not found in distributed cache", (Object)realId);
                    }
                    if (initialLoad) {
                        this.embryonicSessions.remove(realId);
                    }
                }
                clusteredSession = session;
                return clusteredSession;
            }
            finally {
                if (!inLockingValve) {
                    this.valveLock.unlock();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClusteredSession<O> createEmptyClusteredSession() {
        try {
            boolean inLockingValve = SessionReplicationContext.isLocallyActive();
            if (!inLockingValve) {
                if (!this.valveLock.tryLock(0L, TimeUnit.SECONDS)) return null;
            }
            try {
                switch (this.getReplicationGranularity()) {
                    case ATTRIBUTE: {
                        AttributeBasedClusteredSession attributeBasedClusteredSession = new AttributeBasedClusteredSession(this);
                        return attributeBasedClusteredSession;
                    }
                }
                SessionBasedClusteredSession sessionBasedClusteredSession = new SessionBasedClusteredSession(this);
                return sessionBasedClusteredSession;
            }
            finally {
                if (!inLockingValve) {
                    this.valveLock.unlock();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bruteForceCleanup(String realId, Exception ex) {
        UndertowLogger.WEB_SESSION_LOGGER.bruteForceCleanup(realId, ex.getLocalizedMessage());
        try {
            this.distributedCacheManager.removeSessionLocal(realId, null);
        }
        catch (Exception e) {
            UndertowLogger.WEB_SESSION_LOGGER.failToBruteForceCleanup(realId, e);
        }
        finally {
            this.unloadedSessions.remove(realId);
            this.getReplicationStatistics().removeStats(realId);
        }
    }

    @Override
    public Map.Entry<String, String> parse(String sessionId) {
        return this.getUseJK() ? super.parse(sessionId) : new AbstractMap.SimpleImmutableEntry<String, Object>(sessionId, null);
    }

    @Override
    public String createSessionId(String realId, String jvmRoute) {
        return this.getUseJK() ? super.createSessionId(realId, jvmRoute) : realId;
    }

    @Override
    protected int getTotalActiveSessions() {
        return this.localActiveCounter.get() + this.unloadedSessions.size() - this.passivatedCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionRepl(ClusteredSession<O> session) {
        boolean endBatch = false;
        BatchingManager batchingManager = this.distributedCacheManager.getBatchingManager();
        try {
            if (!batchingManager.isBatchInProgress()) {
                batchingManager.startBatch();
                endBatch = true;
            }
            session.processSessionReplication();
        }
        catch (Exception ex) {
            log.debug((Object)"processSessionRepl(): failed with exception", (Throwable)ex);
            RuntimeException exception = null;
            try {
                batchingManager.setBatchRollbackOnly();
            }
            catch (RuntimeException e) {
                exception = e;
            }
            catch (Exception e) {
                exception = UndertowMessages.MESSAGES.failedSessionReplication(e);
            }
            if (exception != null) {
                UndertowLogger.WEB_SESSION_LOGGER.exceptionRollingBackTransaction(exception);
                throw exception;
            }
        }
        finally {
            if (endBatch) {
                batchingManager.endBatch();
            }
        }
    }

    private ClusteredSession<O> cast(Session session) {
        if (session == null) {
            return null;
        }
        if (!(session instanceof ClusteredSession)) {
            throw UndertowMessages.MESSAGES.invalidSession(this.getClass().getName());
        }
        return (ClusteredSession)session;
    }

    private static class SemaphoreLock
    implements Lock {
        private final Semaphore semaphore;

        SemaphoreLock(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        @Override
        public void lock() {
            this.semaphore.acquireUninterruptibly();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.semaphore.acquire();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            return this.semaphore.tryAcquire();
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            return this.semaphore.tryAcquire(timeout, unit);
        }

        @Override
        public void unlock() {
            this.semaphore.release();
        }
    }

    private class PassivationCheck
    implements Comparable<PassivationCheck> {
        private final String realId;
        private final OwnedSessionUpdate osu;
        private final ClusteredSession<O> session;

        private PassivationCheck(String realId, OwnedSessionUpdate osu) {
            assert (osu != null) : UndertowMessages.MESSAGES.nullParamter("osu");
            assert (realId != null) : UndertowMessages.MESSAGES.nullParamter("realId");
            this.realId = realId;
            this.osu = osu;
            this.session = null;
        }

        private PassivationCheck(ClusteredSession<O> session) {
            assert (session != null) : UndertowMessages.MESSAGES.nullParamter("session");
            this.realId = session.getRealId();
            this.session = session;
            this.osu = null;
        }

        private long getLastUpdate() {
            return this.osu == null ? this.session.getLastAccessedTimeInternal() : this.osu.getUpdateTime();
        }

        private void passivate() {
            if (this.osu == null) {
                DistributableSessionManager.this.processSessionPassivation(this.realId);
            } else {
                DistributableSessionManager.this.processUnloadedSessionPassivation(this.realId, this.osu);
            }
        }

        private String getRealId() {
            return this.realId;
        }

        private boolean isUnloaded() {
            return this.osu != null;
        }

        @Override
        public int compareTo(PassivationCheck o) {
            long anotherVal;
            long thisVal = this.getLastUpdate();
            return thisVal < (anotherVal = o.getLastUpdate()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }
}

