/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.server.HttpServerExchange;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.wildfly.extension.undertow.session.ClusteredSession;
import org.wildfly.extension.undertow.session.SnapshotManager;

public final class SessionReplicationContext {
    private static final ThreadLocal<SessionReplicationContext> replicationContext = new ThreadLocal();
    private static final SessionReplicationContext EMPTY = new SessionReplicationContext();
    private final AtomicInteger webappCount = new AtomicInteger(0);
    private volatile SnapshotManager soleManager;
    private volatile ClusteredSession<? extends OutgoingDistributableSessionData> soleSession;
    private volatile Map<ClusteredSession<? extends OutgoingDistributableSessionData>, SnapshotManager> crossCtxSessions;
    private volatile HttpServerExchange exchange;

    public static void enterWebapp(HttpServerExchange exchange, boolean startCacheActivity) {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx == null) {
            ctx = new SessionReplicationContext(exchange);
            replicationContext.set(ctx);
        }
        ctx.webappCount.incrementAndGet();
    }

    public static SessionReplicationContext exitWebapp() {
        int count;
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx != null && (count = ctx.webappCount.decrementAndGet()) < 1) {
            ctx.exchange = null;
            replicationContext.set(null);
            return ctx;
        }
        return EMPTY;
    }

    public static void bindSession(ClusteredSession<? extends OutgoingDistributableSessionData> session, SnapshotManager manager) {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx != null && ctx.webappCount.get() > 0) {
            ctx.addReplicatableSession(session, manager);
        }
    }

    public static void sessionExpired(ClusteredSession<? extends OutgoingDistributableSessionData> session, String realId, SnapshotManager manager) {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        if (ctx != null && ctx.webappCount.get() > 0) {
            ctx.sessionExpired(session, manager);
        }
    }

    public static boolean isLocallyActive() {
        return SessionReplicationContext.getCurrentContext() != null;
    }

    public static HttpServerExchange getCurrentExchange() {
        SessionReplicationContext ctx = SessionReplicationContext.getCurrentContext();
        return ctx == null ? null : ctx.exchange;
    }

    private static SessionReplicationContext getCurrentContext() {
        return replicationContext.get();
    }

    private SessionReplicationContext(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    private SessionReplicationContext() {
    }

    public Map<ClusteredSession<? extends OutgoingDistributableSessionData>, SnapshotManager> getCrossContextSessions() {
        return this.crossCtxSessions;
    }

    public SnapshotManager getSoleSnapshotManager() {
        return this.soleManager;
    }

    public ClusteredSession<? extends OutgoingDistributableSessionData> getSoleSession() {
        return this.soleSession;
    }

    private synchronized void addReplicatableSession(ClusteredSession<? extends OutgoingDistributableSessionData> session, SnapshotManager mgr) {
        if (this.crossCtxSessions != null) {
            this.crossCtxSessions.put(session, mgr);
        } else if (this.soleManager == null) {
            this.soleManager = mgr;
            this.soleSession = session;
        } else if (!mgr.equals(this.soleManager)) {
            this.crossCtxSessions = new ConcurrentHashMap<ClusteredSession<? extends OutgoingDistributableSessionData>, SnapshotManager>();
            this.crossCtxSessions.put(this.soleSession, this.soleManager);
            this.crossCtxSessions.put(session, mgr);
            this.soleManager = null;
            this.soleSession = null;
        } else {
            this.soleSession = session;
        }
    }

    private synchronized void sessionExpired(ClusteredSession<? extends OutgoingDistributableSessionData> session, SnapshotManager manager) {
        if (manager.equals(this.soleManager)) {
            this.soleManager = null;
            this.soleSession = null;
        } else if (this.crossCtxSessions != null) {
            this.crossCtxSessions.remove(session);
        }
    }
}

