/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.web;

import java.util.jar.Manifest;
import org.jboss.as.osgi.web.WebBundleURIParser;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.spi.DeploymentProvider;
import org.jboss.osgi.framework.spi.DeploymentProviderPlugin;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;

public class DeploymentProviderIntegration
extends DeploymentProviderPlugin {
    protected DeploymentProvider createServiceValue(StartContext startContext) throws StartException {
        DeploymentProvider defaultHandler = super.createServiceValue(startContext);
        return new DeploymentProviderImpl(defaultHandler);
    }

    static class DeploymentProviderImpl
    implements DeploymentProvider {
        private final DeploymentProvider defaultHandler;

        DeploymentProviderImpl(DeploymentProvider defaultHandler) {
            this.defaultHandler = defaultHandler;
        }

        public Deployment createDeployment(StorageState storageState) throws BundleException {
            return this.defaultHandler.createDeployment(storageState);
        }

        public OSGiMetaData createOSGiMetaData(Deployment deployment) throws BundleException {
            return this.defaultHandler.createOSGiMetaData(deployment);
        }

        public Deployment createDeployment(String location, VirtualFile rootFile) throws BundleException {
            if (!location.startsWith("webbundle:")) {
                return this.defaultHandler.createDeployment(location, rootFile);
            }
            Manifest manifest = WebBundleURIParser.parse(location);
            OSGiMetaData metadata = OSGiMetaDataBuilder.load((Manifest)manifest);
            String symbolicName = metadata.getBundleSymbolicName();
            Deployment dep = DeploymentFactory.createDeployment((VirtualFile)rootFile, (String)location, (String)symbolicName, null);
            dep.putAttachment(IntegrationConstants.MANIFEST_KEY, (Object)manifest);
            dep.putAttachment(IntegrationConstants.OSGI_METADATA_KEY, (Object)metadata);
            return dep;
        }
    }
}

