/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.osgi.metadata.OSGiMetaData;

public class WebBundleContextProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)depUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        OSGiMetaData metadata = (OSGiMetaData)depUnit.getAttachment(OSGiConstants.OSGI_METADATA_KEY);
        if (warMetaData == null || metadata == null) {
            return;
        }
        FilterMetaData filterMetaData = new FilterMetaData();
        filterMetaData.setFilterClass(WebBundleContextFilter.class.getName());
        filterMetaData.setFilterName("Filter forbidden resources");
        FilterMappingMetaData filterMappingMetaData = new FilterMappingMetaData();
        filterMappingMetaData.setFilterName(filterMetaData.getName());
        filterMappingMetaData.setUrlPatterns(Arrays.asList("/OSGI-INF/*", "/OSGI-OPT/*"));
        JBossWebMetaData jbossWebMetaData = warMetaData.getMergedJBossWebMetaData();
        FiltersMetaData filters = jbossWebMetaData.getFilters();
        if (filters == null) {
            filters = new FiltersMetaData();
            jbossWebMetaData.setFilters(filters);
        }
        filters.add((MappableMetaData)filterMetaData);
        ArrayList<FilterMappingMetaData> filterMappings = jbossWebMetaData.getFilterMappings();
        if (filterMappings == null) {
            filterMappings = new ArrayList<FilterMappingMetaData>();
            jbossWebMetaData.setFilterMappings(filterMappings);
        }
        filterMappings.add(filterMappingMetaData);
    }

    public void undeploy(DeploymentUnit depUnit) {
    }

    public static class WebBundleContextFilter
    implements Filter {
        public void init(FilterConfig config) throws ServletException {
        }

        public void destroy() {
        }

        public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
            chain.doFilter(req, res);
        }
    }
}

