/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.web;

import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.web.WebExtension;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.host.ContextActivator;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.resolver.XBundleRevision;

public class WebContextActivationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        ContextActivator activator = (ContextActivator)depUnit.getAttachment(ContextActivator.ATTACHMENT_KEY);
        XBundleRevision brev = (XBundleRevision)depUnit.getAttachment(OSGiConstants.BUNDLE_REVISION_KEY);
        if (activator != null && brev != null) {
            brev.putAttachment(WebExtension.CONTEXT_ACTIVATOR_KEY, (Object)activator);
            Deployment deployment = (Deployment)brev.getBundle().adapt(Deployment.class);
            if (deployment.isAutoStart()) {
                activator.startAsync();
            }
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        ContextActivator activator = (ContextActivator)depUnit.getAttachment(ContextActivator.ATTACHMENT_KEY);
        XBundleRevision brev = (XBundleRevision)depUnit.getAttachment(OSGiConstants.BUNDLE_REVISION_KEY);
        if (activator != null && brev != null) {
            brev.removeAttachment(WebExtension.CONTEXT_ACTIVATOR_KEY);
        }
    }
}

