/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.web;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.osgi.AbstractSubsystemExtension;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.web.DeploymentProviderIntegration;
import org.jboss.as.osgi.web.RemountDeploymentRootProcessor;
import org.jboss.as.osgi.web.WebBundleContextProcessor;
import org.jboss.as.osgi.web.WebBundleDependencyProcessor;
import org.jboss.as.osgi.web.WebBundleFragmentProcessor;
import org.jboss.as.osgi.web.WebBundleStructureProcessor;
import org.jboss.as.osgi.web.WebBundleURLStreamHandler;
import org.jboss.as.osgi.web.WebContextActivationProcessor;
import org.jboss.as.osgi.web.WebContextLifecycleInterceptor;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.web.host.ContextActivator;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.spi.FrameworkBuilder;
import org.jboss.osgi.framework.spi.IntegrationService;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.spi.AttachmentKey;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;

public class WebExtension
extends AbstractSubsystemExtension {
    static final AttachmentKey<ContextActivator> CONTEXT_ACTIVATOR_KEY = AttachmentKey.create(ContextActivator.class);
    public static final String OSGI_BUNDLECONTEXT = "osgi-bundlecontext";
    public static final String WEB_CONTEXTPATH = "Web-ContextPath";
    public static final String WEBBUNDLE_PROTOCOL = "webbundle";
    public static final String WEBBUNDLE_PREFIX = "webbundle:";
    private ServiceRegistration<URLStreamHandlerService> urlHandlerRegistration;

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceTarget serviceTarget = context.getServiceTarget();
                newControllers.add(WebContextLifecycleInterceptor.addService(serviceTarget, verificationHandler));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("osgi", Phase.STRUCTURE, 1056, (DeploymentUnitProcessor)new WebBundleStructureProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.STRUCTURE, 1104, (DeploymentUnitProcessor)new RemountDeploymentRootProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.DEPENDENCIES, 1792, (DeploymentUnitProcessor)new WebBundleDependencyProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.PARSE, 14592, (DeploymentUnitProcessor)new WebBundleContextProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.POST_MODULE, 592, (DeploymentUnitProcessor)new WebBundleFragmentProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.INSTALL, 7680, (DeploymentUnitProcessor)new WebContextActivationProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }

    public void registerIntegrationServices(FrameworkBuilder builder, SubsystemState subsystemState) {
        builder.registerIntegrationService(FrameworkBuilder.FrameworkPhase.CREATE, (IntegrationService)new DeploymentProviderIntegration());
    }

    public void configureServiceDependencies(ServiceName serviceName, ServiceBuilder<?> builder) {
        if (serviceName.equals(IntegrationServices.SYSTEM_SERVICES_PLUGIN)) {
            builder.addDependency(WebContextLifecycleInterceptor.SERVICE_NAME);
        }
    }

    public void startSystemServices(StartContext startContext, BundleContext systemContext) {
        this.urlHandlerRegistration = WebBundleURLStreamHandler.registerService(systemContext);
    }

    public void stopSystemServices(StopContext stopContext, BundleContext systemContext) {
        if (this.urlHandlerRegistration != null) {
            this.urlHandlerRegistration.unregister();
            this.urlHandlerRegistration = null;
        }
    }
}

