/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.XContentCapability;
import org.jboss.osgi.repository.spi.AbstractRepositoryCapability;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.resolver.XResourceBuilderFactory;
import org.jboss.osgi.resolver.spi.AbstractResource;
import org.osgi.service.repository.RepositoryContent;

public final class URLResourceBuilderFactory
extends XResourceBuilderFactory<XResource> {
    private final URLResource urlres;

    private URLResourceBuilderFactory(URLResource urlres) {
        this.urlres = urlres;
    }

    public static XResourceBuilder<XResource> create(URL contentURL, Map<String, Object> contentAtts, boolean loadMetadata) {
        URLResource urlres = new URLResource(contentURL);
        URLResourceBuilderFactory factory = new URLResourceBuilderFactory(urlres);
        XResourceBuilder builder = XResourceBuilderFactory.create((XResourceBuilderFactory)factory);
        XCapability ccap = builder.addCapability("osgi.content", contentAtts, null);
        Map atts = ccap.getAttributes();
        atts.put("url", contentURL.toExternalForm());
        if (atts.get("osgi.content") == null) {
            atts.put("osgi.content", "default-digest");
        }
        if (atts.get("mime") == null) {
            atts.put("mime", "application/octet-stream");
        }
        if (atts.get("size") == null) {
            atts.put("size", XContentCapability.DEFAULT_SIZE);
        }
        if (loadMetadata) {
            InputStream content = urlres.getContent();
            try {
                Manifest manifest = new JarInputStream(content).getManifest();
                OSGiMetaData metaData = OSGiMetaDataBuilder.load((Manifest)manifest);
                builder.loadFrom(metaData);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot create capability from: " + contentURL, ex);
            }
            finally {
                if (content != null) {
                    try {
                        content.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return builder;
    }

    public XCapability createCapability(XResource resource, String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        return new AbstractRepositoryCapability(resource, namespace, atts, dirs);
    }

    public XResource createResource() {
        return this.urlres;
    }

    static class URLResource
    extends AbstractResource
    implements RepositoryContent {
        private final URL contentURL;

        URLResource(URL contentURL) {
            if (contentURL == null) {
                throw RepositoryMessages.MESSAGES.illegalArgumentNull("contentURL");
            }
            this.contentURL = contentURL;
        }

        URL getContentURL() {
            return this.contentURL;
        }

        @Override
        public InputStream getContent() {
            try {
                if (this.contentURL.getProtocol().equals("file")) {
                    return new FileInputStream(new File(this.contentURL.getPath()));
                }
                return this.contentURL.openStream();
            }
            catch (IOException ex) {
                throw RepositoryMessages.MESSAGES.cannotObtainInputStream(ex, (XResource)this);
            }
        }
    }
}

