/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.util;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.settings.Settings;

public class LoggerUtil {
    private static Handler logHandler;

    public static synchronized Logger getLogger(String name) {
        if (logHandler == null) {
            try {
                File logFile = new File(Settings.getInstance().getLogFile());
                if (logFile.getParentFile() != null && !logFile.getParentFile().isDirectory()) {
                    if (!logFile.getParentFile().mkdirs()) {
                        return Logger.getLogger(name);
                    }
                } else if (logFile.isDirectory()) {
                    Settings.getInstance().setLogFile(Settings.getInstance().getLogFile() + Config.getPathSeparator() + "aesh.log");
                }
                logHandler = new FileHandler(Settings.getInstance().getLogFile());
                logHandler.setFormatter(new SimpleFormatter());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Logger log = Logger.getLogger(name);
        log.setUseParentHandlers(false);
        log.addHandler(logHandler);
        return log;
    }
}

