/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.Rule;
import org.jboss.jca.validator.Validate;

public class Validator {
    private static final String[] CLASS_RULES = new String[]{"org.jboss.jca.validator.rules.mcf.MCFNull", "org.jboss.jca.validator.rules.mcf.MCF", "org.jboss.jca.validator.rules.mcf.MCFConstructor", "org.jboss.jca.validator.rules.mcf.MCFHashCode", "org.jboss.jca.validator.rules.mcf.MCFEquals", "org.jboss.jca.validator.rules.mcf.MCFConfigProperties", "org.jboss.jca.validator.rules.mc.MC", "org.jboss.jca.validator.rules.mc.MCGetMetaData", "org.jboss.jca.validator.rules.ra.RANull", "org.jboss.jca.validator.rules.ra.RA", "org.jboss.jca.validator.rules.ra.RAConstructor", "org.jboss.jca.validator.rules.ra.RAHashCode", "org.jboss.jca.validator.rules.ra.RAEquals", "org.jboss.jca.validator.rules.ra.RAConfigProperties", "org.jboss.jca.validator.rules.cf.CFConstructor", "org.jboss.jca.validator.rules.cf.CFNull", "org.jboss.jca.validator.rules.cf.CFSerializable", "org.jboss.jca.validator.rules.cf.CFReferenceable", "org.jboss.jca.validator.rules.as.ASNull", "org.jboss.jca.validator.rules.as.AS", "org.jboss.jca.validator.rules.as.ASConstructor", "org.jboss.jca.validator.rules.as.ASConfigProperties", "org.jboss.jca.validator.rules.ao.AONull", "org.jboss.jca.validator.rules.ao.AOConstructor", "org.jboss.jca.validator.rules.ao.AOConfigProperties", "org.jboss.jca.validator.rules.ao.AORAA"};
    private static final String[] OBJECT_RULES = new String[]{"org.jboss.jca.validator.rules.mc.MCGetMetaData"};
    private static String[] allRules;

    public ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle("validator", Locale.US, Validator.class.getClassLoader());
    }

    public List<Failure> validate(List<Validate> objects) {
        if (objects == null || objects.size() == 0) {
            return null;
        }
        List<Rule> rules = this.extractRules(allRules);
        return this.execRulesOnValidates(objects, rules);
    }

    private List<Failure> execRulesOnValidates(List<Validate> objects, List<Rule> rules) {
        ResourceBundle resourceBundle = this.getResourceBundle();
        LinkedList<Failure> result = null;
        for (Rule rule : rules) {
            for (Validate obj : objects) {
                List<Failure> failures = rule.validate(obj, resourceBundle);
                if (failures == null) continue;
                if (result == null) {
                    result = new LinkedList<Failure>();
                }
                result.addAll(failures);
            }
        }
        return result;
    }

    private List<Rule> extractRules(String[] rulesNameArray) {
        ArrayList<Rule> rules = new ArrayList<Rule>(rulesNameArray.length);
        for (int i = 0; i < rulesNameArray.length; ++i) {
            try {
                Class<?> clz = Class.forName(rulesNameArray[i], true, Validator.class.getClassLoader());
                Rule rule = (Rule)clz.newInstance();
                rules.add(rule);
                continue;
            }
            catch (Throwable t) {
                throw new IllegalArgumentException(rulesNameArray[i], t);
            }
        }
        return rules;
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(CLASS_RULES));
        arrayList.addAll(Arrays.asList(OBJECT_RULES));
        allRules = arrayList.toArray(new String[CLASS_RULES.length + OBJECT_RULES.length]);
    }
}

