/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.glassfish.json.JsonNumberImpl;
import org.glassfish.json.JsonStringImpl;
import org.glassfish.json.JsonWriterImpl;

class JsonArrayBuilderImpl
implements JsonArrayBuilder {
    private final List<JsonValue> valueList = new ArrayList<JsonValue>();

    @Override
    public JsonArrayBuilder add(JsonValue value) {
        this.valueList.add(value);
        return this;
    }

    @Override
    public JsonArrayBuilder add(String value) {
        this.valueList.add(new JsonStringImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigDecimal value) {
        this.valueList.add(new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigInteger value) {
        this.valueList.add(new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(int value) {
        this.valueList.add(new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(long value) {
        this.valueList.add(new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(double value) {
        this.valueList.add(new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(boolean value) {
        this.valueList.add(value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    @Override
    public JsonArrayBuilder addNull() {
        this.valueList.add(JsonValue.NULL);
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        this.valueList.add(builder.build());
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        this.valueList.add(builder.build());
        return this;
    }

    @Override
    public JsonArray build() {
        ArrayList<JsonValue> snapshot = new ArrayList<JsonValue>(this.valueList);
        return new JsonArrayImpl(Collections.unmodifiableList(snapshot));
    }

    private static final class JsonArrayImpl
    extends AbstractList<JsonValue>
    implements JsonArray {
        private final List<JsonValue> valueList;

        JsonArrayImpl(List<JsonValue> valueList) {
            this.valueList = valueList;
        }

        @Override
        public int size() {
            return this.valueList.size();
        }

        @Override
        public JsonObject getJsonObject(int index) {
            return (JsonObject)this.valueList.get(index);
        }

        @Override
        public JsonArray getJsonArray(int index) {
            return (JsonArray)this.valueList.get(index);
        }

        @Override
        public JsonNumber getJsonNumber(int index) {
            return (JsonNumber)this.valueList.get(index);
        }

        @Override
        public JsonString getJsonString(int index) {
            return (JsonString)this.valueList.get(index);
        }

        @Override
        public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
            return this.valueList;
        }

        @Override
        public String getString(int index) {
            return this.getJsonString(index).getString();
        }

        @Override
        public String getString(int index, String defaultValue) {
            try {
                return this.getString(index);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        @Override
        public int getInt(int index) {
            return this.getJsonNumber(index).intValue();
        }

        @Override
        public int getInt(int index, int defaultValue) {
            try {
                return this.getInt(index);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        @Override
        public boolean getBoolean(int index) {
            JsonValue jsonValue = this.get(index);
            if (jsonValue == JsonValue.TRUE) {
                return true;
            }
            if (jsonValue == JsonValue.FALSE) {
                return false;
            }
            throw new ClassCastException();
        }

        @Override
        public boolean getBoolean(int index, boolean defaultValue) {
            try {
                return this.getBoolean(index);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        @Override
        public boolean isNull(int index) {
            return this.valueList.get(index).equals(JsonValue.NULL);
        }

        @Override
        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.ARRAY;
        }

        @Override
        public JsonValue get(int index) {
            return this.valueList.get(index);
        }

        @Override
        public String toString() {
            StringWriter sw = new StringWriter();
            JsonWriterImpl jw = new JsonWriterImpl(sw);
            jw.write(this);
            jw.close();
            return sw.toString();
        }
    }
}

