/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import javax.json.JsonException;
import javax.json.stream.JsonParsingException;
import org.glassfish.json.JsonLocationImpl;

final class JsonTokenizer
implements Closeable {
    private final TokenizerReader reader;
    private int pushbackChar = -1;

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    JsonTokenizer(Reader reader) {
        this.reader = new DirectReader(reader);
    }

    private int read() {
        if (this.pushbackChar != -1) {
            int tempCh = this.pushbackChar;
            this.pushbackChar = -1;
            return tempCh;
        }
        return this.reader.readChar();
    }

    private void store(char ch) {
        this.reader.storeChar(ch);
    }

    private void unread(int ch) {
        this.pushbackChar = ch;
    }

    private void readString() {
        int ch;
        do {
            ch = this.read();
            block0 : switch (ch) {
                case -1: {
                    throw new JsonException("Unexpected EOF");
                }
                case 92: {
                    int ch2 = this.read();
                    switch (ch2) {
                        case 98: {
                            this.store('\b');
                            break block0;
                        }
                        case 116: {
                            this.store('\t');
                            break block0;
                        }
                        case 110: {
                            this.store('\n');
                            break block0;
                        }
                        case 102: {
                            this.store('\f');
                            break block0;
                        }
                        case 114: {
                            this.store('\r');
                            break block0;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            this.store((char)ch2);
                            break block0;
                        }
                        case 117: {
                            int unicode = 0;
                            for (int i = 0; i < 4; ++i) {
                                int ch3 = this.read();
                                unicode = (char)(unicode << 4);
                                if (ch3 >= 48 && ch3 <= 57) {
                                    unicode = (char)(unicode | (char)ch3 - 48);
                                    continue;
                                }
                                if (ch3 >= 97 && ch3 <= 102) {
                                    unicode = (char)(unicode | (char)ch3 - 97 + 10);
                                    continue;
                                }
                                if (ch3 >= 65 && ch3 <= 70) {
                                    unicode = (char)(unicode | (char)ch3 - 65 + 10);
                                    continue;
                                }
                                throw new JsonParsingException("Unexpected Char=" + ch3, JsonLocationImpl.UNKNOWN);
                            }
                            this.store((char)(unicode & 0xFFFF));
                            break block0;
                        }
                    }
                    throw new JsonParsingException("Unexpected Char=" + ch2, JsonLocationImpl.UNKNOWN);
                }
                case 34: {
                    break;
                }
                default: {
                    if (ch >= 0 && ch <= 31 || ch >= 127 && ch <= 159) {
                        throw new JsonException("Unexpected Char=" + ch);
                    }
                    this.store((char)ch);
                }
            }
        } while (ch != 34);
    }

    private void readNumber(int ch) {
        int count;
        if (ch == 45) {
            this.store((char)ch);
            ch = this.read();
            if (ch < 48 || ch > 57) {
                throw new JsonParsingException("Unexpected Char=" + ch, JsonLocationImpl.UNKNOWN);
            }
        }
        if (ch == 48) {
            this.store((char)ch);
            ch = this.read();
        } else {
            do {
                this.store((char)ch);
            } while ((ch = this.read()) >= 48 && ch <= 57);
        }
        if (ch == 46) {
            count = 0;
            do {
                this.store((char)ch);
                ch = this.read();
                ++count;
            } while (ch >= 48 && ch <= 57);
            if (count == 1) {
                throw new JsonParsingException("Unexpected Char=" + ch, JsonLocationImpl.UNKNOWN);
            }
        }
        if (ch == 101 || ch == 69) {
            this.store((char)ch);
            ch = this.read();
            if (ch == 43 || ch == 45) {
                this.store((char)ch);
                ch = this.read();
            }
            count = 0;
            while (ch >= 48 && ch <= 57) {
                this.store((char)ch);
                ch = this.read();
                ++count;
            }
            if (count == 0) {
                throw new JsonParsingException("Unexpected Char=" + ch, JsonLocationImpl.UNKNOWN);
            }
        }
        this.unread(ch);
    }

    private void readTrue() {
        char ch1 = (char)this.read();
        char ch2 = (char)this.read();
        char ch3 = (char)this.read();
    }

    private void readFalse() {
        char ch1 = (char)this.read();
        char ch2 = (char)this.read();
        char ch3 = (char)this.read();
        char ch4 = (char)this.read();
    }

    private void readNull() {
        char ch1 = (char)this.read();
        char ch2 = (char)this.read();
        char ch3 = (char)this.read();
    }

    JsonToken nextToken() throws IOException {
        this.reader.reset();
        int ch = this.read();
        while (ch == 32 || ch == 9 || ch == 10 || ch == 13) {
            ch = this.read();
        }
        switch (ch) {
            case -1: {
                return JsonToken.EOF;
            }
            case 123: {
                return JsonToken.CURLYOPEN;
            }
            case 91: {
                return JsonToken.SQUAREOPEN;
            }
            case 58: {
                return JsonToken.COLON;
            }
            case 44: {
                return JsonToken.COMMA;
            }
            case 34: {
                this.readString();
                return JsonToken.STRING;
            }
            case 45: {
                this.readNumber(ch);
                return JsonToken.NUMBER;
            }
            case 116: {
                this.readTrue();
                return JsonToken.TRUE;
            }
            case 102: {
                this.readFalse();
                return JsonToken.FALSE;
            }
            case 110: {
                this.readNull();
                return JsonToken.NULL;
            }
            case 93: {
                return JsonToken.SQUARECLOSE;
            }
            case 125: {
                return JsonToken.CURLYCLOSE;
            }
        }
        if (ch >= 48 && ch <= 57) {
            this.readNumber(ch);
            return JsonToken.NUMBER;
        }
        throw new JsonParsingException("Unexpected char=" + (char)ch, JsonLocationImpl.UNKNOWN);
    }

    String getValue() {
        return this.reader.getValue();
    }

    private static class DirectReader
    implements TokenizerReader {
        private final Reader reader;
        private StringBuilder builder;

        DirectReader(Reader reader) {
            this.reader = reader;
            this.builder = new StringBuilder();
        }

        @Override
        public int readChar() {
            try {
                return this.reader.read();
            }
            catch (IOException ioe) {
                throw new JsonException("I/O error while tokenizing", ioe);
            }
        }

        @Override
        public void storeChar(int ch) {
            this.builder.append((char)ch);
        }

        @Override
        public void reset() {
            if (this.builder.length() != 0) {
                this.builder = new StringBuilder();
            }
        }

        @Override
        public String getValue() {
            return this.builder.toString();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static class BufReader
    implements TokenizerReader {
        private char[] buf = new char[8192];
        private int length;
        private int curPtr;
        private int valuePtr = -1;
        private int valueLength;
        private final Reader reader;
        boolean eof;

        BufReader(Reader reader) {
            this.reader = reader;
        }

        @Override
        public int readChar() {
            if (this.eof) {
                return -1;
            }
            if (this.curPtr < this.length) {
                return this.buf[this.curPtr++];
            }
            if (this.valuePtr == -1) {
                this.curPtr = 0;
                this.length = 0;
            } else if (this.valuePtr == 0 && this.valueLength == this.buf.length) {
                assert (this.length == this.buf.length);
                assert (this.curPtr == this.buf.length);
                char[] temp = new char[2 * this.buf.length];
                System.arraycopy(this.buf, 0, temp, 0, this.valueLength);
                this.buf = temp;
            } else if (this.valuePtr == 0 && this.valueLength < this.buf.length) {
                this.curPtr = this.valueLength;
                this.length = this.valueLength;
            } else {
                System.arraycopy(this.buf, this.valuePtr, this.buf, 0, this.valueLength);
                this.length = this.valueLength;
                this.curPtr = this.valueLength;
                this.valuePtr = 0;
            }
            while (this.curPtr <= this.length) {
                int read;
                try {
                    read = this.reader.read(this.buf, this.curPtr, this.buf.length - this.length);
                }
                catch (IOException ioe) {
                    throw new JsonException("I/O error", ioe);
                }
                if (read == -1) {
                    this.eof = true;
                    return -1;
                }
                this.length += read;
            }
            return this.buf[this.curPtr++];
        }

        @Override
        public void storeChar(int ch) {
            if (this.valuePtr == -1) {
                this.valuePtr = this.curPtr - 1;
            }
            this.buf[this.valuePtr + this.valueLength] = (char)ch;
            ++this.valueLength;
        }

        @Override
        public void reset() {
        }

        @Override
        public String getValue() {
            return null;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static interface TokenizerReader
    extends Closeable {
        public int readChar();

        public void storeChar(int var1);

        public void reset();

        public String getValue();
    }

    static enum JsonToken {
        CURLYOPEN,
        SQUAREOPEN,
        COLON,
        COMMA,
        STRING,
        NUMBER,
        TRUE,
        FALSE,
        NULL,
        CURLYCLOSE,
        SQUARECLOSE,
        EOF;

    }
}

