/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import com.sun.faces.application.view.ViewScopeExtension;
import com.sun.faces.flow.FlowCDIExtension;
import com.sun.faces.flow.FlowDiscoveryCDIExtension;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jsf.JSFLogger;
import org.jboss.as.jsf.JSFMessages;
import org.jboss.as.jsf.deployment.JSFModuleIdFactory;
import org.jboss.as.jsf.deployment.JsfVersionMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JSFDependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier JSF_SUBSYSTEM = ModuleIdentifier.create((String)"org.jboss.as.jsf");
    private static final ModuleIdentifier BEAN_VALIDATION = ModuleIdentifier.create((String)"org.hibernate.validator");
    private static final ModuleIdentifier JSTL = ModuleIdentifier.create((String)"javax.servlet.jstl.api");
    private JSFModuleIdFactory moduleIdFactory = JSFModuleIdFactory.getInstance();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (JsfVersionMarker.getVersion(deploymentUnit).equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        String defaultJsfVersion = JSFModuleIdFactory.getInstance().getDefaultSlot();
        String jsfVersion = JsfVersionMarker.getVersion(topLevelDeployment);
        if (!this.moduleIdFactory.isValidJSFSlot(jsfVersion)) {
            JSFLogger.ROOT_LOGGER.unknownJSFVersion(jsfVersion, defaultJsfVersion);
            jsfVersion = defaultJsfVersion;
        }
        if (jsfVersion.equals(defaultJsfVersion) && !this.moduleIdFactory.isValidJSFSlot(jsfVersion)) {
            throw JSFMessages.MESSAGES.invalidDefaultJSFImpl(defaultJsfVersion);
        }
        this.addJSFAPI(jsfVersion, moduleSpecification, moduleLoader);
        this.addJSFImpl(jsfVersion, moduleSpecification, moduleLoader, topLevelDeployment);
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JSTL, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, BEAN_VALIDATION, false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JSF_SUBSYSTEM, false, false, true, false));
        this.addJSFInjection(jsfVersion, moduleSpecification, moduleLoader);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void addJSFAPI(String jsfVersion, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        ModuleIdentifier jsfModule = this.moduleIdFactory.getApiModId(jsfVersion);
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, jsfModule, false, false, false, false));
    }

    private void addJSFImpl(String jsfVersion, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, DeploymentUnit topLevelDeployment) {
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        ModuleIdentifier jsfModule = this.moduleIdFactory.getImplModId(jsfVersion);
        ModuleDependency jsfImpl = new ModuleDependency(moduleLoader, jsfModule, false, false, false, false);
        jsfImpl.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpecification.addSystemDependency(jsfImpl);
        try {
            jsfImpl.getModuleLoader().loadModule(jsfModule).getClassLoader().loadClass("com.sun.faces.flow.FlowCDIExtension");
        }
        catch (Exception e) {
            return;
        }
        this.addCDIExtensions(topLevelDeployment);
    }

    private void addJSFInjection(String jsfVersion, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        ModuleIdentifier jsfInjectionModule = this.moduleIdFactory.getInjectionModId(jsfVersion);
        ModuleDependency jsfInjectionDependency = new ModuleDependency(moduleLoader, jsfInjectionModule, false, true, true, false);
        moduleSpecification.addSystemDependency(jsfInjectionDependency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCDIExtensions(DeploymentUnit topLevelDeployment) {
        ClassLoader classLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)FlowCDIExtension.class.getClassLoader());
            CDIExtensionMetadataImpl metadata = new CDIExtensionMetadataImpl((Extension)new FlowCDIExtension());
            topLevelDeployment.addToAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS, (Object)metadata);
            metadata = new CDIExtensionMetadataImpl((Extension)new ViewScopeExtension());
            topLevelDeployment.addToAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS, (Object)metadata);
            metadata = new CDIExtensionMetadataImpl((Extension)new FlowDiscoveryCDIExtension());
            topLevelDeployment.addToAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS, (Object)metadata);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)classLoader);
        }
    }

    private static class CDIExtensionMetadataImpl
    implements Metadata<Extension> {
        private final Extension ext;

        public CDIExtensionMetadataImpl(Extension ext) {
            this.ext = ext;
        }

        public Extension getValue() {
            return this.ext;
        }

        public String getLocation() {
            return this.ext.getClass().getName();
        }
    }
}

