/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.HashMap;
import java.util.Map;

enum Element {
    UNKNOWN(null),
    LOGIN("login"),
    PROPERTY("property"),
    MAIL_SESSION("mail-session"),
    SMTP_SERVER("smtp-server"),
    POP3_SERVER("pop3-server"),
    IMAP_SERVER("imap-server"),
    CUSTOM_SERVER("custom-server");

    private final String name;
    private static final Map<String, Element> elements;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = elements.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        elements = map;
    }
}

