/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class NetworkUtil {
    private static final String REMOTE_PROTOCOL = "remote";

    public static boolean belongsToNetwork(InetAddress address, InetAddress networkAddress, byte networkMask) {
        byte[] networkAddressBytes;
        if (address == null || networkAddress == null) {
            return false;
        }
        if (networkMask == 0) {
            return true;
        }
        byte[] addressBytes = address.getAddress();
        if (addressBytes.length != (networkAddressBytes = networkAddress.getAddress()).length) {
            return false;
        }
        int currentByte = 0;
        byte networkAddressByte = networkAddressBytes[currentByte];
        byte otherAddressByte = addressBytes[currentByte];
        for (int i = 0; i < networkMask; ++i) {
            if ((networkAddressByte & 0x80) != (otherAddressByte & 0x80)) {
                return false;
            }
            if ((i + 1) % 8 == 0) {
                if (currentByte == networkAddressBytes.length - 1) {
                    return true;
                }
                networkAddressByte = networkAddressBytes[++currentByte];
                otherAddressByte = addressBytes[currentByte];
                continue;
            }
            networkAddressByte = (byte)(networkAddressByte << 1);
            otherAddressByte = (byte)(otherAddressByte << 1);
        }
        return true;
    }

    static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }

    public static IoFuture<Connection> connect(Endpoint endpoint, String destinationHost, int destinationPort, InetSocketAddress sourceBindAddress, OptionMap connectionCreationOptions, CallbackHandler callbackHandler, SSLContext sslContext) throws IOException {
        InetSocketAddress destinationSocketAddress = new InetSocketAddress(NetworkUtil.formatPossibleIpv6Address(destinationHost), destinationPort);
        return NetworkUtil.connect(endpoint, destinationSocketAddress, sourceBindAddress, connectionCreationOptions, callbackHandler, sslContext);
    }

    public static IoFuture<Connection> connect(Endpoint endpoint, InetSocketAddress destination, InetSocketAddress sourceBindAddress, OptionMap connectionCreationOptions, CallbackHandler callbackHandler, SSLContext sslContext) throws IOException {
        return endpoint.connect(REMOTE_PROTOCOL, (SocketAddress)sourceBindAddress, (SocketAddress)destination, connectionCreationOptions, callbackHandler, sslContext);
    }
}

