/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.scanner.DefaultDeploymentOperations;
import org.jboss.as.server.deployment.scanner.DeploymentOperations;
import org.jboss.as.server.deployment.scanner.FileSystemDeploymentService;
import org.jboss.as.server.deployment.scanner.api.DeploymentScanner;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DeploymentScannerService
implements Service<DeploymentScanner> {
    private static final int DEFAULT_INTERVAL = 5000;
    private long interval;
    private TimeUnit unit = TimeUnit.MILLISECONDS;
    private boolean enabled;
    private boolean autoDeployZipped;
    private boolean autoDeployExploded;
    private boolean autoDeployXml;
    private Long deploymentTimeout;
    private final String relativeTo;
    private final String path;
    private FileSystemDeploymentService scanner;
    private final InjectedValue<PathManager> pathManagerValue = new InjectedValue();
    private final InjectedValue<ModelController> controllerValue = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduledExecutorValue = new InjectedValue();
    private volatile PathManager.Callback.Handle callbackHandle;

    public static ServiceName getServiceName(String repositoryName) {
        return DeploymentScanner.BASE_SERVICE_NAME.append(new String[]{repositoryName});
    }

    public static ServiceController<DeploymentScanner> addService(ServiceTarget serviceTarget, String name, String relativeTo, String path, Integer scanInterval, TimeUnit unit, Boolean autoDeployZip, Boolean autoDeployExploded, Boolean autoDeployXml, Boolean scanEnabled, Long deploymentTimeout, List<ServiceController<?>> newControllers, FileSystemDeploymentService bootTimeService, ScheduledExecutorService scheduledExecutorService, ServiceListener<Object> ... listeners) {
        DeploymentScannerService service = new DeploymentScannerService(relativeTo, path, scanInterval, unit, autoDeployZip, autoDeployExploded, autoDeployXml, scanEnabled, deploymentTimeout, bootTimeService);
        ServiceName serviceName = DeploymentScannerService.getServiceName(name);
        ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.pathManagerValue).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.controllerValue).addDependency(org.jboss.as.server.deployment.Services.JBOSS_DEPLOYMENT_CHAINS).addInjection(service.scheduledExecutorValue, (Object)scheduledExecutorService);
        builder.addListener(listeners);
        ServiceController svc = builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        if (newControllers != null) {
            newControllers.add(svc);
        }
        return svc;
    }

    DeploymentScannerService(String relativeTo, String path, Integer interval, TimeUnit unit, Boolean autoDeployZipped, Boolean autoDeployExploded, Boolean autoDeployXml, Boolean enabled, Long deploymentTimeout, FileSystemDeploymentService bootTimeService) {
        this.relativeTo = relativeTo;
        this.path = path;
        this.interval = interval == null ? 5000L : interval.longValue();
        this.unit = unit;
        this.autoDeployZipped = autoDeployZipped == null ? true : autoDeployZipped;
        this.autoDeployExploded = autoDeployExploded == null ? false : autoDeployExploded;
        this.autoDeployXml = autoDeployXml == null ? true : autoDeployXml;
        this.enabled = enabled == null ? true : enabled;
        this.deploymentTimeout = deploymentTimeout;
        this.scanner = bootTimeService;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            DeploymentOperations.Factory factory = new DeploymentOperations.Factory(){

                @Override
                public DeploymentOperations create() {
                    return new DefaultDeploymentOperations(((ModelController)DeploymentScannerService.this.controllerValue.getValue()).createClient((Executor)DeploymentScannerService.this.scheduledExecutorValue.getValue()));
                }
            };
            if (this.scanner == null) {
                PathManager pathManager = (PathManager)this.pathManagerValue.getValue();
                String pathName = pathManager.resolveRelativePathEntry(this.path, this.relativeTo);
                File relativePath = null;
                if (this.relativeTo != null) {
                    relativePath = new File(pathManager.getPathEntry(this.relativeTo).resolvePath());
                    this.callbackHandle = pathManager.registerCallback(pathName, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
                }
                FileSystemDeploymentService scanner = new FileSystemDeploymentService(this.relativeTo, new File(pathName), relativePath, factory, (ScheduledExecutorService)this.scheduledExecutorValue.getValue());
                scanner.setScanInterval(this.unit.toMillis(this.interval));
                scanner.setAutoDeployExplodedContent(this.autoDeployExploded);
                scanner.setAutoDeployZippedContent(this.autoDeployZipped);
                scanner.setAutoDeployXMLContent(this.autoDeployXml);
                if (this.deploymentTimeout != null) {
                    scanner.setDeploymentTimeout(this.deploymentTimeout);
                }
                this.scanner = scanner;
            } else {
                this.scanner.setDeploymentOperationsFactory(factory);
            }
            if (this.enabled) {
                this.scanner.startScanner();
            }
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        FileSystemDeploymentService scanner = this.scanner;
        this.scanner = null;
        scanner.stopScanner();
        ((ScheduledExecutorService)this.scheduledExecutorValue.getValue()).shutdown();
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
        }
    }

    public synchronized DeploymentScanner getValue() throws IllegalStateException {
        FileSystemDeploymentService scanner = this.scanner;
        if (scanner == null) {
            throw new IllegalStateException();
        }
        return scanner;
    }
}

