/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.FileSystem;

public final class RealFileSystem
implements FileSystem {
    private static final Logger log = Logger.getLogger("org.jboss.vfs.real");
    private static final boolean NEEDS_CONVERSION = File.separatorChar != '/';
    private final File realRoot;
    private final boolean privileged;

    public RealFileSystem(File realRoot) {
        this(realRoot, true);
    }

    public RealFileSystem(File realRoot, boolean privileged) {
        SecurityManager sm;
        if (privileged && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new FilePermission(new File(realRoot, "-").getPath(), "read,delete"));
        }
        this.realRoot = realRoot;
        this.privileged = privileged;
        log.tracef("Constructed real %s filesystem at root %s", (Object)(privileged ? "privileged" : "unprivileged"), (Object)realRoot);
    }

    private static <T> T doIoPrivileged(PrivilegedExceptionAction<T> action) throws IOException {
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pe) {
            try {
                throw pe.getException();
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
    }

    @Override
    public InputStream openInputStream(final VirtualFile mountPoint, final VirtualFile target) throws IOException {
        return this.privileged ? RealFileSystem.doIoPrivileged(new PrivilegedExceptionAction<InputStream>(){

            @Override
            public InputStream run() throws Exception {
                return new FileInputStream(RealFileSystem.this.getFile(mountPoint, target));
            }
        }) : new FileInputStream(this.getFile(mountPoint, target));
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public File getFile(VirtualFile mountPoint, VirtualFile target) {
        if (mountPoint.equals(target)) {
            return this.realRoot;
        }
        if (NEEDS_CONVERSION) {
            return new File(this.realRoot, target.getPathNameRelativeTo(mountPoint).replace('/', File.separatorChar));
        }
        return new File(this.realRoot, target.getPathNameRelativeTo(mountPoint));
    }

    @Override
    public boolean delete(VirtualFile mountPoint, VirtualFile target) {
        final File file = this.getFile(mountPoint, target);
        return this.privileged ? AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.delete();
            }
        }).booleanValue() : file.delete();
    }

    @Override
    public long getSize(VirtualFile mountPoint, VirtualFile target) {
        final File file = this.getFile(mountPoint, target);
        return this.privileged ? AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return file.length();
            }
        }).longValue() : file.length();
    }

    @Override
    public long getLastModified(VirtualFile mountPoint, VirtualFile target) {
        final File file = this.getFile(mountPoint, target);
        return this.privileged ? AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return file.lastModified();
            }
        }).longValue() : file.lastModified();
    }

    @Override
    public boolean exists(VirtualFile mountPoint, VirtualFile target) {
        final File file = this.getFile(mountPoint, target);
        return this.privileged ? AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        }).booleanValue() : file.exists();
    }

    @Override
    public boolean isFile(VirtualFile mountPoint, VirtualFile target) {
        final File file = this.getFile(mountPoint, target);
        return this.privileged ? AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isFile();
            }
        }).booleanValue() : file.isFile();
    }

    @Override
    public boolean isDirectory(VirtualFile mountPoint, VirtualFile target) {
        final File file = this.getFile(mountPoint, target);
        return this.privileged ? AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isDirectory();
            }
        }).booleanValue() : file.isDirectory();
    }

    @Override
    public List<String> getDirectoryEntries(VirtualFile mountPoint, VirtualFile target) {
        final File file = this.getFile(mountPoint, target);
        String[] names = this.privileged ? AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return file.list();
            }
        }) : file.list();
        return names == null ? Collections.emptyList() : Arrays.asList(names);
    }

    @Override
    public CodeSigner[] getCodeSigners(VirtualFile mountPoint, VirtualFile target) {
        return null;
    }

    @Override
    public File getMountSource() {
        return this.realRoot;
    }

    @Override
    public URI getRootURI() throws URISyntaxException {
        return this.realRoot.toURI();
    }

    @Override
    public void close() throws IOException {
    }
}

