/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.ExpressionFactoryWrapper;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.web.common.WebComponentDescription;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.webtier.jsp.JspInitializationListener;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.weld.servlet.ConversationFilter;
import org.jboss.weld.servlet.WeldListener;

public class WebIntegrationProcessor
implements DeploymentUnitProcessor {
    private final ListenerMetaData WBL = new ListenerMetaData();
    private final FilterMetaData conversationFilterMetadata;
    private static final String WELD_LISTENER = WeldListener.class.getName();
    private static final String WELD_SERVLET_LISTENER = "org.jboss.weld.environment.servlet.Listener";
    private static final String CONVERSATION_FILTER_CLASS = ConversationFilter.class.getName();
    private static final String CONVERSATION_FILTER_NAME = "CDI Conversation Filter";
    private static final ParamValueMetaData CONVERSATION_FILTER_INITIALIZED = new ParamValueMetaData();

    public WebIntegrationProcessor() {
        this.WBL.setListenerClass(WELD_LISTENER);
        this.conversationFilterMetadata = new FilterMetaData();
        this.conversationFilterMetadata.setFilterClass(CONVERSATION_FILTER_CLASS);
        this.conversationFilterMetadata.setFilterName(CONVERSATION_FILTER_NAME);
        this.conversationFilterMetadata.setAsyncSupported(true);
        CONVERSATION_FILTER_INITIALIZED.setParamName(ConversationFilter.CONVERSATION_FILTER_REGISTERED);
        CONVERSATION_FILTER_INITIALIZED.setParamValue(Boolean.TRUE.toString());
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription module = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (!WeldDeploymentMarker.isWeldDeployment(deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            WeldLogger.DEPLOYMENT_LOGGER.debug("Not installing Weld web tier integration as no war metadata found");
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            WeldLogger.DEPLOYMENT_LOGGER.debug("Not installing Weld web tier integration as no merged web metadata found");
            return;
        }
        ArrayList<ListenerMetaData> listeners = webMetaData.getListeners();
        if (listeners == null) {
            listeners = new ArrayList<ListenerMetaData>();
            webMetaData.setListeners(listeners);
        } else {
            ListIterator iterator = listeners.listIterator();
            while (iterator.hasNext()) {
                ListenerMetaData listener = (ListenerMetaData)iterator.next();
                if (!listener.getListenerClass().trim().equals(WELD_SERVLET_LISTENER)) continue;
                WeldLogger.DEPLOYMENT_LOGGER.debugf("Removing weld servlet listener %s from web config, as it is not needed in EE6 environments", WELD_SERVLET_LISTENER);
                iterator.remove();
                break;
            }
        }
        listeners.add(0, this.WBL);
        this.registerAsComponent(WELD_LISTENER, module, deploymentUnit, applicationClasses);
        deploymentUnit.addToAttachmentList(ExpressionFactoryWrapper.ATTACHMENT_KEY, (Object)JspInitializationListener.INSTANCE);
        if (webMetaData.getFilterMappings() != null) {
            boolean filterMappingFound = false;
            for (FilterMappingMetaData mapping : webMetaData.getFilterMappings()) {
                if (!CONVERSATION_FILTER_NAME.equals(mapping.getFilterName())) continue;
                filterMappingFound = true;
                break;
            }
            if (filterMappingFound) {
                boolean filterFound = false;
                for (FilterMetaData filter : webMetaData.getFilters()) {
                    if (!CONVERSATION_FILTER_CLASS.equals(filter.getFilterClass())) continue;
                    filterFound = true;
                    break;
                }
                if (!filterFound) {
                    if (webMetaData.getFilters() == null) {
                        webMetaData.setFilters(new FiltersMetaData());
                    }
                    webMetaData.getFilters().add((MappableMetaData)this.conversationFilterMetadata);
                    this.registerAsComponent(CONVERSATION_FILTER_CLASS, module, deploymentUnit, applicationClasses);
                    List contextParams = webMetaData.getContextParams();
                    if (contextParams == null) {
                        webMetaData.setContextParams(new ArrayList());
                    }
                    webMetaData.getContextParams().add(CONVERSATION_FILTER_INITIALIZED);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void registerAsComponent(String listener, EEModuleDescription module, DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses) {
        WebComponentDescription componentDescription = new WebComponentDescription(listener, listener, module, deploymentUnit.getServiceName(), applicationClasses);
        module.addComponent((ComponentDescription)componentDescription);
        deploymentUnit.addToAttachmentList(WebComponentDescription.WEB_COMPONENTS, (Object)componentDescription.getStartServiceName());
    }
}

