/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.discovery;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.discovery.AnnotationType;
import org.jboss.as.weld.discovery.IndexAdapter;
import org.jboss.as.weld.discovery.RequiredAnnotationTargetDiscovery;
import org.jboss.as.weld.util.Indices;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.resources.spi.AnnotationDiscovery;
import org.jboss.weld.resources.spi.ExtendedAnnotationDiscovery;

public class WeldAnnotationDiscovery
implements ExtendedAnnotationDiscovery,
BootstrapService {
    private static final DotName INHERITED_NAME = DotName.createSimple((String)Inherited.class.getName());
    private CompositeIndex index;
    private final RequiredAnnotationTargetDiscovery helper;
    private final LoadingCache<Class<? extends Annotation>, Set<String>> affectedClasses = CacheBuilder.newBuilder().build((CacheLoader)new LoadAffectedClassNames());
    private final LoadingCache<Class<? extends Annotation>, Set<AnnotationType>> annotatedAnnotations = CacheBuilder.newBuilder().build((CacheLoader)new LoadAnnotatedAnnotations());

    public WeldAnnotationDiscovery(CompositeIndex index) {
        this.index = index;
        this.helper = new RequiredAnnotationTargetDiscovery(IndexAdapter.forCompositeIndex(index));
    }

    public boolean containsAnnotation(Class<?> javaClass, Class<? extends Annotation> annotation) {
        if (this.index == null) {
            throw WeldMessages.MESSAGES.cannotUseAtRuntime(AnnotationDiscovery.class.getSimpleName());
        }
        try {
            return ((Set)this.affectedClasses.get(annotation)).contains(javaClass.getName());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getAnnotationsAnnotatedWith(Class<? extends Annotation> annotation) {
        if (this.index == null) {
            throw WeldMessages.MESSAGES.cannotUseAtRuntime(ExtendedAnnotationDiscovery.class.getSimpleName());
        }
        try {
            return ImmutableSet.copyOf((Collection)Collections2.transform((Collection)((Collection)this.annotatedAnnotations.get(annotation)), AnnotationType.TO_FQCN));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanupAfterBoot() {
        this.affectedClasses.cleanUp();
        this.annotatedAnnotations.cleanUp();
        this.index = null;
    }

    public void cleanup() {
        this.cleanupAfterBoot();
    }

    private class LoadAnnotatedAnnotations
    extends CacheLoader<Class<? extends Annotation>, Set<AnnotationType>> {
        private LoadAnnotatedAnnotations() {
        }

        public Set<AnnotationType> load(Class<? extends Annotation> key) throws Exception {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (AnnotationInstance instance : WeldAnnotationDiscovery.this.index.getAnnotations(DotName.createSimple((String)key.getName()))) {
                ClassInfo clazz;
                AnnotationTarget target = instance.target();
                if (!(target instanceof ClassInfo) || !Indices.isAnnotation(clazz = (ClassInfo)target)) continue;
                builder.add((Object)new AnnotationType(clazz.name(), clazz.annotations().containsKey(INHERITED_NAME)));
            }
            return builder.build();
        }
    }

    private class LoadAffectedClassNames
    extends CacheLoader<Class<? extends Annotation>, Set<String>> {
        private LoadAffectedClassNames() {
        }

        public Set<String> load(Class<? extends Annotation> key) throws Exception {
            HashSet<AnnotationType> firstLevelAnnotations = new HashSet<AnnotationType>((Collection)WeldAnnotationDiscovery.this.annotatedAnnotations.get(key));
            firstLevelAnnotations.add(new AnnotationType(DotName.createSimple((String)key.getName()), key.isAnnotationPresent(Inherited.class)));
            List<ClassInfo> affectedClasses = WeldAnnotationDiscovery.this.helper.getAffectedClasses(firstLevelAnnotations);
            return ImmutableSet.copyOf((Collection)Collections2.transform(affectedClasses, Indices.CLASS_INFO_TO_FQCN));
        }
    }
}

