/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.impl;

import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.jboss.as.clustering.web.BatchingManager;
import org.jboss.as.clustering.web.impl.ClusteringWebLogger;
import org.jboss.as.clustering.web.impl.ClusteringWebMessages;

public class TransactionBatchingManager
implements BatchingManager {
    private final TransactionManager tm;

    public TransactionBatchingManager(TransactionManager tm) {
        this.tm = tm;
    }

    @Override
    public boolean isBatchInProgress() throws Exception {
        return this.tm.getTransaction() != null;
    }

    @Override
    public void startBatch() throws Exception {
        this.tm.begin();
    }

    @Override
    public void setBatchRollbackOnly() throws Exception {
        this.tm.setRollbackOnly();
    }

    @Override
    public void endBatch() {
        try {
            if (this.tm.getTransaction().getStatus() != 1) {
                this.tm.commit();
            } else {
                ClusteringWebLogger.ROOT_LOGGER.debug("endBatch(): rolling back batch");
                this.tm.rollback();
            }
        }
        catch (RollbackException e) {
            ClusteringWebLogger.ROOT_LOGGER.rollingBackTransaction(e, "endBatch()");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ClusteringWebMessages.MESSAGES.caughtExceptionEndingBatch(e, "endTransaction()");
        }
    }
}

