/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework;

import java.io.File;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.bundle.FindHook;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.wiring.BundleRevision;

@MessageLogger(projectCode="JBOSGI")
public interface FrameworkLogger
extends BasicLogger {
    public static final FrameworkLogger LOGGER = (FrameworkLogger)Logger.getMessageLogger(FrameworkLogger.class, (String)"org.jboss.osgi.framework");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11000, value="OSGi Framework started")
    public void infoFrameworkStarted();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11001, value="Bundle installed: %s")
    public void infoBundleInstalled(Bundle var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11002, value="Bundle started: %s")
    public void infoBundleStarted(Bundle var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11003, value="Bundle stopped: %s")
    public void infoBundleStopped(Bundle var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11004, value="Bundle updated: %s")
    public void infoBundleUpdated(Bundle var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11005, value="Bundle uninstalled: %s")
    public void infoBundleUninstalled(Bundle var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11006, value="OSGi Framework - %s")
    public void infoFrameworkImplementation(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11007, value="Increasing start level from %d to %d")
    public void infoIncreasingStartLevel(int var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11008, value="Decreasing start level from %d to %d")
    public void infoDecreasingStartLevel(int var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11009, value="Starting bundle due to start level change: %s")
    public void infoStartingBundleDueToStartLevel(Bundle var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11010, value="Stopping bundle due to start level change: %s")
    public void infoStoppingBundleDueToStartLevel(Bundle var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11011, value="Starting bundles for start level: %d")
    public void infoStartingBundlesForStartLevel(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11012, value="Stopping bundles for start level: %d")
    public void infoStoppingBundlesForStartLevel(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11014, value="Cannot process metadata from properties: %s")
    public void warnCannotProcessMetadataProperties(@Cause Throwable var1, VirtualFile var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11015, value="Error while firing bundle event %s for: %s")
    public void warnErrorWhileFiringBundleEvent(@Cause Throwable var1, String var2, Bundle var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11016, value="Framework Warning")
    public void warnFrameworkEvent(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11017, value="Error while firing %s event")
    public void warnErrorWhileFiringEvent(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11018, value="Error while firing service event %s for: %s")
    public void warnErrorWhileFiringServiceEvent(@Cause Throwable var1, String var2, ServiceReference<?> var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11019, value="Error while calling event hook: %s")
    public void warnErrorWhileCallingEventHook(@Cause Throwable var1, EventHook var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11020, value="Error while calling find hook: %s")
    public void warnErrorWhileCallingFindHook(@Cause Throwable var1, org.osgi.framework.hooks.service.FindHook var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11021, value="Cannot acquire %s lock on: %s")
    public void errorCannotAquireBundleLock(String var1, Bundle var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11022, value="Cannot write persistent storage: %s")
    public void errorCannotWritePersistentStorage(@Cause Throwable var1, File var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11023, value="Cannot start bundle: %s")
    public void errorCannotStartBundle(@Cause Throwable var1, Bundle var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11024, value="Invalid beginning start level: %s")
    public void errorInvalidBeginningStartLevel(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11025, value="Error processing service listener hook: %s")
    public void errorProcessingServiceListenerHook(@Cause Throwable var1, ListenerHook var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11026, value="Framework Error")
    public void errorFrameworkEvent(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11027, value="Cannot update framework")
    public void errorCannotUpdateFramework(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11028, value="Cannot get resources '%s' from: %s")
    public void errorCannotGetResources(@Cause Throwable var1, String var2, BundleRevision var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11029, value="Cannot activate bundle lazily: %s")
    public void errorCannotActivateBundleLazily(@Cause Throwable var1, Bundle var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11030, value="Cannot provide native library location for: %s")
    public void errorCannotProvideNativeLibraryLocation(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11031, value="Cannot get entry '%s' from: %s")
    public void errorCannotGetEntry(@Cause Throwable var1, String var2, BundleRevision var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11032, value="Cannot obtain class loader for: %s")
    public void errorCannotObtainClassLoader(@Cause Throwable var1, BundleRevision var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11033, value="Cannot remove service: %s")
    public void errorCannotRemoveService(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11034, value="Service interface [%s] loaded from [%s] is not assignable from [%s] loaded from [%s]")
    public void errorServiceNotAssignable(String var1, ClassLoader var2, String var3, ClassLoader var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11035, value="Cannot load [%s] from: %s")
    public void errorCannotLoadService(String var1, Bundle var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11036, value="Cannot get class path entry '%s' from: %s")
    public void errorCannotGetClassPathEntry(@Cause Throwable var1, String var2, BundleRevision var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11037, value="Cannot install initial bundle: %s")
    public void errorStateCannotInstallInitialBundle(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11038, value="Error while calling event listener hook: %s")
    public void warnErrorWhileCallingEventListenerHook(@Cause Throwable var1, EventListenerHook var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11039, value="Error while calling bundle find hook: %s")
    public void warnErrorWhileCallingBundleFindHook(@Cause Throwable var1, FindHook var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11040, value="Error while calling bundle event hook: %s")
    public void warnErrorWhileCallingBundleEventHook(@Cause Throwable var1, org.osgi.framework.hooks.bundle.EventHook var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11041, value="Error while calling resolver hook method '%s': %s")
    public void warnErrorWhileCallingResolverHookMethod(@Cause Throwable var1, String var2, ResolverHook var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11042, value="Cannot uninstall bundle: %s")
    public void errorCannotUninstallBundle(@Cause Throwable var1, Bundle var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11043, value="Bundle refreshed: %s")
    public void infoBundleRefreshed(Bundle var1);
}

