/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.spi.FrameworkModuleLoader;
import org.jboss.osgi.framework.spi.FutureServiceValue;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;

public final class FrameworkModuleLoaderImpl
extends ModuleLoader
implements FrameworkModuleLoader {
    private final Map<ModuleIdentifier, ModuleHolder> moduleSpecs = new ConcurrentHashMap<ModuleIdentifier, ModuleHolder>();
    private final ServiceRegistry serviceRegistry;

    public FrameworkModuleLoaderImpl(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return this;
    }

    @Override
    public void addIntegrationDependencies(FrameworkModuleLoader.ModuleSpecBuilderContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Map<ModuleIdentifier, ModuleHolder> map = this.moduleSpecs;
        synchronized (map) {
            ModuleHolder moduleHolder = this.moduleSpecs.get(identifier);
            return moduleHolder != null ? moduleHolder.getModuleSpec() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Module module = null;
        Map<ModuleIdentifier, ModuleHolder> map = this.moduleSpecs;
        synchronized (map) {
            ModuleHolder moduleHolder = this.moduleSpecs.get(identifier);
            if (moduleHolder != null && (module = moduleHolder.getModule()) == null) {
                module = this.loadModuleLocal(identifier);
                moduleHolder.setModule(module);
            }
        }
        return module;
    }

    @Override
    public ModuleIdentifier getModuleIdentifier(XBundleRevision brev) {
        XBundle bundle2 = brev.getBundle();
        StorageState storageState = (StorageState)brev.getAttachment(IntegrationConstants.STORAGE_STATE_KEY);
        int revisionId = storageState.getRevisionId();
        String bundleId = "bid" + bundle2.getBundleId() + "rev" + revisionId;
        String bsname = bundle2.getSymbolicName();
        Version version = bundle2.getVersion();
        return ModuleIdentifier.create((String)("jbosgi." + bsname), (String)(version + "." + bundleId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModuleSpec(XBundleRevision brev, ModuleSpec moduleSpec) {
        Map<ModuleIdentifier, ModuleHolder> map = this.moduleSpecs;
        synchronized (map) {
            FrameworkLogger.LOGGER.tracef("addModule: %s", moduleSpec.getModuleIdentifier());
            ModuleIdentifier identifier = moduleSpec.getModuleIdentifier();
            if (this.moduleSpecs.get(identifier) != null) {
                throw FrameworkMessages.MESSAGES.illegalStateModuleAlreadyExists(identifier);
            }
            ModuleHolder moduleHolder = new ModuleHolder(moduleSpec);
            this.moduleSpecs.put(identifier, moduleHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModule(XBundleRevision brev, Module module) {
        Map<ModuleIdentifier, ModuleHolder> map = this.moduleSpecs;
        synchronized (map) {
            FrameworkLogger.LOGGER.tracef("addModule: %s", module.getIdentifier());
            ModuleIdentifier identifier = module.getIdentifier();
            if (this.moduleSpecs.get(identifier) != null) {
                throw FrameworkMessages.MESSAGES.illegalStateModuleAlreadyExists(identifier);
            }
            ModuleHolder moduleHolder = new ModuleHolder(module);
            this.moduleSpecs.put(identifier, moduleHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModule(XBundleRevision brev) {
        Map<ModuleIdentifier, ModuleHolder> map = this.moduleSpecs;
        synchronized (map) {
            ModuleIdentifier identifier = brev.getModuleIdentifier();
            FrameworkLogger.LOGGER.tracef("removeModule: %s", identifier);
            this.moduleSpecs.remove(identifier);
            ServiceController moduleService = this.serviceRegistry.getService(this.getModuleServiceName(identifier));
            if (moduleService != null) {
                moduleService.setMode(ServiceController.Mode.REMOVE);
            }
            try {
                Module module = this.loadModuleLocal(identifier);
                if (module != null) {
                    this.unloadModuleLocal(module);
                }
            }
            catch (ModuleLoadException ex) {
                // empty catch block
            }
        }
    }

    @Override
    public ServiceName createModuleService(XBundleRevision brev, List<BundleWire> wires) {
        ModuleIdentifier identifier = brev.getModuleIdentifier();
        ServiceName moduleServiceName = this.getModuleServiceName(identifier);
        ServiceController controller = this.serviceRegistry.getService(moduleServiceName);
        if (controller != null) {
            FutureServiceValue future = new FutureServiceValue(controller, ServiceController.State.REMOVED);
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            Module module = this.loadModule(identifier);
            ValueService service = new ValueService((Value)new ImmediateValue((Object)module));
            ServiceTarget serviceTarget = UserBundleRevision.assertBundleRevision((BundleRevision)brev).getServiceTarget();
            ServiceBuilder builder = serviceTarget.addService(moduleServiceName, (Service)service);
            builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            builder.install();
        }
        catch (ModuleLoadException ex) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotLoadModule(ex, identifier);
        }
        return moduleServiceName;
    }

    @Override
    public ServiceName getModuleServiceName(ModuleIdentifier identifier) {
        return IntegrationServices.MODULE_SERVICE.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    public String toString() {
        return FrameworkModuleLoaderImpl.class.getSimpleName();
    }

    static class ModuleHolder {
        private ModuleSpec moduleSpec;
        private Module module;

        ModuleHolder(ModuleSpec moduleSpec) {
            assert (moduleSpec != null) : "Null moduleSpec";
            this.moduleSpec = moduleSpec;
        }

        ModuleHolder(Module module) {
            assert (module != null) : "Null module";
            this.module = module;
        }

        ModuleSpec getModuleSpec() {
            return this.moduleSpec;
        }

        Module getModule() {
            return this.module;
        }

        void setModule(Module module) {
            this.module = module;
        }
    }
}

